/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AntArtifactChooser
extends JPanel
implements PropertyChangeListener {
    private String[] artifactType;
    private JLabel jLabelJarFiles;
    private JLabel jLabelName;
    private JList jListArtifacts;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldName;

    public AntArtifactChooser(String[] artifactType, JFileChooser chooser) {
        this.artifactType = artifactType;
        this.initComponents();
        this.jListArtifacts.setModel(new DefaultListModel());
        chooser.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelJarFiles = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListArtifacts = new JList();
        this.setLayout(new GridBagLayout());
        this.jLabelName.setText(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_ProjectName_JLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.jLabelName, gridBagConstraints);
        this.jTextFieldName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabelJarFiles.setText(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_ProjectJarFiles_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.jLabelJarFiles, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jListArtifacts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("SelectedFileChangedProperty".equals(e.getPropertyName())) {
            JFileChooser chooser = (JFileChooser)e.getSource();
            File dir = chooser.getSelectedFile();
            Project project = dir == null ? null : this.getProject(FileUtil.normalizeFile((File)dir));
            this.populateAccessory(project);
        }
    }

    private Project getProject(File projectDir) {
        try {
            projectDir = FileUtil.normalizeFile((File)projectDir);
            FileObject fo = FileUtil.toFileObject((File)projectDir);
            if (fo != null) {
                Project project = ProjectManager.getDefault().findProject(fo);
                return project;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void populateAccessory(Project project) {
        DefaultListModel model = (DefaultListModel)this.jListArtifacts.getModel();
        model.clear();
        this.jTextFieldName.setText(project == null ? "" : ProjectUtils.getInformation((Project)project).getDisplayName());
        if (project != null) {
            for (int j = 0; j < this.artifactType.length; ++j) {
                AntArtifact[] artifacts = AntArtifactQuery.findArtifactsByType((Project)project, (String)this.artifactType[j]);
                for (int i = 0; i < artifacts.length; ++i) {
                    model.addElement(new ArtifactItem(artifacts[i]));
                }
                if (artifacts.length <= 0) continue;
                return;
            }
        }
    }

    public static AntArtifact[] showDialog(String artifactType, Project master) {
        return AntArtifactChooser.showDialog(master, new String[]{artifactType});
    }

    public static AntArtifact[] showDialog(Project master, String[] artifactTypes) {
        JFileChooser chooser = ProjectChooser.projectChooser();
        chooser.setDialogTitle(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_Title"));
        chooser.setApproveButtonText(NbBundle.getMessage(AntArtifactChooser.class, (String)"LBL_AACH_SelectProject"));
        AntArtifactChooser accessory = new AntArtifactChooser(artifactTypes, chooser);
        chooser.setAccessory(accessory);
        chooser.setPreferredSize(new Dimension(650, 360));
        int option = chooser.showOpenDialog(null);
        if (option == 0) {
            File dir = chooser.getSelectedFile();
            Project selectedProject = accessory.getProject(dir = FileUtil.normalizeFile((File)dir));
            if (selectedProject == null) {
                return null;
            }
            if (selectedProject.getProjectDirectory().equals(master.getProjectDirectory())) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AntArtifactChooser.class, (String)"MSG_AACH_RefToItself"), 1));
                return null;
            }
            if (ProjectUtils.hasSubprojectCycles((Project)master, (Project)selectedProject)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AntArtifactChooser.class, (String)"MSG_AACH_Cycles"), 1));
                return null;
            }
            DefaultListModel model = (DefaultListModel)accessory.jListArtifacts.getModel();
            AntArtifact[] artifacts = new AntArtifact[model.size()];
            for (int i = 0; i < artifacts.length; ++i) {
                artifacts[i] = ((ArtifactItem)model.getElementAt(i)).getArtifact();
            }
            return artifacts;
        }
        return null;
    }

    private static class ArtifactItem {
        private AntArtifact artifact;

        ArtifactItem(AntArtifact artifact) {
            this.artifact = artifact;
        }

        AntArtifact getArtifact() {
            return this.artifact;
        }

        public String toString() {
            return this.artifact.getArtifactLocations()[0].toString();
        }
    }
}

