/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.ResultsPanel;
import org.openide.util.NbBundle;

class ResultListCellRenderer
extends JPanel
implements ListCellRenderer {
    static final long serialVersionUID = -3181200208271061471L;
    private static final String SPACE = " ";
    private static final String BAD_DOWNLOAD = " " + ResultListCellRenderer.getBundle("CTL_BAD_DOWNLOAD") + " ";
    private static final String CORRUPTED = " " + ResultListCellRenderer.getBundle("CTL_CORRUPTED") + " ";
    private static final String NOT_SIGNED = " " + ResultListCellRenderer.getBundle("CTL_NOT_SIGNED") + " ";
    private static final String SIGNED = " " + ResultListCellRenderer.getBundle("CTL_SIGNED") + " ";
    private static final String TRUSTED = " " + ResultListCellRenderer.getBundle("CTL_TRUSTED") + " ";
    private static ResultListCellRenderer renderer = null;
    private JCheckBox globalCheckBox;
    private JCheckBox includeCheckBox;
    private JLabel nameLabel;
    private JLabel securityLabel;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (renderer == null) {
            renderer = new ResultListCellRenderer();
        }
        ResultListCellRenderer.renderer.includeCheckBox.setSelected(((ModuleUpdate)value).isInstallApproved());
        ResultListCellRenderer.renderer.globalCheckBox.setSelected(((ModuleUpdate)value).isToInstallDir());
        String sec = "";
        switch (((ModuleUpdate)value).getSecurity()) {
            case 0: {
                sec = BAD_DOWNLOAD;
                break;
            }
            case 1: {
                sec = CORRUPTED;
                break;
            }
            case 2: {
                sec = NOT_SIGNED;
                break;
            }
            case 3: {
                StringBuffer sb = new StringBuffer(SIGNED);
                sb.append(SPACE + ResultListCellRenderer.getBundle("CTL_By"));
                Collection certs = ((ModuleUpdate)value).getCerts();
                Iterator it = certs.iterator();
                while (it.hasNext()) {
                    Certificate cert = (Certificate)it.next();
                    if (!(cert instanceof X509Certificate)) continue;
                    sb.append(SPACE).append(((X509Certificate)cert).getSubjectDN().getName());
                }
                sec = sb.toString();
                break;
            }
            case 4: {
                sec = TRUSTED;
            }
        }
        ResultListCellRenderer.renderer.nameLabel.setText(((ModuleUpdate)value).getName() + "  " + ResultListCellRenderer.getBundle("CTL_Version") + ((ModuleUpdate)value).getRemoteModule().getSpecificationVersion());
        ResultListCellRenderer.renderer.securityLabel.setText(sec);
        ResultListCellRenderer.renderer.includeCheckBox.getAccessibleContext().setAccessibleDescription(ResultListCellRenderer.renderer.nameLabel.getText());
        ResultListCellRenderer.renderer.includeCheckBox.setMnemonic(ResultListCellRenderer.getBundle("ACS_Include_Mnem").charAt(0));
        ResultListCellRenderer.renderer.globalCheckBox.getAccessibleContext().setAccessibleDescription(ResultListCellRenderer.getBundle("ACS_Global1") + ResultListCellRenderer.renderer.nameLabel.getText() + ResultListCellRenderer.getBundle("ACS_Global2"));
        ResultListCellRenderer.renderer.globalCheckBox.setMnemonic(ResultListCellRenderer.getBundle("ACS_Global_Mnem").charAt(0));
        if (isSelected) {
            renderer.setBackground((Color)UIManager.getDefaults().get("List.selectionBackground"));
            ResultListCellRenderer.renderer.nameLabel.setForeground((Color)UIManager.getDefaults().get("List.selectionForeground"));
            ResultListCellRenderer.renderer.securityLabel.setForeground((Color)UIManager.getDefaults().get("List.selectionForeground"));
            ResultListCellRenderer.renderer.includeCheckBox.setBackground((Color)UIManager.getDefaults().get("List.selectionBackground"));
            ResultListCellRenderer.renderer.includeCheckBox.setForeground((Color)UIManager.getDefaults().get("List.selectionForeground"));
            ResultListCellRenderer.renderer.globalCheckBox.setBackground((Color)UIManager.getDefaults().get("List.selectionBackground"));
            ResultListCellRenderer.renderer.globalCheckBox.setForeground((Color)UIManager.getDefaults().get("List.selectionForeground"));
        } else {
            renderer.setBackground((Color)UIManager.getDefaults().get("List.background"));
            ResultListCellRenderer.renderer.nameLabel.setForeground((Color)UIManager.getDefaults().get("List.Foreground"));
            ResultListCellRenderer.renderer.securityLabel.setForeground((Color)UIManager.getDefaults().get("List.Foreground"));
            ResultListCellRenderer.renderer.includeCheckBox.setBackground((Color)UIManager.getDefaults().get("List.background"));
            ResultListCellRenderer.renderer.includeCheckBox.setForeground((Color)UIManager.getDefaults().get("List.Foreground"));
            ResultListCellRenderer.renderer.globalCheckBox.setBackground((Color)UIManager.getDefaults().get("List.background"));
            ResultListCellRenderer.renderer.globalCheckBox.setForeground((Color)UIManager.getDefaults().get("List.Foreground"));
        }
        renderer.invalidate();
        return renderer;
    }

    public ResultListCellRenderer() {
        this.initComponents();
        this.nameLabel.setFont(ResultsPanel.doDeriveFont(this.nameLabel.getFont(), 1));
    }

    private void initComponents() {
        this.includeCheckBox = new JCheckBox();
        this.nameLabel = new JLabel();
        this.securityLabel = new JLabel();
        this.globalCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.includeCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.securityLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.globalCheckBox, gridBagConstraints);
    }

    boolean isIncludeCheckBoxSelected(MouseEvent evt) {
        return this.includeCheckBox.getX() + this.includeCheckBox.getWidth() >= evt.getX() && this.includeCheckBox.getX() <= evt.getX();
    }

    boolean isGlobalCheckBoxSelected(MouseEvent evt) {
        return this.globalCheckBox.getX() + this.globalCheckBox.getWidth() >= evt.getX() && this.globalCheckBox.getX() <= evt.getX();
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage((Class)ResultListCellRenderer.class, (String)key);
    }
}

