/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.jmi.reflect.JmiException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.modules.java.ui.nodes.elements.FieldCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class EnumConstantCustomizer
extends JPanel {
    private final JavaEnum jclass;
    private EnumConstant constant;
    private boolean isOK = true;
    private JLabel nameLabel;
    private JTextField nameTextField;

    public EnumConstantCustomizer(JavaEnum jclass, EnumConstant constant) {
        this.jclass = jclass;
        this.constant = constant;
        this.initComponents();
        this.nameTextField.setText(constant.getName());
        HelpCtx.setHelpIDString((JComponent)this, (String)"java.enumconstant.customizer");
        this.initAccessibility();
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        return this.isOK;
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(EnumConstantCustomizer.getString("ACSN_ConstantNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(EnumConstantCustomizer.getString("ACSD_ConstantNameTextField"));
        this.getAccessibleContext().setAccessibleDescription("ACSD_ConstantCustomizerDialog");
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)EnumConstantCustomizer.class, (String)key);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameLabel.setText(NbBundle.getMessage((Class)EnumConstantCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 0, 8);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField.setColumns(25);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                EnumConstantCustomizer.this.nameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 11);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.nameTextField, gridBagConstraints);
    }

    private void nameTextFieldFocusLost(FocusEvent evt) {
        if (evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent()))) {
            return;
        }
        String newName = this.nameTextField.getText().trim();
        String oldName = this.constant.getName();
        boolean ok = false;
        IllegalArgumentException x = null;
        if (!Utilities.isJavaIdentifier((String)newName)) {
            x = new IllegalArgumentException("Invalid name");
            ErrorManager.getDefault().annotate((Throwable)x, 256, null, NbBundle.getMessage((Class)FieldCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
        } else {
            if (oldName.equals(newName)) {
                return;
            }
            if (SourceEditSupport.findConstant(this.jclass, newName) != null) {
                x = new IllegalArgumentException("Invalid name");
                ErrorManager.getDefault().annotate((Throwable)x, 256, null, NbBundle.getMessage((Class)FieldCustomizer.class, (String)"MSG_Used_Identifier", (Object)newName), null, null);
            } else {
                try {
                    this.constant.setName(newName);
                    ok = true;
                }
                catch (JmiException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
        this.isOK = ok;
        if (!ok) {
            this.nameTextField.setText(oldName);
        }
        if (x != null) {
            ErrorManager.getDefault().notify((Throwable)x);
        }
    }
}

