/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.GenericElement;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.java.ui.nodes.editors.IdentifierArrayEditor;
import org.netbeans.modules.java.ui.nodes.editors.MethodParameterArrayEditor;
import org.netbeans.modules.java.ui.nodes.editors.TypeParameterArrayEditor;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.util.NbBundle;

public final class ElementFormat
extends Format {
    static final long serialVersionUID = 3775521938640169753L;
    private static final String PROPERTIES_NAMES_INDEX = "mnfCtrscpaieMT";
    private static final String[] PROPERTIES_NAMES = new String[]{"modifiers", "name", "name", "name", "type", "return", "superclass", "static", "parameters", "parameters", "interfaces", "exceptions", "modifiers", "typeParameters"};
    private static final byte STATUS_OUTSIDE = 0;
    private static final byte STATUS_INSIDE = 1;
    private static final byte STATUS_RBRACE = 2;
    private String pattern;
    private boolean source;
    private transient LinkedList list;

    public ElementFormat(String pattern) {
        this.applyPattern(pattern);
        this.source = true;
    }

    public void setSourceFormat(boolean source) {
        this.source = source;
    }

    public boolean isSourceFormat() {
        return this.source;
    }

    public String getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(Object o, StringBuffer toAppendTo, FieldPosition pos) {
        StringBuffer stringBuffer;
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            Element element = (Element)o;
            JavaModel.setClassPath((Resource)element.getResource());
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj instanceof String) {
                    toAppendTo.append((String)obj);
                    continue;
                }
                ((Tag)obj).format(element, toAppendTo);
            }
            stringBuffer = toAppendTo;
        }
        catch (Throwable throwable) {
            try {
                JavaModel.getJavaRepository().endTrans();
                throw throwable;
            }
            catch (ClassCastException e) {
                IllegalArgumentException iae = new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badArgument"));
                iae.initCause(e);
                throw iae;
            }
            catch (JmiException e) {
                IllegalArgumentException iae = new IllegalArgumentException("format failed");
                iae.initCause(e);
                throw iae;
            }
        }
        JavaModel.getJavaRepository().endTrans();
        return stringBuffer;
    }

    public String format(Element element) {
        return this.format(element, new StringBuffer(), null).toString();
    }

    public boolean dependsOnProperty(String prop) {
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            int index;
            Object obj = it.next();
            if (!(obj instanceof Tag) || !PROPERTIES_NAMES[index = PROPERTIES_NAMES_INDEX.indexOf(((Tag)obj).kind)].equals(prop)) continue;
            return true;
        }
        return false;
    }

    public Object parseObject(String source, ParsePosition status) {
        return null;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.applyPattern(this.pattern);
    }

    private void applyPattern(String pattern) {
        this.pattern = pattern;
        this.list = new LinkedList();
        int status = 0;
        StringTokenizer tokenizer = new StringTokenizer(pattern, "{}", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (status) {
                case 0: {
                    if (token.equals("}")) {
                        throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
                    }
                    if (token.equals("{")) {
                        status = 1;
                        break;
                    }
                    this.list.add(token);
                    break;
                }
                case 1: {
                    if (token.equals("{") || token.equals("}")) {
                        throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
                    }
                    this.list.add(this.createTag(token));
                    status = 2;
                    break;
                }
                case 2: {
                    if (!token.equals("}")) {
                        throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
                    }
                    status = 0;
                }
            }
        }
    }

    private Tag createTag(String s) {
        if (s.length() > 0) {
            char c = s.charAt(0);
            String[] params = new String[]{};
            if (s.length() > 1) {
                if (s.length() < 2 || s.charAt(1) != ',') {
                    throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
                }
                params = this.parseParams(s.substring(2));
            }
            if ("mnfCtrscM".indexOf(c) != -1) {
                switch (params.length) {
                    case 0: {
                        return new Tag(c, "", "");
                    }
                    case 2: {
                        return new Tag(c, params[0], params[1]);
                    }
                }
            } else if ("paieT".indexOf(c) != -1) {
                switch (params.length) {
                    case 0: {
                        return new ArrayTag(c, "", "", ", ");
                    }
                    case 2: {
                        return new ArrayTag(c, params[0], params[1], ", ");
                    }
                    case 3: {
                        return new ArrayTag(c, params[0], params[1], params[2]);
                    }
                }
            }
        }
        throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
    }

    private String[] parseParams(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, ",", true);
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer token = new StringBuffer();
        boolean comma = false;
        boolean inString = false;
        while (tokenizer.hasMoreTokens()) {
            String t = tokenizer.nextToken();
            if (inString) {
                token.append(t);
                if (!t.endsWith("\"")) continue;
                if (token.length() > 1) {
                    token.setLength(token.length() - 1);
                }
                list.add(token.toString());
                token.setLength(0);
                inString = false;
                comma = true;
                continue;
            }
            if (t.equals(",")) {
                if (comma) {
                    comma = false;
                    continue;
                }
                list.add("");
                continue;
            }
            if (comma) {
                throw new IllegalArgumentException(NbBundle.getMessage((Class)ElementFormat.class, (String)"MSG_badPattern"));
            }
            String stringToAdd = t;
            if (t.startsWith("\"")) {
                if (t.endsWith("\"") && t.length() > 1) {
                    stringToAdd = t.length() <= 2 ? "" : t.substring(1, t.length() - 1);
                } else {
                    token.append(t.substring(1));
                    inString = true;
                    continue;
                }
            }
            list.add(stringToAdd);
            comma = true;
            token.setLength(0);
        }
        if (!comma) {
            list.add("");
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }

    public static String elementName(NamedElement el) throws JmiException {
        if (el instanceof JavaClass) {
            return ((JavaClass)el).getSimpleName();
        }
        if (el instanceof Constructor) {
            JavaClass jc = (JavaClass)((Constructor)el).getDeclaringClass();
            return jc.getSimpleName();
        }
        return el.getName();
    }

    private static String elementFullName(NamedElement el) throws JmiException {
        if (el instanceof JavaClass) {
            return el.getName();
        }
        if (!(el instanceof ClassMember)) {
            return ElementFormat.elementName(el);
        }
        JavaClass jc = (JavaClass)((ClassMember)el).getDeclaringClass();
        StringBuffer fullName = new StringBuffer(30).append(jc.getName()).append('.');
        if (el instanceof Constructor) {
            fullName.append(jc.getSimpleName());
        } else {
            fullName.append(el.getName());
        }
        return fullName.toString();
    }

    private static void resolveClassName(JavaClass jc, StringBuffer sb) {
        ClassDefinition cd = jc.getDeclaringClass();
        if (!(cd instanceof JavaClass)) {
            sb.append(jc.getSimpleName());
            return;
        }
        ElementFormat.resolveClassName((JavaClass)cd, sb);
        sb.append('.').append(jc.getSimpleName());
    }

    public String toString() {
        return this.pattern;
    }

    private static final class ArrayTag
    extends Tag {
        String delim;
        static final long serialVersionUID = 2060398944304753010L;

        ArrayTag(char kind, String prefix, String suffix, String delim) {
            super(kind, prefix, suffix);
            this.delim = delim;
        }

        private void identifiers2String(List l, StringBuffer buf) throws JmiException {
            Iterator it = l.iterator();
            boolean toDelimit = false;
            while (it.hasNext()) {
                if (toDelimit) {
                    buf.append(this.delim);
                } else {
                    toDelimit = true;
                }
                MultipartId id = (MultipartId)it.next();
                buf.append(IdentifierArrayEditor.multipartIdToName(id));
            }
        }

        void format(Element element, StringBuffer buf) {
            try {
                int mark = buf.length();
                buf.append(this.prefix);
                switch (this.kind) {
                    case 'e': {
                        this.identifiers2String(((CallableFeature)element).getExceptionNames(), buf);
                        break;
                    }
                    case 'a': 
                    case 'p': {
                        if (element instanceof EnumConstant) {
                            ArrayTag.constantParams2String((EnumConstant)element, buf);
                            break;
                        }
                        List l = ((CallableFeature)element).getParameters();
                        buf.append(MethodParameterArrayEditor.params2String(l.toArray(new Parameter[0]), this.delim, this.kind == 'p'));
                        break;
                    }
                    case 'i': {
                        this.identifiers2String(((JavaClass)element).getInterfaceNames(), buf);
                        break;
                    }
                    case 'T': {
                        this.typeParams2String((GenericElement)element, buf);
                    }
                }
                if (buf.length() > mark + this.prefix.length()) {
                    buf.append(this.suffix);
                } else {
                    buf.setLength(mark);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$ui$nodes$elements$ElementFormat == null ? (class$org$netbeans$modules$java$ui$nodes$elements$ElementFormat = ElementFormat.class$("org.netbeans.modules.java.ui.nodes.elements.ElementFormat")) : class$org$netbeans$modules$java$ui$nodes$elements$ElementFormat), (String)"MSG_badPattern"));
            }
        }

        private static void constantParams2String(EnumConstant ec, StringBuffer sb) throws JmiException {
            String value = ec.getInitialValueText();
            sb.append(value != null ? value : "");
        }

        private void typeParams2String(GenericElement ge, StringBuffer sb) throws JmiException {
            TypeParameter[] tps = ge.getTypeParameters().toArray(new TypeParameter[0]);
            String s = TypeParameterArrayEditor.params2String(tps, this.delim);
            sb.append(s);
        }
    }

    private static class Tag
    implements Serializable {
        char kind;
        String prefix;
        String suffix;
        static final long serialVersionUID = 4946774706959011193L;

        Tag(char kind, String prefix, String suffix) {
            this.kind = kind;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        void format(Element element, StringBuffer buf) {
            try {
                int mark = buf.length();
                buf.append(this.prefix);
                switch (this.kind) {
                    case 'm': {
                        buf.append(Modifier.toString(((ClassMember)element).getModifiers() & 0xFFFFFDFF));
                        break;
                    }
                    case 'n': {
                        buf.append(ElementFormat.elementName((NamedElement)element));
                        break;
                    }
                    case 'f': {
                        buf.append(ElementFormat.elementFullName((NamedElement)element));
                        break;
                    }
                    case 'C': {
                        ElementFormat.resolveClassName((JavaClass)element, buf);
                        break;
                    }
                    case 't': {
                        buf.append(((TypedElement)element).getType().getName());
                        break;
                    }
                    case 'r': {
                        buf.append(((TypedElement)element).getType().getName());
                        break;
                    }
                    case 's': {
                        JavaClass superClass = ((JavaClass)element).getSuperClass();
                        if (superClass == null) break;
                        buf.append(ElementFormat.elementFullName((NamedElement)superClass));
                        break;
                    }
                    case 'c': {
                        int modifiers = ((Initializer)element).getModifiers();
                        if (!Modifier.isStatic(modifiers)) break;
                        buf.append(Modifier.toString(8));
                        break;
                    }
                    case 'M': {
                        buf.append(Modifier.isInterface(((ClassMember)element).getModifiers()) ? "interface" : "class");
                    }
                }
                if (buf.length() > mark + this.prefix.length()) {
                    buf.append(this.suffix);
                } else {
                    buf.setLength(mark);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$ui$nodes$elements$ElementFormat == null ? (class$org$netbeans$modules$java$ui$nodes$elements$ElementFormat = ElementFormat.class$("org.netbeans.modules.java.ui.nodes.elements.ElementFormat")) : class$org$netbeans$modules$java$ui$nodes$elements$ElementFormat), (String)"MSG_badPattern"));
            }
        }
    }
}

