/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

final class ChildrenProvider
implements Runnable {
    static final RequestProcessor RP = new RequestProcessor("Java Children Provider");
    private RequestProcessor.Task currentTask;
    private Map nodes = this.initNodeMap();
    private List elements;
    private final KeyHandler keyHandler;

    public ChildrenProvider(KeyHandler keyHandler) {
        this.keyHandler = keyHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Map nodesNew;
        List keys;
        JMManager.getTransactionMutex().addPriorityThread();
        try {
            keys = this.keyHandler.collectKeys();
            nodesNew = this.createNodeMap(this.nodes, keys);
        }
        catch (InvalidObjectException e) {
            keys = Collections.EMPTY_LIST;
            nodesNew = Collections.EMPTY_MAP;
        }
        catch (JmiException e) {
            keys = Collections.EMPTY_LIST;
            nodesNew = Collections.EMPTY_MAP;
            ErrorManager.getDefault().notify(16, (Throwable)e);
        }
        ChildrenProvider childrenProvider = this;
        synchronized (childrenProvider) {
            this.elements = keys;
            this.nodes = nodesNew;
        }
        this.presentKeys(keys, nodesNew);
    }

    private void presentKeys(List keys, Map nodesNew) {
        ArrayList<Node[]> nodes = new ArrayList<Node[]>(keys.size());
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Node[] ns = (Node[])nodesNew.get(key);
            nodes.add(ns);
        }
        this.keyHandler.presentKeys(keys, nodes);
    }

    private Map initNodeMap() {
        WeakHashMap nodesNew = new WeakHashMap();
        return nodesNew;
    }

    public synchronized void recomputeChildren() {
        if (this.currentTask == null) {
            this.currentTask = RP.post((Runnable)this);
        } else {
            this.currentTask.schedule(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNode(Object element) {
        Node[] ns = null;
        ChildrenProvider childrenProvider = this;
        synchronized (childrenProvider) {
            ns = (Node[])this.nodes.get(element);
        }
        return ns == null ? null : ns[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getKeys() {
        this.computeChildren();
        ChildrenProvider childrenProvider = this;
        synchronized (childrenProvider) {
            return this.elements;
        }
    }

    public void waitFinished() {
        this.computeChildren();
    }

    public void clear() {
        RP.post((Runnable)new CleanTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearImpl() {
        ChildrenProvider childrenProvider = this;
        synchronized (childrenProvider) {
            this.elements = Collections.EMPTY_LIST;
            this.nodes = Collections.EMPTY_MAP;
        }
        this.presentKeys(this.elements, this.nodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeChildren() {
        ChildrenProvider childrenProvider = this;
        synchronized (childrenProvider) {
            if (this.currentTask == null) {
                this.recomputeChildren();
            }
        }
        this.currentTask.waitFinished();
    }

    private Map createNodeMap(final Map nodes, final List keys) throws JmiException {
        final Map nodesNew = this.initNodeMap();
        if (keys.isEmpty()) {
            return nodesNew;
        }
        JmiException ex = (JmiException)((Object)Children.MUTEX.readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                try {
                    JMManager.getTransactionMutex().addPriorityThread();
                    JavaMetamodel.getDefaultRepository().beginTrans(false);
                    try {
                        Iterator it = keys.iterator();
                        while (it.hasNext()) {
                            Object key = it.next();
                            if (key instanceof Element && !((Element)key).isValid()) {
                                nodesNew.clear();
                                keys.clear();
                                Object var3_4 = null;
                                return var3_4;
                            }
                            Node[] ns = (Node[])nodes.get(key);
                            if (ns == null) {
                                ns = ChildrenProvider.this.keyHandler.prepareNodes(key);
                            }
                            nodesNew.put(key, ns);
                        }
                        return null;
                    }
                    finally {
                        JavaMetamodel.getDefaultRepository().endTrans();
                    }
                }
                catch (JmiException ex) {
                    return ex;
                }
            }
        }));
        if (ex != null) {
            throw ex;
        }
        return nodesNew;
    }

    private final class CleanTask
    implements Runnable {
        private CleanTask() {
        }

        public void run() {
            ChildrenProvider.this.clearImpl();
        }
    }

    static interface KeyHandler {
        public List collectKeys();

        public Node[] prepareNodes(Object var1);

        public void presentKeys(List var1, List var2);
    }
}

