/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import [Lorg.openide.src.Identifier;;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ClassCustomizer;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.MemberElementNode;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class ClassElementNode
extends MemberElementNode {
    private static final String[] ICON_AFFECTING_PROPERTIES = new String[]{"classOrInterface"};
    static /* synthetic */ Class class$org$openide$src$Element;

    public ClassElementNode(ClassElement element, Children children, boolean writeable) {
        super(element, children, writeable);
        this.setElementFormat0(element.isInterface() ? sourceOptions.getInterfaceElementFormat() : sourceOptions.getClassElementFormat());
    }

    public HelpCtx getHelpCtx() {
        if (((ClassElement)this.element).isClassOrInterface()) {
            return new HelpCtx("org.openide.src.nodes.ClassNode");
        }
        return new HelpCtx("org.openide.src.nodes.InterfaceNode");
    }

    protected String resolveIconBase() {
        return ((ClassElement)this.element).isInterface() ? "org/openide/src/resources/interface" : "org/openide/src/resources/class";
    }

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    protected ElementFormat getHintElementFormat() {
        return ((ClassElement)this.element).isInterface() ? sourceOptions.getInterfaceElementLongFormat() : sourceOptions.getClassElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createModifiersProperty(this.writeable));
        ps.put(this.createNameProperty(this.writeable));
        if (((ClassElement)this.element).isClass()) {
            ps.put(this.createSuperclassProperty(this.writeable));
        }
        ps.put(this.createInterfacesProperty(this.writeable));
        return sheet;
    }

    public void destroy() throws IOException {
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                ClassElement el = (ClassElement)ClassElementNode.this.element;
                if (el.getDeclaringClass() != null) {
                    el.getDeclaringClass().removeClass(el);
                } else {
                    el.getSource().removeClass(el);
                }
            }
        });
        super.destroy();
    }

    public Component getCustomizer() {
        return new ClassCustomizer((ClassElement)this.element);
    }

    public boolean hasCustomizer() {
        return this.isWriteable();
    }

    protected void createPasteTypes(Transferable t, List s) {
        if (this.isWriteable()) {
            if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                this.createMultiPasteTypes(t, s, 1);
                this.createMultiPasteTypes(t, s, 6);
                return;
            }
            for (int i = 0; i <= 1; ++i) {
                final boolean delete = i == 1;
                final Element addingElement = (Element)NodeTransfer.cookie((Transferable)t, (int)(delete ? 6 : 1), (Class)(class$org$openide$src$Element == null ? ClassElementNode.class$("org.openide.src.Element") : class$org$openide$src$Element));
                if (addingElement == null || !ClassElementNode.isValidElement(addingElement)) continue;
                s.add(new PasteType(){

                    public Transferable paste() throws IOException {
                        ClassElementNode.this.pasteElement(addingElement, delete);
                        return delete ? ExTransferable.EMPTY : null;
                    }
                });
            }
        }
        super.createPasteTypes(t, s);
    }

    private static boolean isValidElement(Element el) {
        Element.Impl2 impl = (Element.Impl2)el.getCookie(Element.Impl2.class);
        return impl == null || impl.isValid();
    }

    private void createMultiPasteTypes(Transferable t, List s, int action) {
        Element el;
        Node n;
        MultiTransferObject mto;
        try {
            mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
        }
        catch (UnsupportedFlavorException ex) {
            return;
        }
        catch (IOException ex) {
            return;
        }
        int count = mto.getCount();
        LinkedList candidates = new LinkedList();
        for (int i = 0; i < count && (n = NodeTransfer.node((Transferable)mto.getTransferableAt(i), (int)action)) != null && (el = (Element)n.getCookie(class$org$openide$src$Element == null ? ClassElementNode.class$("org.openide.src.Element") : class$org$openide$src$Element)) != null && ClassElementNode.isValidElement(el) && (el instanceof MemberElement || el instanceof InitializerElement); ++i) {
            this.addNodeCandidate(candidates, el);
        }
        if (candidates.isEmpty()) {
            return;
        }
        s.add(new SourceEditSupport.ClassMultiPasteType(this, candidates, (action & 6) > 0));
    }

    private void addNodeCandidate(Collection candidates, Element el) {
        ClassElement enc2 = this.findEnclosingClass(el);
        SourceElement enc2Src = enc2.getSource();
        String fn2 = enc2.getName().getFullName();
        Iterator it = candidates.iterator();
        while (it.hasNext()) {
            Element can = (Element)it.next();
            ClassElement enc1 = this.findEnclosingClass(can);
            if (enc1.getSource() != enc2Src) continue;
            if (enc1 == enc2) {
                if (can == enc1) {
                    return;
                }
                if (el != enc2) break;
                it.remove();
                continue;
            }
            String fn1 = enc1.getName().getFullName();
            if (fn2.startsWith(fn1)) {
                if (enc1 != can) continue;
                return;
            }
            if (!fn1.startsWith(fn2)) continue;
            if (enc2 != el) break;
            it.remove();
        }
        candidates.add(el);
    }

    private ClassElement findEnclosingClass(Element el) {
        if (el instanceof ClassElement) {
            return (ClassElement)el;
        }
        if (el instanceof MemberElement) {
            return ((MemberElement)el).getDeclaringClass();
        }
        if (el instanceof InitializerElement) {
            return ((InitializerElement)el).getDeclaringClass();
        }
        return null;
    }

    PropertyChangeListener createElementListener() {
        return new ClassElementListener();
    }

    void pasteElement(final Element addingElement, final boolean delete) throws IOException {
        final boolean[] cancelled = new boolean[]{false};
        if (addingElement instanceof ClassElement) {
            ClassElement declClazz = (ClassElement)addingElement;
            for (ClassElement myDecl = (ClassElement)this.element; myDecl != null; myDecl = myDecl.getDeclaringClass()) {
                if (declClazz != myDecl) continue;
                throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Recursion detected"), bundle.getString("ERR_RecursePaste"));
            }
        }
        SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

            public void run() throws SourceException {
                ClassElement clazz = (ClassElement)ClassElementNode.this.element;
                if (addingElement instanceof InitializerElement) {
                    InitializerElement e = (InitializerElement)addingElement;
                    clazz.addInitializer(e);
                }
                if (addingElement instanceof FieldElement) {
                    clazz.addField((FieldElement)addingElement);
                } else if (addingElement instanceof MethodElement) {
                    MethodElement me = (MethodElement)addingElement;
                    if (((ClassElement)ClassElementNode.this.element).isInterface()) {
                        if (delete && me.getBody() != null && !me.getBody().trim().equals("") && !ClassElementNode.this.isPastingConfirmed(me)) {
                            cancelled[0] = true;
                            return;
                        }
                        me = (MethodElement)me.clone();
                        me.setBody(null);
                    } else if (me.getBody() == null) {
                        me = (MethodElement)me.clone();
                        me.setBody("");
                    }
                    clazz.addMethod(me);
                } else if (addingElement instanceof ConstructorElement) {
                    clazz.addConstructor((ConstructorElement)addingElement);
                } else if (addingElement instanceof ClassElement) {
                    ClassElement pclass = (ClassElement)addingElement;
                    clazz.addClass(pclass);
                    ClassElement myClass = clazz.getClass(Identifier.create(pclass.getName().getName()));
                    if (pclass.getDeclaringClass() == null && myClass != null) {
                        myClass.setModifiers(myClass.getModifiers() | 8);
                    }
                }
            }
        });
        if (delete && !cancelled[0]) {
            ClassElement origClazz;
            SourceElement src = null;
            if (addingElement instanceof InitializerElement) {
                origClazz = ((InitializerElement)addingElement).getDeclaringClass();
            } else if (addingElement instanceof MemberElement) {
                origClazz = ((MemberElement)addingElement).getDeclaringClass();
                if (addingElement instanceof ClassElement) {
                    ClassElement me = (ClassElement)addingElement;
                    src = me.getSource();
                }
            } else {
                origClazz = null;
            }
            if (src == null && origClazz != null) {
                src = origClazz.getSource();
            }
            final SourceElement classSource = src;
            SourceEditSupport.ExceptionalRunnable r = new SourceEditSupport.ExceptionalRunnable(){

                public void run() throws SourceException {
                    if (addingElement instanceof InitializerElement) {
                        InitializerElement e = (InitializerElement)addingElement;
                        if (origClazz != null) {
                            origClazz.removeInitializer(e);
                        }
                    } else if (addingElement instanceof MemberElement) {
                        if (origClazz != null) {
                            if (addingElement instanceof FieldElement) {
                                origClazz.removeField((FieldElement)addingElement);
                            } else if (addingElement instanceof MethodElement) {
                                origClazz.removeMethod((MethodElement)addingElement);
                            } else if (addingElement instanceof ConstructorElement) {
                                origClazz.removeConstructor((ConstructorElement)addingElement);
                            } else if (addingElement instanceof ClassElement) {
                                origClazz.removeClass((ClassElement)addingElement);
                            }
                        } else if (addingElement instanceof ClassElement && classSource != null) {
                            classSource.removeClass((ClassElement)addingElement);
                        }
                    }
                }
            };
            if (src == null) {
                try {
                    r.run();
                }
                catch (SourceException e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                SourceEditSupport.invokeAtomicAsUser(addingElement, r);
            }
        }
    }

    private boolean isPastingConfirmed(MethodElement me) {
        String title = NbBundle.getMessage((Class)ClassElementNode.class, (String)"TIT_PastingMethod");
        String text = NbBundle.getMessage((Class)ClassElementNode.class, (String)"CONFIRM_DeleteMethodBody", (Object)me.getName());
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)text, title, 0);
        return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc));
    }

    protected Node.Property createSuperclassProperty(boolean canW) {
        return new ElementNode.ElementProp("superclass", String.class, canW){

            public Object getValue() {
                Identifier id = ((ClassElement)ClassElementNode.this.element).getSuperclass();
                return id == null ? "" : id.getFullName();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                Type t;
                super.setValue(val);
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException();
                }
                final String str = ((String)val).trim();
                if (str != null && !"".equals(str) && !(t = Type.parse(str)).isClass()) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ClassElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        Identifier superclass = str.equals("") ? null : Identifier.create(str);
                        ((ClassElement)(this).ClassElementNode.this.element).setSuperclass(superclass);
                    }
                });
            }
        };
    }

    protected Node.Property createInterfacesProperty(boolean canW) {
        ElementNode.ElementProp prop = new ElementNode.ElementProp("interfaces", Identifier;.class, canW){

            public Object getValue() {
                return ((ClassElement)ClassElementNode.this.element).getInterfaces();
            }

            public void setValue(final Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Identifier[])) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ClassElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        ((ClassElement)(this).ClassElementNode.this.element).setInterfaces((Identifier[])val);
                    }
                });
            }
        };
        if (((ClassElement)this.element).isInterface()) {
            prop.setDisplayName(bundle.getString("PROP_superInterfaces"));
            prop.setShortDescription(bundle.getString("HINT_superInterfaces"));
        }
        prop.setValue("changeImmediate", Boolean.FALSE);
        return prop;
    }

    public NewType[] getNewTypes() {
        if (this.writeable) {
            return SourceEditSupport.createNewTypes((ClassElement)this.element);
        }
        return super.getNewTypes();
    }

    public Transferable clipboardCopy() {
        ExTransferable.Single t = NodeTransfer.transferable((Node)this, (int)1);
        ExTransferable xt = ExTransferable.create((Transferable)t);
        xt.put(NodeTransfer.createPaste((NodeTransfer.Paste)new SourceEditSupport.PackagePaste((ClassElement)this.element, false)));
        return xt;
    }

    public Transferable clipboardCut() {
        ExTransferable.Single t = NodeTransfer.transferable((Node)this, (int)4);
        ExTransferable xt = ExTransferable.create((Transferable)t);
        xt.put(NodeTransfer.createPaste((NodeTransfer.Paste)new SourceEditSupport.PackagePaste((ClassElement)this.element, true)));
        return xt;
    }

    private class ClassElementListener
    extends ElementNode.ElementListener {
        private ClassElementListener() {
            super(ClassElementNode.this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("classOrInterface")) {
                ClassElementNode.this.setElementFormat(((ClassElement)ClassElementNode.this.element).isClass() ? ElementNode.sourceOptions.getClassElementFormat() : ElementNode.sourceOptions.getInterfaceElementFormat());
            }
            super.propertyChange(evt);
        }
    }
}

