/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.openide.filesystems.FileObject;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.util.Utilities;

public final class Type
implements Cloneable,
Serializable {
    private static final int T_BOOLEAN = 1;
    private static final int T_INT = 2;
    private static final int T_CHAR = 3;
    private static final int T_BYTE = 4;
    private static final int T_SHORT = 5;
    private static final int T_LONG = 6;
    private static final int T_FLOAT = 7;
    private static final int T_DOUBLE = 8;
    private static final int T_VOID = 9;
    private static final int T_CLASS = 16;
    private static final int T_ARRAY = 32;
    private static final int T_PRIMITIVE = 15;
    public static final Type VOID = new Type(9);
    public static final Type BOOLEAN = new Type(1);
    public static final Type INT = new Type(2);
    public static final Type CHAR = new Type(3);
    public static final Type BYTE = new Type(4);
    public static final Type SHORT = new Type(5);
    public static final Type LONG = new Type(6);
    public static final Type FLOAT = new Type(7);
    public static final Type DOUBLE = new Type(8);
    private static HashMap text2type = new HashMap();
    private static final String L_VOID = "void";
    private static final String L_BOOLEAN = "boolean";
    private static final String L_INT = "int";
    private static final String L_CHAR = "char";
    private static final String L_BYTE = "byte";
    private static final String L_SHORT = "short";
    private static final String L_LONG = "long";
    private static final String L_FLOAT = "float";
    private static final String L_DOUBLE = "double";
    private static final String[] PRIMITIVE_NAMES = new String[]{"void", "boolean", "int", "char", "byte", "short", "long", "float", "double"};
    private int kind;
    private Type elementType = null;
    private Identifier classType = null;
    static final long serialVersionUID = 8997425134968958367L;

    private Type(int kind) {
        this.kind = kind;
    }

    private Type(Type type) {
        this.kind = 32;
        this.elementType = type;
    }

    private Type(Identifier id) {
        this.kind = 16;
        this.classType = id;
    }

    private Object readResolve() {
        switch (this.kind) {
            case 1: {
                return BOOLEAN;
            }
            case 2: {
                return INT;
            }
            case 3: {
                return CHAR;
            }
            case 4: {
                return BYTE;
            }
            case 5: {
                return SHORT;
            }
            case 6: {
                return LONG;
            }
            case 7: {
                return FLOAT;
            }
            case 8: {
                return DOUBLE;
            }
            case 9: {
                return VOID;
            }
            case 16: {
                return Type.createClass(this.classType);
            }
            case 32: {
                return Type.createArray(this.elementType);
            }
        }
        throw new InternalError();
    }

    public static String[] getTypesNames() {
        return PRIMITIVE_NAMES;
    }

    public static Type createArray(Type elementType) {
        return new Type(elementType);
    }

    public static Type createClass(Identifier id) {
        return new Type(id);
    }

    public static Type createFromClass(Class cl) {
        if (cl.isArray()) {
            return Type.createArray(Type.createFromClass(cl.getComponentType()));
        }
        if (cl.isPrimitive()) {
            if (Void.TYPE.equals(cl)) {
                return VOID;
            }
            if (Boolean.TYPE.equals(cl)) {
                return BOOLEAN;
            }
            if (Integer.TYPE.equals(cl)) {
                return INT;
            }
            if (Character.TYPE.equals(cl)) {
                return CHAR;
            }
            if (Byte.TYPE.equals(cl)) {
                return BYTE;
            }
            if (Short.TYPE.equals(cl)) {
                return SHORT;
            }
            if (Long.TYPE.equals(cl)) {
                return LONG;
            }
            if (Float.TYPE.equals(cl)) {
                return FLOAT;
            }
            if (Double.TYPE.equals(cl)) {
                return DOUBLE;
            }
            throw new InternalError();
        }
        return Type.createClass(Identifier.create(Type.getClassIdentifier(cl)));
    }

    private static String getClassIdentifier(Class cl) {
        if (cl.getDeclaringClass() == null) {
            return cl.getName();
        }
        StringBuffer sb = new StringBuffer(cl.getName());
        cl = cl.getDeclaringClass();
        do {
            sb.setCharAt(cl.getName().length(), '.');
        } while ((cl = cl.getDeclaringClass()) != null);
        return sb.toString();
    }

    public static Type parse(String text) throws IllegalArgumentException {
        if (text.endsWith(".TYPE")) {
            String v;
            int len = text.length();
            String string = v = text.startsWith("java.lang.") ? text.substring(10, len - 5) : text.substring(0, len - 5);
            if ("Void".equals(v)) {
                return VOID;
            }
            if ("Boolean".equals(v)) {
                return BOOLEAN;
            }
            if ("Integer".equals(v)) {
                return INT;
            }
            if ("Character".equals(v)) {
                return CHAR;
            }
            if ("Byte".equals(v)) {
                return BYTE;
            }
            if ("Short".equals(v)) {
                return SHORT;
            }
            if ("Long".equals(v)) {
                return LONG;
            }
            if ("Float".equals(v)) {
                return FLOAT;
            }
            if ("Double".equals(v)) {
                return DOUBLE;
            }
        }
        StringTokenizer tok = new StringTokenizer(text, " []", true);
        Type type = null;
        int status = 0;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.equals(" ")) continue;
            switch (status) {
                case 0: {
                    type = (Type)text2type.get(token);
                    if (type == null) {
                        int offset;
                        String localText = token;
                        if (localText.length() == 0) {
                            throw new IllegalArgumentException();
                        }
                        do {
                            String localToken;
                            if ((offset = localText.indexOf(".")) == -1) {
                                localToken = localText;
                            } else {
                                localToken = localText.substring(0, offset);
                                localText = localText.substring(offset + 1, localText.length());
                            }
                            if (localToken.length() != 0 && Utilities.isJavaIdentifier((String)localToken)) continue;
                            throw new IllegalArgumentException();
                        } while (offset != -1);
                        type = Type.createClass(Identifier.create(token));
                    }
                    status = 1;
                    break;
                }
                case 1: {
                    if (!token.equals("[")) {
                        throw new IllegalArgumentException();
                    }
                    status = 2;
                    break;
                }
                case 2: {
                    if (!token.equals("]")) {
                        throw new IllegalArgumentException();
                    }
                    type = Type.createArray(type);
                    status = 1;
                }
            }
        }
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return type;
    }

    public boolean isPrimitive() {
        return (this.kind & 0xF) != 0;
    }

    public boolean isArray() {
        return this.kind == 32;
    }

    public boolean isClass() {
        return this.kind == 16;
    }

    public Type getElementType() throws IllegalStateException {
        if (this.isArray()) {
            return this.elementType;
        }
        throw new IllegalStateException();
    }

    public Identifier getClassName() throws IllegalStateException {
        if (this.isClass()) {
            return this.classType;
        }
        throw new IllegalStateException();
    }

    public Class toClass() throws ClassNotFoundException {
        return this.toClass(null);
    }

    public Class toClass(ClassLoader loader) throws ClassNotFoundException {
        if (this.isPrimitive()) {
            switch (this.kind) {
                case 1: {
                    return Boolean.TYPE;
                }
                case 2: {
                    return Integer.TYPE;
                }
                case 3: {
                    return Character.TYPE;
                }
                case 4: {
                    return Byte.TYPE;
                }
                case 5: {
                    return Short.TYPE;
                }
                case 6: {
                    return Long.TYPE;
                }
                case 7: {
                    return Float.TYPE;
                }
                case 8: {
                    return Double.TYPE;
                }
            }
            return Void.TYPE;
        }
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        if (this.isClass()) {
            return Class.forName(this.classType.getFullName(), true, loader);
        }
        String name = "";
        Type t = this;
        while (t.isArray()) {
            name = name + "[";
            t = t.getElementType();
        }
        name = t.isClass() ? name + "L" + t.classType.getFullName() + ";" : name + Type.getPrimitiveCode(t.kind);
        return Class.forName(name, true, loader);
    }

    StringBuffer getAsString(StringBuffer appendTo, boolean source) {
        if (this.isPrimitive()) {
            switch (this.kind) {
                case 1: {
                    return appendTo.append(L_BOOLEAN);
                }
                case 2: {
                    return appendTo.append(L_INT);
                }
                case 3: {
                    return appendTo.append(L_CHAR);
                }
                case 4: {
                    return appendTo.append(L_BYTE);
                }
                case 5: {
                    return appendTo.append(L_SHORT);
                }
                case 6: {
                    return appendTo.append(L_LONG);
                }
                case 7: {
                    return appendTo.append(L_FLOAT);
                }
                case 8: {
                    return appendTo.append(L_DOUBLE);
                }
            }
            return appendTo.append(L_VOID);
        }
        if (this.isClass()) {
            return appendTo.append(source ? this.classType.getSourceName() : this.classType.getFullName());
        }
        return this.elementType.getAsString(appendTo, source).append("[]");
    }

    private static String getPrimitiveCode(int t) {
        switch (t) {
            case 1: {
                return "Z";
            }
            case 2: {
                return "I";
            }
            case 3: {
                return "C";
            }
            case 4: {
                return "B";
            }
            case 5: {
                return "S";
            }
            case 6: {
                return "J";
            }
            case 7: {
                return "F";
            }
            case 8: {
                return "D";
            }
        }
        return "V";
    }

    public String getSourceString() {
        return this.getAsString(new StringBuffer(), true).toString();
    }

    public String getFullString() {
        return this.getAsString(new StringBuffer(), false).toString();
    }

    public String toString() {
        return this.getSourceString();
    }

    public final String getVMClassName() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation is not more supported. Use Type.getVMClassName(FileObject)");
    }

    public final String getVMClassName(FileObject projectArtefact) throws UnsupportedOperationException {
        if (this.isPrimitive()) {
            throw new UnsupportedOperationException("Primitive types unsupported");
        }
        return this.internalGetVMName(false, projectArtefact);
    }

    public final Identifier getTypeIdentifier() throws UnsupportedOperationException {
        if (this.isPrimitive() || this.isArray()) {
            throw new UnsupportedOperationException("Only class types supported");
        }
        return this.classType;
    }

    private String internalGetVMName(boolean useSignature, FileObject projectArtefact) {
        if (!this.isArray()) {
            String fqn = this.classType.getFullName();
            ClassElement cls = ClassElement.forName(fqn, projectArtefact);
            if (cls == null) {
                if (useSignature) {
                    return fqn.replace('.', '/');
                }
                return fqn;
            }
            return useSignature ? cls.getSignature() : cls.getVMName();
        }
        int depth = 0;
        Type t = this;
        do {
            ++depth;
        } while ((t = t.getElementType()).isArray());
        StringBuffer sb = new StringBuffer(depth + 1);
        for (int i = 0; i < depth; ++i) {
            sb.append('[');
        }
        if (t.isPrimitive()) {
            sb.append(Type.getPrimitiveCode(t.kind));
        } else {
            sb.append('L');
            sb.append(t.internalGetVMName(useSignature, projectArtefact));
            sb.append(';');
        }
        return sb.toString();
    }

    public final String getSignature() {
        throw new UnsupportedOperationException("Operation is not more supported. Use Type.getSignature(FileObject)");
    }

    public final String getSignature(FileObject projectArtefact) {
        if (this.isPrimitive()) {
            return Type.getPrimitiveCode(this.kind);
        }
        if (this.isClass()) {
            String fqn = this.classType.getFullName();
            ClassElement el = ClassElement.forName(fqn, projectArtefact);
            if (el != null) {
                fqn = el.getSignature();
            }
            StringBuffer sb = new StringBuffer(fqn.length() + 2);
            sb.append('L');
            sb.append(fqn);
            sb.append(';');
            return sb.toString();
        }
        return this.internalGetVMName(true, projectArtefact);
    }

    public boolean compareTo(Type type, boolean source) {
        if (type.kind != this.kind) {
            return false;
        }
        switch (this.kind) {
            case 32: {
                return type.getElementType().compareTo(this.getElementType(), source);
            }
            case 16: {
                return type.getClassName().compareTo(this.getClassName(), source);
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        return o instanceof Type ? this.compareTo((Type)o, false) : false;
    }

    public int hashCode() {
        switch (this.kind) {
            case 32: {
                return this.getElementType().hashCode() << 1;
            }
            case 16: {
                return this.getClassName().hashCode();
            }
        }
        return System.identityHashCode(this);
    }

    static {
        text2type.put(L_VOID, VOID);
        text2type.put(L_BOOLEAN, BOOLEAN);
        text2type.put(L_INT, INT);
        text2type.put(L_CHAR, CHAR);
        text2type.put(L_BYTE, BYTE);
        text2type.put(L_SHORT, SHORT);
        text2type.put(L_LONG, LONG);
        text2type.put(L_FLOAT, FLOAT);
        text2type.put(L_DOUBLE, DOUBLE);
    }
}

