/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.io.IOException;
import org.netbeans.modules.tasklist.core.filter.FilterCondition;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class OneOfFilterCondition
extends FilterCondition {
    private String[] options = null;
    private int id;

    public OneOfFilterCondition(String[] opts, int id) {
        this.options = opts;
        this.id = id;
    }

    public OneOfFilterCondition(OneOfFilterCondition rhs) {
        super(rhs);
        this.options = rhs.options;
        this.id = rhs.id;
    }

    protected OneOfFilterCondition(String[] opts) {
        this.options = opts;
        this.id = -1;
    }

    public boolean sameType(FilterCondition fc) {
        return super.sameType(fc) && this.id == ((OneOfFilterCondition)fc).id;
    }

    protected String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)this.options[this.id]);
    }

    protected int getId() {
        return this.id;
    }

    protected static abstract class Convertor
    extends FilterCondition.Convertor {
        private static final String ATTR_ID = "id";
        private String[] nameKeys;

        public Convertor(String root, String[] nameKeys) {
            super(root);
            this.nameKeys = nameKeys;
        }

        protected OneOfFilterCondition createCondition() {
            throw new UnsupportedOperationException();
        }

        protected void readCondition(Element element, OneOfFilterCondition cond) throws IOException, ClassNotFoundException {
            super.readCondition(element, cond);
            cond.id = Convertor.findIndex(element.getAttribute(ATTR_ID), this.nameKeys);
        }

        protected Object readElement(Element element) throws IOException, ClassNotFoundException {
            OneOfFilterCondition cond = this.createCondition();
            this.readCondition(element, cond);
            return cond;
        }

        protected void writeCondition(Document document, Element element, OneOfFilterCondition cond) throws IOException, DOMException {
            super.writeCondition(document, element, cond);
            element.setAttribute(ATTR_ID, this.nameKeys[cond.id]);
        }

        protected void writeElement(Document document, Element element, Object obj) throws IOException, DOMException {
            this.writeCondition(document, element, (OneOfFilterCondition)obj);
        }

        protected static int findIndex(String str, String[] arr) throws IOException {
            for (int i = 0; i < arr.length; ++i) {
                if (!arr[i].equals(str)) continue;
                return i;
            }
            throw new IOException("The value " + str + " not found in the array " + arr);
        }
    }
}

