/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.columns;

import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.tasklist.core.ColumnProperty;
import org.netbeans.modules.tasklist.core.TaskListView;

public class ColumnsConfiguration {
    private ArrayList listeners = new ArrayList();
    private int[] widths;
    private String[] properties;
    private String sortingColumn;
    private boolean ascending;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ColumnsConfiguration(String[] properties, int[] widths, String sort, boolean ascending) {
        this.properties = properties;
        this.widths = widths;
        this.sortingColumn = sort;
        this.ascending = ascending;
    }

    public void setValues(String[] properties, int[] widths, String sort, boolean ascending) {
        this.properties = properties;
        this.widths = widths;
        this.sortingColumn = sort;
        this.ascending = ascending;
        this.fireChange();
    }

    public int[] getWidths() {
        return this.widths;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public String getSortingColumn() {
        return this.sortingColumn;
    }

    public boolean getSortingOrder() {
        return this.ascending;
    }

    public void setSortingOrder(boolean ascending) {
        this.ascending = ascending;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    protected final void fireChange() {
        ChangeEvent e = null;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ChangeListener l = (ChangeListener)this.listeners.get(i);
            if (e == null) {
                e = new ChangeEvent(this);
            }
            l.stateChanged(e);
        }
    }

    public static void loadColumnsFrom(TaskListView v, ColumnsConfiguration cc) {
        ColumnProperty[] columns = v.getColumns();
        ColumnProperty treeColumn = null;
        for (int i = 0; i < columns.length; ++i) {
            Object b = columns[i].getValue("TreeColumnTTV");
            if (!(b instanceof Boolean) || !((Boolean)b).booleanValue()) continue;
            treeColumn = columns[i];
            break;
        }
        if (!$assertionsDisabled && treeColumn == null) {
            throw new AssertionError();
        }
        ColumnProperty sortedColumn = null;
        boolean ascending = false;
        for (int i = 0; i < columns.length; ++i) {
            Boolean sorting = (Boolean)columns[i].getValue("SortingColumnTTV");
            if (sorting == null || !sorting.booleanValue()) continue;
            sortedColumn = columns[i];
            Boolean desc = (Boolean)columns[i].getValue("DescendingOrderTTV");
            ascending = desc != Boolean.TRUE;
        }
        TableColumnModel m = v.getTable().getColumnModel();
        int[] widths = new int[m.getColumnCount()];
        String[] properties = new String[m.getColumnCount()];
        for (int i = 0; i < m.getColumnCount(); ++i) {
            TableColumn tc = m.getColumn(i);
            ColumnProperty cp = null;
            for (int j = 0; j < columns.length; ++j) {
                if (!columns[j].getDisplayName().equals(tc.getHeaderValue())) continue;
                cp = columns[j];
            }
            properties[i] = cp != null ? cp.getName() : treeColumn.getName();
            widths[i] = tc.getWidth();
        }
        cc.setValues(properties, widths, sortedColumn == null ? null : sortedColumn.getName(), ascending);
    }

    public static void configureColumns(TaskListView v, ColumnsConfiguration cc) {
        ColumnProperty c;
        int i;
        String[] properties = cc.getProperties();
        int[] widths = cc.getWidths();
        String sortingColumn = cc.getSortingColumn();
        boolean ascending = cc.getSortingOrder();
        ColumnProperty[] columns = v.getColumns();
        for (i = 0; i < columns.length; ++i) {
            columns[i].setValue("InvisibleInTreeTableView", Boolean.TRUE);
        }
        for (i = 0; i < properties.length; ++i) {
            ColumnProperty c2 = ColumnsConfiguration.findColumn(columns, properties[i]);
            if (c2 == null) continue;
            c2.setValue("InvisibleInTreeTableView", Boolean.FALSE);
            c2.width = widths[i];
        }
        if (sortingColumn != null && (c = ColumnsConfiguration.findColumn(columns, sortingColumn)) != null) {
            c.setValue("SortingColumnTTV", Boolean.TRUE);
            c.setValue("DescendingOrderTTV", !ascending ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private static ColumnProperty findColumn(ColumnProperty[] columns, String name) {
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].getName().equals(name)) continue;
            return columns[i];
        }
        return null;
    }

    static {
        $assertionsDisabled = !ColumnsConfiguration.class.desiredAssertionStatus();
    }
}

