/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.ui.customizer;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.ejbjarproject.UpdateHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PlatformUiSupport {
    private static final String DEFAULT_JAVAC_TARGET = "${default.javac.target}";
    private static final String DEFAULT_JAVAC_SOURCE = "${default.javac.source}";

    private PlatformUiSupport() {
    }

    public static ComboBoxModel createPlatformComboBoxModel(String activePlatform) {
        return new PlatformComboBoxModel(activePlatform);
    }

    public static ListCellRenderer createPlatformListCellRenderer() {
        return new PlatformListCellRenderer();
    }

    public static void storePlatform(EditableProperties props, UpdateHelper helper, String platformName, SpecificationVersion sourceLevel) {
        PlatformKey platformKey = platformName != null ? new PlatformKey(PlatformUiSupport.findPlatform(platformName)) : new PlatformKey(JavaPlatformManager.getDefault().getDefaultPlatform());
        PlatformUiSupport.storePlatform(props, helper, platformKey, sourceLevel);
    }

    public static void storePlatform(EditableProperties props, UpdateHelper helper, Object platformKey, SpecificationVersion sourceLevel) {
        assert (platformKey instanceof PlatformKey);
        PlatformKey pk = (PlatformKey)platformKey;
        JavaPlatform platform = PlatformUiSupport.getPlatform(pk);
        if (platform != null) {
            String platformAntName = (String)platform.getProperties().get("platform.ant.name");
            assert (platformAntName != null);
            props.put((Object)"platform.active", (Object)platformAntName);
            Element root = helper.getPrimaryConfigurationData(true);
            boolean defaultPlatform = pk.isDefaultPlatform();
            boolean changed = false;
            NodeList explicitPlatformNodes = root.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "explicit-platform");
            if (defaultPlatform) {
                String newSourceValue;
                String newTargetValue;
                if (explicitPlatformNodes.getLength() == 1) {
                    root.removeChild(explicitPlatformNodes.item(0));
                    changed = true;
                }
                SpecificationVersion platformVersion = platform.getSpecification().getVersion();
                if (sourceLevel == null || sourceLevel.equals((Object)platformVersion)) {
                    newTargetValue = DEFAULT_JAVAC_TARGET;
                    newSourceValue = DEFAULT_JAVAC_SOURCE;
                } else {
                    newTargetValue = newSourceValue = sourceLevel.toString();
                }
                String oldTargetValue = props.getProperty("javac.target");
                String oldSourceValue = props.getProperty("javac.source");
                if (!newTargetValue.equals(oldTargetValue)) {
                    props.setProperty("javac.target", newTargetValue);
                }
                if (!newSourceValue.equals(oldSourceValue)) {
                    props.setProperty("javac.source", newSourceValue);
                }
            } else {
                String javacSource;
                Element explicitPlatform;
                switch (explicitPlatformNodes.getLength()) {
                    case 0: {
                        explicitPlatform = root.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "explicit-platform");
                        NodeList sourceRootNodes = root.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "minimum-ant-version");
                        assert (sourceRootNodes.getLength() == 1) : "Broken project.xml file";
                        root.insertBefore(explicitPlatform, sourceRootNodes.item(0).getNextSibling());
                        changed = true;
                        break;
                    }
                    case 1: {
                        explicitPlatform = (Element)explicitPlatformNodes.item(0);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Broken project.xml file");
                    }
                }
                SpecificationVersion jdk13 = new SpecificationVersion("1.3");
                String explicitSourceAttrValue = explicitPlatform.getAttribute("explicit-source-supported");
                if (jdk13.compareTo((Object)platform.getSpecification().getVersion()) >= 0 && !"false".equals(explicitSourceAttrValue)) {
                    explicitPlatform.setAttribute("explicit-source-supported", "false");
                    changed = true;
                } else if (jdk13.compareTo((Object)platform.getSpecification().getVersion()) < 0 && !"true".equals(explicitSourceAttrValue)) {
                    explicitPlatform.setAttribute("explicit-source-supported", "true");
                    changed = true;
                }
                if (sourceLevel == null) {
                    sourceLevel = platform.getSpecification().getVersion();
                }
                if (!(javacSource = sourceLevel.toString()).equals(props.getProperty("javac.source"))) {
                    props.setProperty("javac.source", javacSource);
                }
                if (!javacSource.equals(props.getProperty("javac.target"))) {
                    props.setProperty("javac.target", javacSource);
                }
            }
            if (changed) {
                helper.putPrimaryConfigurationData(root, true);
            }
        }
    }

    public static JavaPlatform findPlatform(String displayName) {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(displayName, new Specification("j2se", null));
        return platforms.length == 0 ? null : platforms[0];
    }

    public static JavaPlatform getPlatform(Object platformKey) {
        if (platformKey instanceof PlatformKey) {
            return PlatformUiSupport.getPlatform((PlatformKey)platformKey);
        }
        throw new IllegalArgumentException();
    }

    public static ComboBoxModel createSourceLevelComboBoxModel(ComboBoxModel platformComboBoxModel, String initialValue, String j2eePlatform) {
        return new SourceLevelComboBoxModel(platformComboBoxModel, initialValue, j2eePlatform);
    }

    private static JavaPlatform getPlatform(PlatformKey platformKey) {
        return platformKey.platform;
    }

    private static class SourceLevelComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    ListDataListener {
        private static final String VERSION_PREFIX = "1.";
        private static final int INITIAL_VERSION_MINOR = 2;
        private static final int INITIAL_VERSION_MINOR_JAVA_EE_5 = 5;
        private SpecificationVersion selectedSourceLevel;
        private SpecificationVersion[] sourceLevelCache;
        private final ComboBoxModel platformComboBoxModel;
        private PlatformKey activePlatform;
        private String j2eePlatform = null;

        public SourceLevelComboBoxModel(ComboBoxModel platformComboBoxModel, String initialValue) {
            this.platformComboBoxModel = platformComboBoxModel;
            this.activePlatform = (PlatformKey)this.platformComboBoxModel.getSelectedItem();
            this.platformComboBoxModel.addListDataListener(this);
            if (initialValue != null && initialValue.length() > 0) {
                try {
                    this.selectedSourceLevel = new SpecificationVersion(initialValue);
                }
                catch (NumberFormatException nfe) {
                    ErrorManager.getDefault().log("Invalid javac.source: " + initialValue);
                }
            }
        }

        public SourceLevelComboBoxModel(ComboBoxModel platformComboBoxModel, String initialValue, String j2eePlatform) {
            this(platformComboBoxModel, initialValue);
            this.j2eePlatform = j2eePlatform;
        }

        public int getSize() {
            SpecificationVersion[] sLevels = this.getSourceLevels();
            return sLevels.length;
        }

        public Object getElementAt(int index) {
            SpecificationVersion[] sLevels = this.getSourceLevels();
            assert (index >= 0 && index < sLevels.length);
            return sLevels[index];
        }

        public Object getSelectedItem() {
            List<SpecificationVersion> sLevels = Arrays.asList(this.getSourceLevels());
            if (this.selectedSourceLevel != null && !sLevels.contains(this.selectedSourceLevel)) {
                this.selectedSourceLevel = sLevels.size() > 0 ? sLevels.get(sLevels.size() - 1) : null;
            }
            return this.selectedSourceLevel;
        }

        public void setSelectedItem(Object obj) {
            this.selectedSourceLevel = (SpecificationVersion)obj;
            this.fireContentsChanged(this, -1, -1);
        }

        public void intervalAdded(ListDataEvent e) {
        }

        public void intervalRemoved(ListDataEvent e) {
        }

        public void contentsChanged(ListDataEvent e) {
            PlatformKey selectedPlatform = (PlatformKey)this.platformComboBoxModel.getSelectedItem();
            JavaPlatform platform = PlatformUiSupport.getPlatform(selectedPlatform);
            if (platform != null) {
                SpecificationVersion version = platform.getSpecification().getVersion();
                if (this.selectedSourceLevel != null && this.selectedSourceLevel.compareTo((Object)version) > 0 && !SourceLevelComboBoxModel.shouldChangePlatform(this.selectedSourceLevel, version)) {
                    this.platformComboBoxModel.setSelectedItem(this.activePlatform);
                    return;
                }
            }
            this.activePlatform = selectedPlatform;
            this.resetCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetCache() {
            SourceLevelComboBoxModel sourceLevelComboBoxModel = this;
            synchronized (sourceLevelComboBoxModel) {
                this.sourceLevelCache = null;
            }
            this.fireContentsChanged(this, -1, -1);
        }

        private SpecificationVersion[] getSourceLevels() {
            if (this.sourceLevelCache == null) {
                PlatformKey selectedPlatform = (PlatformKey)this.platformComboBoxModel.getSelectedItem();
                JavaPlatform platform = PlatformUiSupport.getPlatform(selectedPlatform);
                ArrayList<SpecificationVersion> sLevels = new ArrayList<SpecificationVersion>();
                if (platform != null) {
                    SpecificationVersion version = platform.getSpecification().getVersion();
                    int index = 2;
                    if (this.j2eePlatform != null && this.j2eePlatform.equals("1.5")) {
                        index = 5;
                    }
                    SpecificationVersion template = new SpecificationVersion(VERSION_PREFIX + Integer.toString(index++));
                    while (template.compareTo((Object)version) <= 0) {
                        sLevels.add(template);
                        template = new SpecificationVersion(VERSION_PREFIX + Integer.toString(index++));
                    }
                }
                this.sourceLevelCache = sLevels.toArray(new SpecificationVersion[sLevels.size()]);
            }
            return this.sourceLevelCache;
        }

        private static boolean shouldChangePlatform(SpecificationVersion selectedSourceLevel, SpecificationVersion platformSourceLevel) {
            JButton changeOption = new JButton(NbBundle.getMessage(PlatformUiSupport.class, (String)"CTL_ChangePlatform"));
            changeOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformUiSupport.class, (String)"AD_ChangePlatform"));
            String message = MessageFormat.format(NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_ChangePlatform"), selectedSourceLevel.toString(), platformSourceLevel.toString());
            return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)message, NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_ChangePlatformTitle"), -1, 2, new Object[]{changeOption, NotifyDescriptor.CANCEL_OPTION}, (Object)changeOption)) == changeOption;
        }
    }

    private static class PlatformListCellRenderer
    extends DefaultListCellRenderer {
        private PlatformListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            assert (value instanceof PlatformKey) : "Wrong model";
            PlatformKey key = (PlatformKey)value;
            String name = key.isBroken() ? NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_BrokenPlatformFmt", (Object)key.getDisplayName()) : key.getDisplayName();
            return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
        }
    }

    private static class PlatformComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private final JavaPlatformManager pm = JavaPlatformManager.getDefault();
        private PlatformKey[] platformNamesCache;
        private String initialPlatform;
        private PlatformKey selectedPlatform;

        public PlatformComboBoxModel(String initialPlatform) {
            this.pm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pm));
            this.initialPlatform = initialPlatform;
        }

        public int getSize() {
            PlatformKey[] platformNames = this.getPlatformNames();
            return platformNames.length;
        }

        public Object getElementAt(int index) {
            PlatformKey[] platformNames = this.getPlatformNames();
            assert (index >= 0 && index < platformNames.length);
            return platformNames[index];
        }

        public Object getSelectedItem() {
            this.getPlatformNames();
            return this.selectedPlatform;
        }

        public void setSelectedItem(Object obj) {
            this.selectedPlatform = (PlatformKey)obj;
            this.fireContentsChanged(this, -1, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent event) {
            if ("installedPlatforms".equals(event.getPropertyName())) {
                PlatformComboBoxModel platformComboBoxModel = this;
                synchronized (platformComboBoxModel) {
                    this.platformNamesCache = null;
                }
                this.fireContentsChanged(this, -1, -1);
            }
        }

        private synchronized PlatformKey[] getPlatformNames() {
            if (this.platformNamesCache == null) {
                JavaPlatform[] platforms = this.pm.getPlatforms(null, new Specification("j2se", null));
                TreeSet<PlatformKey> orderedNames = new TreeSet<PlatformKey>();
                boolean activeFound = false;
                for (int i = 0; i < platforms.length; ++i) {
                    String antName;
                    if (platforms[i].getInstallFolders().size() <= 0) continue;
                    PlatformKey pk = new PlatformKey(platforms[i]);
                    orderedNames.add(pk);
                    if (activeFound || this.initialPlatform == null || !this.initialPlatform.equals(antName = (String)platforms[i].getProperties().get("platform.ant.name"))) continue;
                    if (this.selectedPlatform == null) {
                        this.selectedPlatform = pk;
                        this.initialPlatform = null;
                    }
                    activeFound = true;
                }
                if (!activeFound) {
                    if (this.initialPlatform == null) {
                        if (this.selectedPlatform == null || !orderedNames.contains(this.selectedPlatform)) {
                            this.selectedPlatform = new PlatformKey(JavaPlatformManager.getDefault().getDefaultPlatform());
                        }
                    } else {
                        PlatformKey pk = new PlatformKey(this.initialPlatform);
                        orderedNames.add(pk);
                        if (this.selectedPlatform == null) {
                            this.selectedPlatform = pk;
                        }
                    }
                }
                this.platformNamesCache = orderedNames.toArray(new PlatformKey[orderedNames.size()]);
            }
            return this.platformNamesCache;
        }
    }

    private static class PlatformKey
    implements Comparable {
        private String name;
        private JavaPlatform platform;

        public PlatformKey(String name) {
            assert (name != null);
            this.name = name;
        }

        public PlatformKey(JavaPlatform platform) {
            assert (platform != null);
            this.platform = platform;
        }

        public int compareTo(Object o) {
            return this.getDisplayName().compareTo(((PlatformKey)o).getDisplayName());
        }

        public boolean equals(Object other) {
            if (other instanceof PlatformKey) {
                PlatformKey otherKey = (PlatformKey)other;
                return (this.platform == null ? otherKey.platform == null : this.platform.equals(otherKey.platform)) && otherKey.getDisplayName().equals(this.getDisplayName());
            }
            return false;
        }

        public int hashCode() {
            return this.getDisplayName().hashCode();
        }

        public String toString() {
            return this.getDisplayName();
        }

        public synchronized String getDisplayName() {
            if (this.name == null) {
                this.name = this.platform.getDisplayName();
            }
            return this.name;
        }

        public boolean isDefaultPlatform() {
            if (this.platform == null) {
                return false;
            }
            return this.platform.equals(JavaPlatformManager.getDefault().getDefaultPlatform());
        }

        public boolean isBroken() {
            return this.platform == null;
        }
    }
}

