/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.jaxws;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxws.spi.ProjectJAXWSSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class EjbProjectJAXWSSupport
extends ProjectJAXWSSupport {
    private EjbJarProject project;
    private AntProjectHelper antProjectHelper;

    public EjbProjectJAXWSSupport(EjbJarProject project, AntProjectHelper antProjectHelper) {
        super((Project)project, antProjectHelper);
        this.project = project;
        this.antProjectHelper = antProjectHelper;
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        FileObject metaInfFo;
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
        if (ejbModule != null && (metaInfFo = ejbModule.getMetaInf()) != null) {
            FileObject wsdlFo = metaInfFo.getFileObject("wsdl");
            if (wsdlFo != null) {
                return wsdlFo;
            }
            if (create) {
                return metaInfFo.createFolder("wsdl");
            }
        }
        return null;
    }

    public String getWsdlLocation(String serviceName) {
        String localWsdlFile;
        Service service;
        String localWsdl = serviceName + ".wsdl";
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (service = jaxWsModel.findServiceByName(serviceName)) != null && (localWsdlFile = service.getLocalWsdlFile()) != null) {
            localWsdl = localWsdlFile;
        }
        String prefix = "META-INF/wsdl/";
        return prefix + serviceName + "/" + localWsdl;
    }

    public FileObject getDeploymentDescriptorFolder() {
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
        if (ejbModule != null) {
            return ejbModule.getMetaInf();
        }
        return null;
    }

    protected void addJaxwsArtifacts(Project project, String wsName, String serviceImpl) throws Exception {
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getAPIEjbJar().getMetaInf();
    }

    public void removeNonJsr109Entries(String serviceName) throws IOException {
    }

    public String addService(String name, String serviceImpl, String wsdlUrl, String serviceName, String portName, String packageName, boolean isJsr109) {
        FileObject fo = this.project.findJaxWsFileObject();
        if (fo == null) {
            try {
                this.project.createJaxWsFileObject();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return super.addService(name, serviceImpl, wsdlUrl, serviceName, portName, packageName, isJsr109);
    }

    public void addService(String serviceName, String serviceImpl, boolean isJsr109) {
        FileObject fo = this.project.findJaxWsFileObject();
        if (fo == null) {
            try {
                this.project.createJaxWsFileObject();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        super.addService(serviceName, serviceImpl, isJsr109);
    }
}

