/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.util.List;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.visitor.CompareVisitor;
import org.netbeans.modules.xml.xdm.visitor.DefaultVisitor;
import org.netbeans.modules.xml.xdm.visitor.PathFromRootVisitor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class MergeVisitor
extends DefaultVisitor {
    private XDMModel xmlModel;
    private Document oldtree;
    private Node target;
    private PathFromRootVisitor pathVisitor = new PathFromRootVisitor();

    public void merge(XDMModel model, Document newDoc) {
        this.xmlModel = model;
        this.oldtree = this.xmlModel.getDocument();
        this.target = newDoc;
        this.oldtree.accept(this);
    }

    protected void visitNode(Node node) {
        CompareVisitor comparer = new CompareVisitor();
        boolean result = comparer.compare(node, this.target);
        if (!result) {
            int offset;
            Node newNode = this.target.clone(false, false, false);
            List<Node> path = this.pathVisitor.findPath(this.oldtree, node);
            assert (!path.isEmpty());
            Node oldNode = path.get(0);
            NodeList children = path.get(1).getChildNodes();
            for (offset = 0; offset < children.getLength() && !oldNode.equals(children.item(offset)); ++offset) {
            }
            this.xmlModel.delete(oldNode);
            this.xmlModel.add(path.get(1), newNode, offset);
        } else {
            this.compareByIndex(this.target, node);
            this.compareAttrsByIndex(this.target, node);
        }
    }

    private void compareByIndex(Node newNode, Node current) {
        Node n;
        int i;
        NodeList newnodes = newNode.getChildNodes();
        NodeList children = current.getChildNodes();
        int oldTreesize = children.getLength();
        int newTreesize = newnodes.getLength();
        int lastEqualIndex = Math.min(oldTreesize, newTreesize);
        for (i = 0; i < lastEqualIndex; ++i) {
            this.target = (Node)newnodes.item(i);
            n = (Node)children.item(i);
            n.accept(this);
        }
        this.target = newNode;
        for (i = oldTreesize - 1; i >= lastEqualIndex; --i) {
            this.xmlModel.delete((Node)children.item(i));
        }
        for (i = lastEqualIndex; i < newTreesize; ++i) {
            n = (Node)newnodes.item(i);
            this.xmlModel.add(current, n.clone(false, false, false), i);
        }
    }

    private void compareAttrsByIndex(Node newNode, Node current) {
        Node n;
        int i;
        NamedNodeMap newAttributes = newNode.getAttributes();
        NamedNodeMap attributes = current.getAttributes();
        int oldTreesize = attributes.getLength();
        int newTreesize = newAttributes.getLength();
        int lastEqualIndex = Math.min(oldTreesize, newTreesize);
        for (i = 0; i < lastEqualIndex; ++i) {
            this.target = (Node)newAttributes.item(i);
            n = (Node)attributes.item(i);
            n.accept(this);
        }
        this.target = newNode;
        for (i = oldTreesize - 1; i >= lastEqualIndex; --i) {
            this.xmlModel.delete((Node)attributes.item(i));
        }
        for (i = lastEqualIndex; i < newTreesize; ++i) {
            n = (Node)newAttributes.item(i);
            this.xmlModel.add(current, ((NodeImpl)n).cloneShallowWithModelContext(), i);
        }
    }
}

