/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform.ui;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.freeform.ui.NewWebFreeformProjectWizardIterator;
import org.netbeans.modules.web.freeform.ui.WebLocationsPanel;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WebLocationsWizardPanel
implements WizardDescriptor.Panel {
    private WebLocationsPanel component;
    private WizardDescriptor wizardDescriptor;
    private File baseFolder;
    private final Set listeners = new HashSet(1);

    public WebLocationsWizardPanel() {
        this.getComponent().setName(NbBundle.getMessage((Class)NewWebFreeformProjectWizardIterator.class, (String)"TXT_NewWebFreeformProjectWizardIterator_WebSources"));
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new WebLocationsPanel(this.wizardDescriptor);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(WebLocationsWizardPanel.class);
    }

    public boolean isValid() {
        this.getComponent();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        String srcPackages;
        String webPages;
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.wizardDescriptor.putProperty("NewProjectWizard_Title", this.component.getClientProperty("NewProjectWizard_Title"));
        File baseFolder = (File)this.wizardDescriptor.getProperty("projectLocation");
        File nbProjectFolder = (File)this.wizardDescriptor.getProperty("projectFolder");
        if (baseFolder.equals(this.baseFolder)) {
            webPages = this.component.getWebPagesLocation().getAbsolutePath();
            srcPackages = this.component.getSrcPackagesLocation().getAbsolutePath();
        } else {
            this.baseFolder = baseFolder;
            FileObject fo = FileUtil.toFileObject((File)baseFolder);
            if (fo != null) {
                webPages = this.guessDocBase(fo);
                srcPackages = this.guessJavaRoot(fo);
            } else {
                webPages = "";
                srcPackages = "";
            }
        }
        this.component.setFolders(baseFolder, nbProjectFolder);
        this.component.setWebPages(webPages);
        this.component.setSrcPackages(srcPackages);
    }

    public void storeSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.wizardDescriptor.putProperty("webModules", (Object)this.component.getWebModules());
        List l = this.component.getJavaSrcFolder();
        this.wizardDescriptor.putProperty("sourceFolders", (Object)l);
        this.wizardDescriptor.putProperty("webSourceFolders", (Object)this.component.getWebSrcFolder());
        this.wizardDescriptor.putProperty("NewProjectWizard_Title", null);
    }

    private String guessDocBase(FileObject dir) {
        Enumeration ch = dir.getChildren(true);
        while (ch.hasMoreElements()) {
            FileObject webXmlFleObject;
            FileObject f = (FileObject)ch.nextElement();
            if (!f.isFolder() || !f.getName().equals("WEB-INF") || (webXmlFleObject = f.getFileObject("web.xml")) == null || !webXmlFleObject.isData()) continue;
            return FileUtil.toFile((FileObject)f.getParent()).getAbsolutePath();
        }
        return "";
    }

    private String guessJavaRoot(FileObject dir) {
        Enumeration ch = dir.getChildren(true);
        try {
            while (ch.hasMoreElements()) {
                FileObject f = (FileObject)ch.nextElement();
                if (!f.getExt().equals("java")) continue;
                String pckg = this.guessPackageName(f);
                String pkgPath = f.getParent().getPath();
                if (pckg == null || !pkgPath.endsWith(pckg.replace('.', '/'))) continue;
                String rootName = pkgPath.substring(0, pkgPath.length() - pckg.length());
                return FileUtil.toFile((FileObject)f.getFileSystem().findResource(rootName)).getAbsolutePath();
            }
        }
        catch (FileStateInvalidException fsie) {
            ErrorManager.getDefault().notify(1, (Throwable)fsie);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessPackageName(FileObject f) {
        Reader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(f.getInputStream(), "utf-8"));
            boolean noPackage = false;
            while (true) {
                int idx;
                String line;
                if ((line = ((BufferedReader)r).readLine()) == null) {
                    if (noPackage) {
                        String string = "";
                        return string;
                    }
                    break;
                }
                if ((line = line.trim()).trim().startsWith("package") && (idx = line.indexOf(";")) >= 0) {
                    String string = line.substring("package".length(), idx).trim();
                    return string;
                }
                if (line.indexOf("class") == -1) continue;
                noPackage = true;
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

