/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class FileObjectSearchGroup
extends SearchGroup {
    static /* synthetic */ Class class$org$openide$filesystems$FileObject;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    protected void add(SearchType searchType) {
        boolean ok = false;
        Class[] classes = searchType.getSearchTypeClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i] != (class$org$openide$filesystems$FileObject == null ? FileObjectSearchGroup.class$("org.openide.filesystems.FileObject") : class$org$openide$filesystems$FileObject)) continue;
            ok = true;
            break;
        }
        if (ok) {
            super.add(searchType);
        }
    }

    public void doSearch() {
        FileObject[] rootFolders = this.getFileFolders();
        if (rootFolders == null) {
            return;
        }
        for (int i = 0; i < rootFolders.length; ++i) {
            if (this.scanFolder(rootFolders[i])) continue;
            return;
        }
    }

    private FileObject[] getFileFolders() {
        Node[] nodes = FileObjectSearchGroup.normalizeNodes(this.searchRoots.toArray(new Node[this.searchRoots.size()]));
        ArrayList<FileObject> children = new ArrayList<FileObject>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            DataFolder dataFolder = (DataFolder)nodes[i].getCookie(class$org$openide$loaders$DataFolder == null ? FileObjectSearchGroup.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
            if (dataFolder == null) continue;
            children.add(dataFolder.getPrimaryFile());
        }
        return children.toArray(new FileObject[children.size()]);
    }

    private boolean scanFolder(FileObject folder) {
        FileObject[] children = folder.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (this.stopped) {
                this.stopped = true;
                return false;
            }
            if (children[i].isFolder()) {
                if (this.scanFolder(children[i])) continue;
                return false;
            }
            this.processSearchObject(children[i]);
        }
        return true;
    }

    public Node getNodeForFoundObject(final Object object) {
        if (!(object instanceof FileObject)) {
            return null;
        }
        try {
            return DataObject.find((FileObject)((FileObject)object)).getNodeDelegate();
        }
        catch (DataObjectNotFoundException dnfe) {
            return new AbstractNode(Children.LEAF){

                public String getName() {
                    return ((FileObject)object).getName();
                }
            };
        }
    }

    private static Node[] normalizeNodes(Node[] nodes) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (int i = 0; i < nodes.length; ++i) {
            if (FileObjectSearchGroup.hasParent(nodes[i], nodes)) continue;
            ret.add(nodes[i]);
        }
        return ret.toArray(new Node[ret.size()]);
    }

    private static boolean hasParent(Node node, Node[] nodes) {
        for (Node parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            for (int i = 0; i < nodes.length; ++i) {
                if (!nodes[i].equals((Object)parent)) continue;
                return true;
            }
        }
        return false;
    }
}

