/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class DiffTreeTable
extends TreeTableView {
    private RevisionsRootNode rootNode;
    private List results;

    public DiffTreeTable() {
        this.treeTable.setShowHorizontalLines(true);
        this.treeTable.setShowVerticalLines(false);
        this.setRootVisible(false);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
        this.setupColumns();
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        this.tree.setCellRenderer(renderer);
    }

    private void setupColumns() {
        Node.Property[] columns = new Node.Property[4];
        ResourceBundle loc = NbBundle.getBundle((Class)DiffTreeTable.class);
        columns[0] = new ColumnDescriptor("name", String.class, "", "");
        columns[0].setValue("TreeColumnTTV", (Object)Boolean.TRUE);
        columns[1] = new ColumnDescriptor("date", String.class, loc.getString("LBL_DiffTree_Column_Time"), loc.getString("LBL_DiffTree_Column_Time_Desc"));
        columns[2] = new ColumnDescriptor("username", String.class, loc.getString("LBL_DiffTree_Column_Username"), loc.getString("LBL_DiffTree_Column_Username_Desc"));
        columns[3] = new ColumnDescriptor("message", String.class, loc.getString("LBL_DiffTree_Column_Message"), loc.getString("LBL_DiffTree_Column_Message_Desc"));
        this.setProperties(columns);
    }

    private void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int width = DiffTreeTable.this.getWidth();
                DiffTreeTable.this.treeTable.getColumnModel().getColumn(0).setPreferredWidth(width * 25 / 100);
                DiffTreeTable.this.treeTable.getColumnModel().getColumn(1).setPreferredWidth(width * 15 / 100);
                DiffTreeTable.this.treeTable.getColumnModel().getColumn(2).setPreferredWidth(width * 10 / 100);
                DiffTreeTable.this.treeTable.getColumnModel().getColumn(3).setPreferredWidth(width * 50 / 100);
            }
        });
    }

    void setSelection(int idx) {
        this.treeTable.getSelectionModel().setValueIsAdjusting(false);
        this.treeTable.scrollRectToVisible(this.treeTable.getCellRect(idx, 1, true));
        this.treeTable.getSelectionModel().setSelectionInterval(idx, idx);
    }

    void setSelection(SearchHistoryPanel.ResultsContainer container) {
        RevisionNode node = (RevisionNode)this.getNode((Node)this.rootNode, container);
        if (node == null) {
            return;
        }
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        try {
            em.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    void setSelection(SearchHistoryPanel.DispRevision revision) {
        RevisionNode node = (RevisionNode)this.getNode((Node)this.rootNode, revision);
        if (node == null) {
            return;
        }
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        try {
            em.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private Node getNode(Node node, Object obj) {
        Object object = node.getLookup().lookup(obj.getClass());
        if (obj.equals(object)) {
            return node;
        }
        Enumeration children = node.getChildren().nodes();
        while (children.hasMoreElements()) {
            Node child = (Node)children.nextElement();
            Node result = this.getNode(child, obj);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int[] getSelection() {
        return this.treeTable.getSelectedRows();
    }

    public int getRowCount() {
        return this.treeTable.getRowCount();
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        em.setRootContext((Node)this.rootNode);
        this.setDefaultColumnSizes();
    }

    public void setResults(List results) {
        this.results = results;
        this.rootNode = new RevisionsRootNode();
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        if (em != null) {
            em.setRootContext((Node)this.rootNode);
        }
    }

    private class RevisionsRootNodeChildren
    extends Children.Keys {
        protected void addNotify() {
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        private void refreshKeys() {
            this.setKeys(DiffTreeTable.this.results);
        }

        protected Node[] createNodes(Object key) {
            RevisionNode node = key instanceof SearchHistoryPanel.ResultsContainer ? new RevisionNode((SearchHistoryPanel.ResultsContainer)key) : new RevisionNode((SearchHistoryPanel.DispRevision)key);
            return new Node[]{node};
        }
    }

    private class RevisionsRootNode
    extends AbstractNode {
        public RevisionsRootNode() {
            super((Children)new RevisionsRootNodeChildren(), Lookups.singleton((Object)DiffTreeTable.this.results));
        }

        public String getName() {
            return "revision";
        }

        public String getDisplayName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffTreeTable == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffTreeTable = DiffTreeTable.class$("org.netbeans.modules.versioning.system.cvss.ui.history.DiffTreeTable")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffTreeTable), (String)"LBL_DiffTree_Column_Name");
        }

        public String getShortDescription() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffTreeTable == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffTreeTable = DiffTreeTable.class$("org.netbeans.modules.versioning.system.cvss.ui.history.DiffTreeTable")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$DiffTreeTable), (String)"LBL_DiffTree_Column_Name_Desc");
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

