/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.web.jsf.wizards.JSFConfigurationPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JSFConfigurationPanelVisual
extends JPanel
implements HelpCtx.Provider,
DocumentListener {
    private JSFConfigurationPanel panel;
    private JCheckBox cbPackageJars;
    private JCheckBox cbValidate;
    private JCheckBox cbVerify;
    private JPanel jPanel1;
    private JLabel lServletName;
    private JLabel lURLPattern;
    private JTextField tServletName;
    private JTextField tURLPattern;

    public JSFConfigurationPanelVisual(JSFConfigurationPanel panel, boolean customizer) {
        this.initComponents();
        this.panel = panel;
        this.tURLPattern.getDocument().addDocumentListener(this);
        this.cbPackageJars.setVisible(false);
        if (customizer) {
            this.enableComponents(false);
        }
    }

    private void initComponents() {
        this.lServletName = new JLabel();
        this.tServletName = new JTextField();
        this.lURLPattern = new JLabel();
        this.tURLPattern = new JTextField();
        this.cbValidate = new JCheckBox();
        this.cbVerify = new JCheckBox();
        this.cbPackageJars = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lServletName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_lServletName").charAt(0));
        this.lServletName.setLabelFor(this.tServletName);
        this.lServletName.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_Servlet_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lServletName, gridBagConstraints);
        this.tServletName.setEditable(false);
        this.tServletName.setText("Faces Servlet");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this.tServletName, gridBagConstraints);
        this.tServletName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_ServletName"));
        this.lURLPattern.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_lURLPattern").charAt(0));
        this.lURLPattern.setLabelFor(this.tURLPattern);
        this.lURLPattern.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_URL_Pattern"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lURLPattern, gridBagConstraints);
        this.tURLPattern.setText("/faces/*");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this.tURLPattern, gridBagConstraints);
        this.tURLPattern.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_Mapping"));
        this.cbValidate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_cbValidate").charAt(0));
        this.cbValidate.setSelected(true);
        this.cbValidate.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"CB_Validate_XML"));
        this.cbValidate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbValidate.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 5, 0);
        this.add((Component)this.cbValidate, gridBagConstraints);
        this.cbValidate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_ValidateXML"));
        this.cbVerify.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_cbVerify").charAt(0));
        this.cbVerify.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"CB_Verify_Objects"));
        this.cbVerify.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbVerify.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 5, 5, 0);
        this.add((Component)this.cbVerify, gridBagConstraints);
        this.cbVerify.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_VerifyObjects"));
        this.cbPackageJars.setSelected(true);
        this.cbPackageJars.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"CB_Package_JARs"));
        this.cbPackageJars.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbPackageJars.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.cbPackageJars, gridBagConstraints);
        this.cbPackageJars.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_PackageJarToWar"));
        this.jPanel1.setEnabled(false);
        this.jPanel1.setFocusable(false);
        this.jPanel1.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        String urlPattern = this.tURLPattern.getText();
        if (urlPattern == null || urlPattern.trim().equals("")) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_URLPatternIsEmpty"));
            return false;
        }
        if (!this.isPatternValid(urlPattern)) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_URLPatternIsNotValid"));
            return false;
        }
        if (wizardDescriptor != null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        }
        return true;
    }

    private boolean isPatternValid(String pattern) {
        String p;
        if (pattern.startsWith("*.") && (p = pattern.substring(2)).indexOf(46) == -1 && p.indexOf(42) == -1 && p.indexOf(47) == -1 && !p.trim().equals("")) {
            return true;
        }
        return pattern.endsWith("/*") && pattern.startsWith("/");
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    void read(WizardDescriptor d) {
    }

    void store(WizardDescriptor d) {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JSFConfigurationPanelVisual.class);
    }

    public void removeUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    public void insertUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    public void changedUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    public String getServletName() {
        return this.tServletName.getText();
    }

    public void setServletName(String name) {
        this.tServletName.setText(name);
    }

    public String getURLPattern() {
        return this.tURLPattern.getText();
    }

    public void setURLPattern(String pattern) {
        this.tURLPattern.setText(pattern);
    }

    public boolean validateXML() {
        return this.cbValidate.isSelected();
    }

    public void setValidateXML(boolean ver) {
        this.cbValidate.setSelected(ver);
    }

    public boolean verifyObjects() {
        return this.cbVerify.isSelected();
    }

    public void setVerifyObjects(boolean val) {
        this.cbVerify.setSelected(val);
    }

    public boolean packageJars() {
        return this.cbPackageJars.isSelected();
    }

    public void enableComponents(boolean enable) {
        this.cbPackageJars.setEnabled(enable);
        this.cbValidate.setEnabled(enable);
        this.cbVerify.setEnabled(enable);
        this.lServletName.setEnabled(enable);
        this.lURLPattern.setEnabled(enable);
        this.tServletName.setEnabled(enable);
        this.tURLPattern.setEnabled(enable);
    }
}

