/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.netbeans.modules.j2ee.sun.share.PrincipalNameMapping;
import org.netbeans.modules.j2ee.sun.share.SecurityMasterListModel;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.PrincipalTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.FixedHeightJTable;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.InputDialog;

public class SecurityAddPrincipalPanel
extends JPanel
implements ListSelectionListener {
    private static final ResourceBundle customizerBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.Bundle");
    private final PrincipalTableModel principalModel;
    private Dimension initialPreferredSize;
    private String principalName;
    private String className;
    private JTable existingPrincipalsTable;
    private SecurityMasterListModel existingPrincipalsModel;
    private TableModel versionedModel;
    private final boolean as90FeaturesVisible;
    private ButtonGroup buttonGroup;
    private JLabel jLblClassName;
    private JLabel jLblPrincipalEntryDesc;
    private JLabel jLblPrincipalName;
    private JLabel jLblPrincipalTableDesc;
    private JLabel jLblRequiredMark;
    private JTextField jTxtClassName;
    private JTextField jTxtPrincipalName;

    private SecurityAddPrincipalPanel(PrincipalTableModel pml, ASDDVersion asVersion) {
        this.principalModel = pml;
        this.className = null;
        this.principalName = null;
        this.as90FeaturesVisible = ASDDVersion.SUN_APPSERVER_9_0.compareTo(asVersion) <= 0;
        this.initComponents();
        this.initUserComponents();
        this.initFields();
    }

    protected String getPrincipalName() {
        return this.principalName;
    }

    protected String getClassName() {
        return this.className;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jLblPrincipalEntryDesc = new JLabel();
        this.jLblRequiredMark = new JLabel();
        this.jLblPrincipalName = new JLabel();
        this.jTxtPrincipalName = new JTextField();
        this.jLblClassName = new JLabel();
        this.jTxtClassName = new JTextField();
        this.jLblPrincipalTableDesc = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLblPrincipalEntryDesc.setText(customizerBundle.getString("LBL_PrincipalEntryDesc90"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jLblPrincipalEntryDesc, gridBagConstraints);
        this.jLblRequiredMark.setLabelFor(this.jTxtPrincipalName);
        this.jLblRequiredMark.setText("*");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 30, 0, 0);
        this.add((Component)this.jLblRequiredMark, gridBagConstraints);
        this.jLblPrincipalName.setLabelFor(this.jTxtPrincipalName);
        this.jLblPrincipalName.setText(customizerBundle.getString("LBL_PrincipalName_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblPrincipalName, gridBagConstraints);
        this.jTxtPrincipalName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                SecurityAddPrincipalPanel.this.jTxtPrincipalNameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 11);
        this.add((Component)this.jTxtPrincipalName, gridBagConstraints);
        this.jTxtPrincipalName.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_PrincipalName"));
        this.jTxtPrincipalName.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_PrincipalName"));
        this.jLblClassName.setLabelFor(this.jTxtClassName);
        this.jLblClassName.setText(customizerBundle.getString("LBL_ClassName_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblClassName, gridBagConstraints);
        this.jTxtClassName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                SecurityAddPrincipalPanel.this.jTxtClassNameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 11);
        this.add((Component)this.jTxtClassName, gridBagConstraints);
        this.jTxtClassName.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_ClassName"));
        this.jTxtClassName.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_ClassName"));
        this.jLblPrincipalTableDesc.setText(customizerBundle.getString("LBL_PrincipalTableDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jLblPrincipalTableDesc, gridBagConstraints);
    }

    private void jTxtClassNameKeyReleased(KeyEvent evt) {
        this.className = this.jTxtClassName.getText();
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void jTxtPrincipalNameKeyReleased(KeyEvent evt) {
        this.principalName = this.jTxtPrincipalName.getText();
        this.firePropertyChange("UserDataChanged", null, null);
    }

    private void initUserComponents() {
        if (!this.as90FeaturesVisible) {
            this.jLblPrincipalEntryDesc.setText(customizerBundle.getString("LBL_PrincipalEntryDesc81"));
            this.jLblClassName.setVisible(false);
            this.jTxtClassName.setVisible(false);
        }
        this.initialPreferredSize = this.getPreferredSize();
        this.existingPrincipalsTable = new FixedHeightJTable();
        this.existingPrincipalsTable.setSelectionMode(0);
        this.existingPrincipalsTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.existingPrincipalsTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 30, 11, 11);
        this.add((Component)scrollPane, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(customizerBundle.getString("ACSN_AddPrincipalName"));
        this.getAccessibleContext().setAccessibleDescription(customizerBundle.getString("ACSD_AddPrincipalName"));
    }

    private void initFields() {
        this.existingPrincipalsModel = SecurityMasterListModel.getPrincipalMasterModel();
        this.versionedModel = new VersionedPrincipalTableModel(this.existingPrincipalsModel, this.as90FeaturesVisible);
        this.existingPrincipalsTable.setModel(this.versionedModel);
        this.updateTextFields();
        this.setPreferredSize(new Dimension(this.initialPreferredSize.width, this.initialPreferredSize.height + 148));
    }

    private void updateTextFields() {
        this.jTxtPrincipalName.setText(this.principalName);
        this.jTxtClassName.setText(this.className);
    }

    public void valueChanged(ListSelectionEvent e) {
        Object entry;
        int selectedRow;
        ListSelectionModel selModel = this.existingPrincipalsTable.getSelectionModel();
        if (!selModel.getValueIsAdjusting() && (selectedRow = this.existingPrincipalsTable.getSelectedRow()) != -1 && (entry = this.existingPrincipalsModel.getRow(selectedRow)) instanceof PrincipalNameMapping) {
            PrincipalNameMapping principalEntry = (PrincipalNameMapping)entry;
            this.principalName = principalEntry.getPrincipalName();
            this.className = principalEntry.getClassName();
            this.updateTextFields();
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    Collection getErrors() {
        String newClassName;
        ArrayList<String> errors = new ArrayList<String>();
        String newPrincipalName = this.getPrincipalName();
        if (!Utils.notEmpty(newPrincipalName)) {
            errors.add(customizerBundle.getString("ERR_BlankPrincipalName"));
        }
        if (newPrincipalName != null && this.principalModel.contains(new PrincipalNameMapping(newPrincipalName))) {
            errors.add(MessageFormat.format(customizerBundle.getString("ERR_PrincipalExists"), newPrincipalName));
        }
        if (this.as90FeaturesVisible && Utils.notEmpty(newClassName = this.getClassName()) && !Utils.isJavaClass(newClassName)) {
            errors.add(customizerBundle.getString("ERR_InvalidJavaClassName"));
        }
        return errors;
    }

    private void commit() {
        String newPrincipalName = this.getPrincipalName();
        String newClassName = this.getClassName();
        this.principalModel.addElement(new PrincipalNameMapping(newPrincipalName, newClassName));
        PrincipalNameMapping tmpMapping = new PrincipalNameMapping(newPrincipalName, newClassName);
        if (!this.existingPrincipalsModel.contains(tmpMapping)) {
            this.existingPrincipalsModel.addElement(tmpMapping);
        }
    }

    static void addPrincipalName(JPanel parent, PrincipalTableModel model, ASDDVersion asVersion) {
        SecurityAddPrincipalPanel addPrincipalPanel = new SecurityAddPrincipalPanel(model, asVersion);
        addPrincipalPanel.displayDialog(parent, customizerBundle.getString("TITLE_AddPrincipal"), "AS_CFG_SecurityRoleNewPrincipal");
    }

    private void displayDialog(JPanel parent, String title, String helpId) {
        BetterInputDialog dialog = new BetterInputDialog(parent, title, helpId, this);
        do {
            int dialogChoice = dialog.display();
            if (dialogChoice == 0) break;
            if (dialogChoice != 1) continue;
            Collection errors = this.getErrors();
            if (dialog.hasErrors()) {
                dialog.showErrors();
                continue;
            }
            this.commit();
        } while (dialog.hasErrors());
    }

    private static class VersionedPrincipalTableModel
    implements TableModel {
        private final SecurityMasterListModel realModel;
        private final boolean showClassColumn;

        public VersionedPrincipalTableModel(SecurityMasterListModel model, boolean showClasses) {
            this.realModel = model;
            this.showClassColumn = showClasses;
        }

        public void removeTableModelListener(TableModelListener l) {
            this.realModel.removeTableModelListener(l);
        }

        public void addTableModelListener(TableModelListener l) {
            this.realModel.addTableModelListener(l);
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.realModel.setValueAt(aValue, rowIndex, columnIndex);
        }

        public String getColumnName(int columnIndex) {
            return this.realModel.getColumnName(columnIndex);
        }

        public Class getColumnClass(int columnIndex) {
            return this.realModel.getColumnClass(columnIndex);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.realModel.isCellEditable(rowIndex, columnIndex);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.realModel.getValueAt(rowIndex, columnIndex);
        }

        public int getRowCount() {
            return this.realModel.getRowCount();
        }

        public int getColumnCount() {
            return this.showClassColumn ? this.realModel.getColumnCount() : 1;
        }
    }

    private static class BetterInputDialog
    extends InputDialog {
        private final SecurityAddPrincipalPanel dialogPanel;
        private final String panelHelpId;

        public BetterInputDialog(JPanel parent, String title, String helpId, SecurityAddPrincipalPanel childPanel) {
            super(parent, title);
            this.dialogPanel = childPanel;
            this.panelHelpId = helpId;
            this.dialogPanel.setPreferredSize(new Dimension(parent.getWidth() * 3 / 4, this.dialogPanel.getPreferredSize().height));
            this.getAccessibleContext().setAccessibleName(this.dialogPanel.getAccessibleContext().getAccessibleName());
            this.getAccessibleContext().setAccessibleDescription(this.dialogPanel.getAccessibleContext().getAccessibleDescription());
            this.getContentPane().add((Component)childPanel, "Center");
            this.addListeners();
            this.pack();
            this.setLocationInside(parent);
            this.handleErrorDisplay();
        }

        private void addListeners() {
            this.dialogPanel.addPropertyChangeListener("UserDataChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    BetterInputDialog.this.handleErrorDisplay();
                }
            });
        }

        private void handleErrorDisplay() {
            ArrayList errors = new ArrayList();
            errors.addAll(this.dialogPanel.getErrors());
            this.setErrors(errors);
        }

        protected String getHelpId() {
            return this.panelHelpId;
        }
    }
}

