/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.ValidationError;

public final class ErrorMessageDB {
    private Map errorSets = new HashMap(19);
    public static final String VALIDATION_STATE_CHANGED = "validationStateChanged";
    public static final String PARTITION_STATE_CHANGED = "partitionStateChanged";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private ErrorMessageDB() {
    }

    public Set getErrorPartitions() {
        return Collections.unmodifiableSet(this.errorSets.keySet());
    }

    public List getErrors(ValidationError.Partition partition) {
        List errorList = (List)this.errorSets.get(partition);
        if (errorList != null) {
            errorList = Collections.unmodifiableList(errorList);
        }
        return errorList;
    }

    public void addErrors(Collection errors) {
        Iterator iter = errors.iterator();
        while (iter.hasNext()) {
            this.addErrorImpl((ValidationError)iter.next());
        }
    }

    public void addError(ValidationError error) {
        this.addErrorImpl(error);
    }

    public void removeError(ValidationError error) {
        List errorList = (List)this.errorSets.get(error.getPartition());
        if (errorList != null) {
            int index = errorList.indexOf(error);
            if (index != -1) {
                errorList.remove(index);
                this.firePartitionStateChanged(error.getPartition(), true, errorList.size() != 0);
            }
            if (errorList.size() == 0) {
                this.errorSets.remove(error.getPartition());
                if (this.errorSets.size() == 0) {
                    this.fireValidationStateChanged(true);
                }
            }
        }
    }

    public void updateError(ValidationError error) {
        if (Utils.notEmpty(error.getMessage())) {
            this.addErrorImpl(error);
        } else {
            this.removeError(error);
        }
    }

    private void addErrorImpl(ValidationError error) {
        boolean oldHasMessages;
        boolean oldIsValid = this.errorSets.size() == 0;
        List errorList = this.getOrCreateErrorList(error.getPartition());
        boolean bl = oldHasMessages = errorList.size() != 0;
        if (errorList.contains(error)) {
            errorList.remove(error);
        }
        errorList.add(error);
        if (oldIsValid) {
            this.fireValidationStateChanged(false);
        }
        this.firePartitionStateChanged(error.getPartition(), oldHasMessages, true);
    }

    private List getOrCreateErrorList(ValidationError.Partition partition) {
        ArrayList errorList = (ArrayList)this.errorSets.get(partition);
        if (errorList == null) {
            errorList = new ArrayList();
            this.errorSets.put(partition, errorList);
        }
        return errorList;
    }

    public void clearErrors() {
        int numInvalidPartitions = this.errorSets.size();
        if (numInvalidPartitions > 0) {
            ArrayList partitionList = new ArrayList(this.errorSets.keySet());
            this.errorSets.clear();
            this.fireValidationStateChanged(true);
            Iterator iter = partitionList.iterator();
            while (iter.hasNext()) {
                this.firePartitionStateChanged((ValidationError.Partition)iter.next(), true, false);
            }
        }
    }

    public boolean hasErrors() {
        return this.errorSets.size() > 0;
    }

    public boolean hasErrors(ValidationError.Partition partition) {
        boolean result = false;
        List errorList = (List)this.errorSets.get(partition);
        if (errorList != null && errorList.size() > 0) {
            result = true;
        }
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener pCL) {
        this.propertyChangeSupport.addPropertyChangeListener(pCL);
    }

    public void removePropertyChangeListener(PropertyChangeListener pCL) {
        this.propertyChangeSupport.removePropertyChangeListener(pCL);
    }

    private void fireValidationStateChanged(boolean newState) {
        this.propertyChangeSupport.firePropertyChange(VALIDATION_STATE_CHANGED, !newState, newState);
    }

    private void firePartitionStateChanged(ValidationError.Partition partition, boolean oldHasMessages, boolean newHasMessages) {
        PartitionState oldPartitionState = new PartitionState(partition, oldHasMessages);
        PartitionState newPartitionState = new PartitionState(partition, newHasMessages);
        this.propertyChangeSupport.firePropertyChange(PARTITION_STATE_CHANGED, oldPartitionState, newPartitionState);
    }

    public static ErrorMessageDB getMessageDB(Base bean) {
        ErrorMessageDB messageDB = null;
        if (bean != null) {
            messageDB = bean.getMessageDB();
        }
        return messageDB;
    }

    static ErrorMessageDB createMessageDB() {
        return new ErrorMessageDB();
    }

    public static class PartitionState {
        private final ValidationError.Partition thePartition;
        private final boolean hasMessages;

        private PartitionState(ValidationError.Partition partition, boolean hasMsgs) {
            this.thePartition = partition;
            this.hasMessages = hasMsgs;
        }

        public ValidationError.Partition getPartition() {
            return this.thePartition;
        }

        public boolean hasMessages() {
            return this.hasMessages;
        }
    }
}

