/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.ConfigurationSupport;
import org.netbeans.modules.j2ee.sun.share.config.ConfigDataObject;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.config.ui.ConfigBeanTopComponent;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;

public class SecondaryConfigDataObject
extends ConfigDataObject {
    private ConfigDataObject primary;

    public SecondaryConfigDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
    }

    public boolean isSecondaryOf(ConfigDataObject primary) {
        return this.getPrimaryDataObject() == primary;
    }

    public SunONEDeploymentConfiguration getDeploymentConfiguration() throws ConfigurationException {
        ConfigDataObject p = this.getPrimaryDataObject();
        FileObject fo = p.getPrimaryFile();
        String serverId = this.getProvider().getServerID();
        ConfigurationSupport.requestCreateConfiguration((FileObject)fo, (String)serverId);
        return SunONEDeploymentConfiguration.getConfiguration(FileUtil.toFile((FileObject)fo));
    }

    private ConfigDataObject getPrimaryDataObject() {
        FileObject folder;
        FileObject sejFO;
        if (!(this.primary != null && this.primary.isValid() || (sejFO = (folder = this.getPrimaryFile().getParent()).getFileObject("sun-ejb-jar", "xml")) == null)) {
            try {
                DataObject dObj = DataObject.find((FileObject)sejFO);
                this.primary = (ConfigDataObject)dObj.getCookie(ConfigDataObject.class);
                if (this.primary != null) {
                    this.primary.addSecondary(this);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return this.primary;
    }

    private EditCookie _getEditCookie() {
        ConfigDataObject cdo = this.getPrimaryDataObject();
        EditCookie primaryEdit = cdo == null ? null : cdo.getEditCookie();
        EditCookie myEdit = super.getEditCookie();
        if (primaryEdit != null) {
            return myEdit;
        }
        return null;
    }

    private OpenCookie _getOpenCookie() {
        ConfigDataObject cdo = this.getPrimaryDataObject();
        return cdo == null ? null : (OpenCookie)cdo.getCookie(OpenCookie.class);
    }

    public Node.Cookie getCookie(Class c) {
        if (OpenCookie.class.isAssignableFrom(c)) {
            return this._getOpenCookie();
        }
        if (EditCookie.class.isAssignableFrom(c)) {
            return this._getEditCookie();
        }
        return super.getCookie(c);
    }

    protected Set getSecondaries() {
        return Collections.EMPTY_SET;
    }

    protected ConfigurationStorage getStorage() {
        ConfigDataObject cdo = this.getPrimaryDataObject();
        return cdo == null ? null : cdo.getStorage();
    }

    protected void openConfigEditor() {
        ConfigDataObject cdo = this.getPrimaryDataObject();
        if (cdo != null) {
            this.getPrimaryDataObject().openConfigEditor();
            this.firePropertyChange("cookie", null, null);
        }
    }

    protected ConfigBeanTopComponent findOpenedConfigEditor() {
        ConfigDataObject cdo = this.getPrimaryDataObject();
        return cdo == null ? null : cdo.findOpenedConfigEditor();
    }

    public boolean closeConfigEditors() {
        ConfigDataObject cdo = this.getPrimaryDataObject();
        return cdo == null ? false : cdo.closeConfigEditors();
    }

    public void fileDeleted(FileEvent fe) {
        if (fe.getFile().equals(this.getPrimaryFile()) && this.getPrimaryDataObject() != null) {
            this.primary.removeSecondary(this);
        }
    }

    protected void fireCookieChange() {
        this.fireLimitedCookieChange();
        ConfigDataObject cdo = this.getPrimaryDataObject();
        if (cdo != null) {
            cdo.fireLimitedCookieChange();
        }
    }

    public void setChanged() {
        this.addSaveCookie(new S0());
    }

    private class S0
    implements SaveCookie {
        private S0() {
        }

        public void save() throws IOException {
            ConfigDataObject cdo = SecondaryConfigDataObject.this.getPrimaryDataObject();
            if (cdo != null) {
                cdo.resetAllChanged();
            }
        }
    }
}

