/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerDisplay;
import org.netbeans.modules.apisupport.project.ui.customizer.JavaPlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeTableView;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Element;

final class SuiteCustomizerLibraries
extends NbPropertyPanel.Suite
implements Comparator,
ExplorerManager.Provider,
ChangeListener {
    private ExplorerManager manager;
    private ModuleEntry[] platformModules;
    private JLabel filler;
    private JButton javaPlatformButton;
    private JComboBox javaPlatformCombo;
    private JLabel javaPlatformLabel;
    private JButton managePlafsButton;
    private JLabel platform;
    private JComboBox platformValue;
    private JPanel platformsPanel;
    private TreeTableView view;
    private JLabel viewLabel;
    private static final Set DISABLED_PLATFORM_MODULES;
    private RequestProcessor.Task updateDependencyWarningsTask;
    private Set universe;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SuiteCustomizerLibraries(SuiteProperties suiteProps) {
        super(suiteProps, SuiteCustomizerLibraries.class);
        this.initComponents();
        this.initAccessibility();
        this.manager = new ExplorerManager();
        this.refresh();
        this.view.setProperties(new Node.Property[]{EnabledProp.TEMPLATE});
        this.view.setRootVisible(false);
        this.view.setDefaultActionAllowed(false);
        suiteProps.getBrandingModel().addChangeListener(this);
        suiteProps.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("nbPlatform".equals(evt.getPropertyName())) {
                    SuiteCustomizerLibraries.this.refresh();
                }
            }
        });
        this.javaPlatformCombo.setRenderer(JavaPlatformComponentFactory.javaPlatformListCellRenderer());
    }

    void refresh() {
        this.refreshJavaPlatforms();
        this.refreshPlatforms();
        this.refreshModules();
        this.updateJavaPlatformEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshModules() {
        this.platformModules = this.getProperties().getActivePlatform().getModules();
        Node root = this.createPlatformModulesNode();
        this.manager.setRootContext(root);
        SuiteCustomizerLibraries suiteCustomizerLibraries = this;
        synchronized (suiteCustomizerLibraries) {
            this.universe = null;
        }
        this.updateDependencyWarnings();
    }

    private void refreshJavaPlatforms() {
        this.javaPlatformCombo.setModel(JavaPlatformComponentFactory.javaPlatformListModel());
        this.javaPlatformCombo.setSelectedItem(this.getProperties().getActiveJavaPlatform());
    }

    private void refreshPlatforms() {
        this.platformValue.setModel(new PlatformComponentFactory.NbPlatformListModel());
        this.platformValue.setSelectedItem(this.getProperties().getActivePlatform());
        this.platformValue.requestFocus();
    }

    public void store() {
        TreeSet<String> enabledClusters = new TreeSet<String>();
        TreeSet<String> disabledModules = new TreeSet<String>();
        Node[] clusters = this.getExplorerManager().getRootContext().getChildren().getNodes();
        for (int i = 0; i < clusters.length; ++i) {
            Enabled e;
            if (!(clusters[i] instanceof Enabled) || !(e = (Enabled)clusters[i]).isEnabled()) continue;
            enabledClusters.add(e.getName());
            Node[] modules = e.getChildren().getNodes();
            for (int j = 0; j < modules.length; ++j) {
                Enabled m;
                if (!(modules[j] instanceof Enabled) || (m = (Enabled)modules[j]).isEnabled()) continue;
                disabledModules.add(m.getName());
            }
        }
        this.getProperties().setEnabledClusters(enabledClusters.toArray(new String[enabledClusters.size()]));
        this.getProperties().setDisabledModules(disabledModules.toArray(new String[disabledModules.size()]));
    }

    private void initComponents() {
        this.platformsPanel = new JPanel();
        this.platformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.platform = new JLabel();
        this.managePlafsButton = new JButton();
        this.javaPlatformLabel = new JLabel();
        this.javaPlatformCombo = new JComboBox();
        this.javaPlatformButton = new JButton();
        this.filler = new JLabel();
        this.view = new TreeTableView();
        this.viewLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.platformsPanel.setLayout(new GridBagLayout());
        this.platformValue.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SuiteCustomizerLibraries.this.platformValueItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.platformsPanel.add((Component)this.platformValue, gridBagConstraints);
        this.platform.setLabelFor(this.platformValue);
        Mnemonics.setLocalizedText((JLabel)this.platform, (String)NbBundle.getMessage((Class)SuiteCustomizerLibraries.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.platformsPanel.add((Component)this.platform, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.managePlafsButton, (String)NbBundle.getMessage((Class)SuiteCustomizerLibraries.class, (String)"CTL_ManagePlatform_a"));
        this.managePlafsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerLibraries.this.managePlatforms(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.platformsPanel.add((Component)this.managePlafsButton, gridBagConstraints);
        this.javaPlatformLabel.setLabelFor(this.javaPlatformCombo);
        Mnemonics.setLocalizedText((JLabel)this.javaPlatformLabel, (String)NbBundle.getMessage((Class)SuiteCustomizerLibraries.class, (String)"LBL_Java_Platform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformsPanel.add((Component)this.javaPlatformLabel, gridBagConstraints);
        this.javaPlatformCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SuiteCustomizerLibraries.this.javaPlatformComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformsPanel.add((Component)this.javaPlatformCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.javaPlatformButton, (String)NbBundle.getMessage((Class)SuiteCustomizerLibraries.class, (String)"LBL_Manage_Java_Platforms"));
        this.javaPlatformButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerLibraries.this.javaPlatformButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.platformsPanel.add((Component)this.javaPlatformButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.platformsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
        this.view.setBorder(UIManager.getBorder("ScrollPane.border"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.view, gridBagConstraints);
        this.viewLabel.setLabelFor((Component)this.view);
        Mnemonics.setLocalizedText((JLabel)this.viewLabel, (String)NbBundle.getMessage((Class)SuiteCustomizerLibraries.class, (String)"LBL_PlatformModules"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 0, 2, 0);
        this.add((Component)this.viewLabel, gridBagConstraints);
    }

    private void javaPlatformButtonActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)this.javaPlatformCombo.getSelectedItem()));
    }

    private void javaPlatformComboItemStateChanged(ItemEvent evt) {
        this.getProperties().setActiveJavaPlatform((JavaPlatform)this.javaPlatformCombo.getSelectedItem());
        this.refreshJavaPlatforms();
    }

    private void platformValueItemStateChanged(ItemEvent evt) {
        this.getProperties().setActivePlatform((NbPlatform)this.platformValue.getSelectedItem());
        this.refreshModules();
        this.updateJavaPlatformEnabled();
    }

    private void managePlatforms(ActionEvent evt) {
        NbPlatformCustomizer.showCustomizer();
        this.refreshPlatforms();
    }

    private Node createPlatformModulesNode() {
        HashSet<String> disabledModuleCNB = new HashSet<String>(Arrays.asList(this.getProperties().getDisabledModules()));
        HashSet<String> enabledClusters = new HashSet<String>(Arrays.asList(this.getProperties().getEnabledClusters()));
        HashMap<File, Children.SortedArray> clusterToChildren = new HashMap<File, Children.SortedArray>();
        Children.SortedArray clusters = new Children.SortedArray();
        clusters.setComparator((Comparator)this);
        AbstractNode n = new AbstractNode((Children)clusters);
        n.setName(SuiteCustomizerLibraries.getMessage("LBL_ModuleListClusters"));
        n.setDisplayName(SuiteCustomizerLibraries.getMessage("LBL_ModuleListClustersModules"));
        for (int i = 0; i < this.platformModules.length; ++i) {
            String cnb;
            Children clusterChildren = (Children)clusterToChildren.get(this.platformModules[i].getClusterDirectory());
            if (clusterChildren == null) {
                Children.SortedArray modules = new Children.SortedArray();
                modules.setComparator((Comparator)this);
                clusterChildren = modules;
                String clusterName = this.platformModules[i].getClusterDirectory().getName();
                Enabled cluster = new Enabled((Children)modules, enabledClusters.contains(clusterName));
                cluster.setName(clusterName);
                cluster.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/suite/resources/suite.gif");
                clusterToChildren.put(this.platformModules[i].getClusterDirectory(), modules);
                n.getChildren().add(new Node[]{cluster});
            }
            Enabled module = new Enabled(Children.LEAF, !disabledModuleCNB.contains(cnb = this.platformModules[i].getCodeNameBase()));
            module.setName(cnb);
            module.setDisplayName(this.platformModules[i].getLocalizedName());
            String desc = this.platformModules[i].getShortDescription();
            String tooltip = desc != null ? (desc.startsWith("<html>") ? "<html>" + NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries == null ? SuiteCustomizerLibraries.class$("org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizerLibraries") : class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries), (String)"SuiteCustomizerLibraries.HINT_module_desc", (Object)cnb, (Object)desc.substring(6)) : NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries == null ? SuiteCustomizerLibraries.class$("org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizerLibraries") : class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries), (String)"SuiteCustomizerLibraries.HINT_module_desc", (Object)cnb, (Object)desc)) : NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries == null ? SuiteCustomizerLibraries.class$("org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizerLibraries") : class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries), (String)"SuiteCustomizerLibraries.HINT_module_no_desc", (Object)cnb);
            module.setShortDescription(tooltip);
            module.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.gif");
            clusterChildren.add(new Node[]{module});
        }
        return n;
    }

    public int compare(Object o1, Object o2) {
        Node n1 = (Node)o1;
        Node n2 = (Node)o2;
        return n1.getDisplayName().compareTo(n2.getDisplayName());
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void stateChanged(ChangeEvent ev) {
        if (this.getProperties().getBrandingModel().isBrandingEnabled()) {
            Enabled m;
            int j;
            Node[] modules;
            Enabled e;
            int i;
            Node[] clusters = this.getExplorerManager().getRootContext().getChildren().getNodes();
            for (i = 0; i < clusters.length; ++i) {
                if (!(clusters[i] instanceof Enabled)) continue;
                e = (Enabled)clusters[i];
                if (!e.isEnabled()) {
                    return;
                }
                modules = e.getChildren().getNodes();
                for (j = 0; j < modules.length; ++j) {
                    if (!(modules[j] instanceof Enabled) || (m = (Enabled)modules[j]).isEnabled()) continue;
                    return;
                }
            }
            if (!UIUtil.showAcceptCancelDialog(SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.title.exclude_ide_modules"), SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.text.exclude_ide_modules"), SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.button.exclude"), SuiteCustomizerLibraries.getMessage("SuiteCustomizerLibraries.button.skip"), 3)) {
                return;
            }
            for (i = 0; i < clusters.length; ++i) {
                if (!(clusters[i] instanceof Enabled)) continue;
                e = (Enabled)clusters[i];
                if (e.getName().startsWith("platform")) {
                    modules = e.getChildren().getNodes();
                    for (j = 0; j < modules.length; ++j) {
                        if (!(modules[j] instanceof Enabled) || !DISABLED_PLATFORM_MODULES.contains((m = (Enabled)modules[j]).getName())) continue;
                        m.setEnabled(false);
                    }
                    continue;
                }
                e.setEnabled(false);
            }
        }
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage((Class)CustomizerDisplay.class, (String)key);
    }

    private void initAccessibility() {
        this.managePlafsButton.getAccessibleContext().setAccessibleDescription(SuiteCustomizerLibraries.getMessage("ACSD_ManagePlafsButton"));
        this.platformValue.getAccessibleContext().setAccessibleDescription(SuiteCustomizerLibraries.getMessage("ACSD_PlatformValue"));
        this.javaPlatformCombo.getAccessibleContext().setAccessibleDescription(SuiteCustomizerLibraries.getMessage("ACSD_JavaPlatformCombo"));
        this.javaPlatformButton.getAccessibleContext().setAccessibleDescription(SuiteCustomizerLibraries.getMessage("ACSD_JavaPlatformButton"));
    }

    private void updateDependencyWarnings() {
        if (this.updateDependencyWarningsTask == null) {
            this.updateDependencyWarningsTask = RequestProcessor.getDefault().create(new Runnable(){

                public void run() {
                    SuiteCustomizerLibraries.this.doUpdateDependencyWarnings();
                }
            });
        }
        this.updateDependencyWarningsTask.schedule(0);
    }

    static Set loadUniverseModules(ModuleEntry[] platformModules, Set suiteModules) throws IOException {
        LinkedHashSet<AbstractUniverseModule> universe = new LinkedHashSet<AbstractUniverseModule>();
        Iterator it = suiteModules.iterator();
        while (it.hasNext()) {
            universe.add(new SuiteModule((NbModuleProject)it.next()));
        }
        for (int i = 0; i < platformModules.length; ++i) {
            universe.add(new PlatformModule(platformModules[i]));
        }
        return universe;
    }

    static String[] findWarning(Set universeModules, Set enabledClusters, Set disabledModules) {
        UniverseModule m;
        TreeMap<String, UniverseModule> sortedModules = new TreeMap<String, UniverseModule>();
        HashSet<UniverseModule> excluded = new HashSet<UniverseModule>();
        HashMap<String, HashSet<UniverseModule>> providers = new HashMap<String, HashSet<UniverseModule>>();
        Iterator<Object> it = universeModules.iterator();
        while (it.hasNext()) {
            m = (UniverseModule)it.next();
            String cnb = m.getCodeNameBase();
            String cluster = m.getCluster();
            if (cluster != null && (!enabledClusters.contains(cluster) || disabledModules.contains(cnb))) {
                excluded.add(m);
            }
            sortedModules.put(cnb, m);
            Iterator provides = m.getProvidedTokens().iterator();
            while (provides.hasNext()) {
                String tok = (String)provides.next();
                HashSet<UniverseModule> providersOf = (HashSet<UniverseModule>)providers.get(tok);
                if (providersOf == null) {
                    providersOf = new HashSet<UniverseModule>();
                    providers.put(tok, providersOf);
                }
                providersOf.add(m);
            }
        }
        it = sortedModules.values().iterator();
        while (it.hasNext()) {
            String[] warning;
            m = (UniverseModule)it.next();
            if (excluded.contains(m) || (warning = SuiteCustomizerLibraries.findWarning(m, sortedModules, providers, excluded)) == null) continue;
            return warning;
        }
        return null;
    }

    private synchronized void doUpdateDependencyWarnings() {
        if (this.universe == null) {
            try {
                Set suiteModules = this.getProperties().getSubModules();
                this.universe = SuiteCustomizerLibraries.loadUniverseModules(this.platformModules, suiteModules);
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
                return;
            }
        }
        TreeSet<String> enabledClusters = new TreeSet<String>();
        TreeSet<String> disabledModules = new TreeSet<String>();
        Node[] clusters = this.getExplorerManager().getRootContext().getChildren().getNodes();
        for (int i = 0; i < clusters.length; ++i) {
            Enabled e;
            if (!(clusters[i] instanceof Enabled) || !(e = (Enabled)clusters[i]).isEnabled()) continue;
            enabledClusters.add(e.getName());
            Node[] modules = e.getChildren().getNodes();
            for (int j = 0; j < modules.length; ++j) {
                Enabled m;
                if (!(modules[j] instanceof Enabled) || (m = (Enabled)modules[j]).isEnabled()) continue;
                disabledModules.add(m.getName());
            }
        }
        final String[] warning = SuiteCustomizerLibraries.findWarning(this.universe, enabledClusters, disabledModules);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (warning != null) {
                    String key = warning[0];
                    Object[] args = new String[warning.length - 1];
                    System.arraycopy(warning, 1, args, 0, args.length);
                    SuiteCustomizerLibraries.this.setWarning(NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries == null ? (class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries = SuiteCustomizerLibraries.class$("org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizerLibraries")) : class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerLibraries), (String)key, (Object[])args));
                } else {
                    SuiteCustomizerLibraries.this.setWarning(null);
                }
            }
        });
    }

    private static String[] findWarning(UniverseModule m, Map modules, Map providers, Set excluded) {
        TreeSet deps = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                Dependency d1 = (Dependency)o1;
                Dependency d2 = (Dependency)o2;
                return d1.getName().compareTo(d2.getName());
            }
        });
        deps.addAll(m.getModuleDependencies());
        Iterator it = deps.iterator();
        while (it.hasNext()) {
            String needed;
            int mrvHi;
            int mrvLo;
            String cnb;
            Dependency d = (Dependency)it.next();
            String codename = d.getName();
            int slash = codename.lastIndexOf(47);
            if (slash == -1) {
                cnb = codename;
                mrvLo = -1;
                mrvHi = -1;
            } else {
                cnb = codename.substring(0, slash);
                String mrv = codename.substring(slash + 1);
                int dash = mrv.lastIndexOf(45);
                if (dash == -1) {
                    mrvLo = mrvHi = Integer.parseInt(mrv);
                } else {
                    mrvLo = Integer.parseInt(mrv.substring(0, dash));
                    mrvHi = Integer.parseInt(mrv.substring(dash + 1));
                }
            }
            UniverseModule dep = (UniverseModule)modules.get(cnb);
            if (dep == null) {
                if (m.getCluster() != null) {
                    return new String[]{"ERR_platform_no_dep", m.getDisplayName(), m.getCluster(), cnb};
                }
                return new String[]{"ERR_suite_no_dep", m.getDisplayName(), cnb};
            }
            if (excluded.contains(dep)) {
                if (!$assertionsDisabled && dep.getCluster() == null) {
                    throw new AssertionError();
                }
                if (m.getCluster() != null) {
                    return new String[]{"ERR_platform_excluded_dep", m.getDisplayName(), m.getCluster(), dep.getDisplayName(), dep.getCluster()};
                }
                return new String[]{"ERR_suite_excluded_dep", m.getDisplayName(), dep.getDisplayName(), dep.getCluster()};
            }
            if (dep.getReleaseVersion() < mrvLo || dep.getReleaseVersion() > mrvHi) {
                if (m.getCluster() != null) {
                    return new String[]{"ERR_platform_bad_dep_mrv", m.getDisplayName(), m.getCluster(), dep.getDisplayName()};
                }
                return new String[]{"ERR_suite_bad_dep_mrv", m.getDisplayName(), dep.getDisplayName()};
            }
            if (d.getComparison() == 1) {
                SpecificationVersion needed2 = new SpecificationVersion(d.getVersion());
                SpecificationVersion found = dep.getSpecificationVersion();
                if (found != null && found.compareTo((Object)needed2) >= 0) continue;
                if (m.getCluster() != null) {
                    return new String[]{"ERR_platform_bad_dep_spec", m.getDisplayName(), m.getCluster(), dep.getDisplayName()};
                }
                return new String[]{"ERR_suite_bad_dep_spec", m.getDisplayName(), dep.getDisplayName()};
            }
            if (d.getComparison() != 2 || (needed = d.getVersion()).equals("*") || needed.equals(dep.getImplementationVersion())) continue;
            if (!$assertionsDisabled && m.getCluster() == null) {
                throw new AssertionError();
            }
            return new String[]{"ERR_platform_bad_dep_impl", m.getDisplayName(), m.getCluster(), dep.getDisplayName()};
        }
        Iterator toks = new TreeSet(m.getRequiredTokens()).iterator();
        while (toks.hasNext()) {
            String tok = (String)toks.next();
            UniverseModule wouldBeProvider = null;
            boolean found = false;
            Set possibleProviders = (Set)providers.get(tok);
            if (possibleProviders != null) {
                it = possibleProviders.iterator();
                while (it.hasNext()) {
                    UniverseModule p = (UniverseModule)it.next();
                    if (excluded.contains(p)) {
                        if (wouldBeProvider != null) continue;
                        wouldBeProvider = p;
                        continue;
                    }
                    found = true;
                    break;
                }
            }
            if (found) continue;
            if (wouldBeProvider != null) {
                if (!$assertionsDisabled && wouldBeProvider.getCluster() == null) {
                    throw new AssertionError();
                }
                if (m.getCluster() != null) {
                    return new String[]{"ERR_platform_only_excluded_providers", tok, m.getDisplayName(), m.getCluster(), wouldBeProvider.getDisplayName(), wouldBeProvider.getCluster()};
                }
                return new String[]{"ERR_suite_only_excluded_providers", tok, m.getDisplayName(), wouldBeProvider.getDisplayName(), wouldBeProvider.getCluster()};
            }
            if (m.getCluster() != null) {
                return new String[]{"ERR_platform_no_providers", tok, m.getDisplayName(), m.getCluster()};
            }
            return new String[]{"ERR_suite_no_providers", tok, m.getDisplayName()};
        }
        return null;
    }

    private void updateJavaPlatformEnabled() {
        boolean enabled = ((NbPlatform)this.platformValue.getSelectedItem()).getHarnessVersion() >= 2;
        this.javaPlatformCombo.setEnabled(enabled);
        this.javaPlatformButton.setEnabled(enabled);
    }

    static {
        $assertionsDisabled = !SuiteCustomizerLibraries.class.desiredAssertionStatus();
        DISABLED_PLATFORM_MODULES = new HashSet();
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.autoupdate");
        DISABLED_PLATFORM_MODULES.add("org.openide.execution");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.core.execution");
        DISABLED_PLATFORM_MODULES.add("org.openide.io");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.core.output2");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.core.multiview");
        DISABLED_PLATFORM_MODULES.add("org.netbeans.modules.favorites");
        DISABLED_PLATFORM_MODULES.add("org.openide.compat");
        DISABLED_PLATFORM_MODULES.add("org.openide.util.enumerations");
    }

    private static final class SuiteModule
    extends AbstractUniverseModule {
        private final NbModuleProject project;
        private final Set dependencies;

        public SuiteModule(NbModuleProject project) {
            super(ManifestManager.getInstance(project.getManifest(), false));
            this.project = project;
            this.dependencies = new HashSet();
            Element dataE = project.getHelper().getPrimaryConfigurationData(true);
            Element depsE = Util.findElement(dataE, "module-dependencies", "http://www.netbeans.org/ns/nb-module-project/2");
            Iterator deps = Util.findSubElements(depsE).iterator();
            while (deps.hasNext()) {
                Element specverE;
                Element dep = (Element)deps.next();
                Element run = Util.findElement(dep, "run-dependency", "http://www.netbeans.org/ns/nb-module-project/2");
                if (run == null) continue;
                String text = Util.findText(Util.findElement(dep, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/2"));
                Element relverE = Util.findElement(run, "release-version", "http://www.netbeans.org/ns/nb-module-project/2");
                if (relverE != null) {
                    text = text + '/' + Util.findText(relverE);
                }
                if ((specverE = Util.findElement(run, "specification-version", "http://www.netbeans.org/ns/nb-module-project/2")) != null) {
                    text = text + " > " + Util.findText(specverE);
                } else {
                    Element implver = Util.findElement(run, "implementation-version", "http://www.netbeans.org/ns/nb-module-project/2");
                    if (implver != null) {
                        text = text + " = *";
                    }
                }
                this.dependencies.addAll(Dependency.create((int)1, (String)text));
            }
        }

        public String getCodeNameBase() {
            return this.project.getCodeNameBase();
        }

        public SpecificationVersion getSpecificationVersion() {
            String s = this.project.getSpecVersion();
            return s != null ? new SpecificationVersion(s) : null;
        }

        public Set getModuleDependencies() {
            return this.dependencies;
        }

        public String getCluster() {
            return null;
        }

        public String getDisplayName() {
            return ProjectUtils.getInformation((Project)this.project).getDisplayName();
        }
    }

    private static final class PlatformModule
    extends AbstractUniverseModule {
        private final ModuleEntry entry;

        public PlatformModule(ModuleEntry entry) throws IOException {
            super(ManifestManager.getInstanceFromJAR(entry.getJarLocation()));
            this.entry = entry;
        }

        public String getCodeNameBase() {
            return this.entry.getCodeNameBase();
        }

        public SpecificationVersion getSpecificationVersion() {
            String s = this.entry.getSpecificationVersion();
            return s != null ? new SpecificationVersion(s) : null;
        }

        public Set getModuleDependencies() {
            return this.mm.getModuleDependencies();
        }

        public String getCluster() {
            return this.entry.getClusterDirectory().getName();
        }

        public String getDisplayName() {
            return this.entry.getLocalizedName();
        }
    }

    private static abstract class AbstractUniverseModule
    implements UniverseModule {
        protected final ManifestManager mm;

        protected AbstractUniverseModule(ManifestManager mm) {
            this.mm = mm;
        }

        public int getReleaseVersion() {
            String s = this.mm.getReleaseVersion();
            return s != null ? Integer.parseInt(s) : -1;
        }

        public String getImplementationVersion() {
            return this.mm.getImplementationVersion();
        }

        public Set getProvidedTokens() {
            return new HashSet<String>(Arrays.asList(this.mm.getProvidedTokens()));
        }

        public Set getRequiredTokens() {
            HashSet<String> s = new HashSet<String>(Arrays.asList(this.mm.getRequiredTokens()));
            Iterator it = s.iterator();
            while (it.hasNext()) {
                String tok = (String)it.next();
                if (!tok.startsWith("org.openide.modules.ModuleFormat") && !tok.startsWith("org.openide.modules.os.")) continue;
                it.remove();
            }
            return s;
        }
    }

    static interface UniverseModule {
        public String getCodeNameBase();

        public int getReleaseVersion();

        public SpecificationVersion getSpecificationVersion();

        public String getImplementationVersion();

        public Set getProvidedTokens();

        public Set getRequiredTokens();

        public Set getModuleDependencies();

        public String getCluster();

        public String getDisplayName();
    }

    private static final class EnabledProp
    extends PropertySupport.ReadWrite {
        private static final EnabledProp TEMPLATE = new EnabledProp(null);
        private Enabled node;
        private PropertyEditor editor;

        public EnabledProp(Enabled node) {
            super("enabled", Boolean.TYPE, SuiteCustomizerLibraries.getMessage("LBL_ModuleListEnabled"), SuiteCustomizerLibraries.getMessage("LBL_ModuleListEnabledShortDescription"));
            this.node = node;
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.node.setEnabled((Boolean)val);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            Children ch = this.node.getChildren();
            if (ch == Children.LEAF) {
                return this.node.isEnabled();
            }
            Node[] arr = ch.getNodes();
            boolean on = false;
            boolean off = false;
            for (int i = 0; i < arr.length; ++i) {
                Enabled n = (Enabled)arr[i];
                if (n.isEnabled()) {
                    on = true;
                } else {
                    off = true;
                }
                if (!on || !off || !this.node.isEnabled()) continue;
                return null;
            }
            return on && this.node.isEnabled();
        }

        public boolean canWrite() {
            Node parent = this.node.getParentNode();
            if (parent instanceof Enabled) {
                return ((Enabled)parent).isEnabled();
            }
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                this.editor = super.getPropertyEditor();
            }
            return this.editor;
        }
    }

    final class Enabled
    extends AbstractNode {
        private boolean enabled;
        private Children standard;

        public Enabled(Children ch, boolean enabled) {
            super(ch);
            this.standard = ch;
            this.enabled = enabled;
            Sheet s = Sheet.createDefault();
            Sheet.Set ss = s.get("properties");
            ss.put((Node.Property)new EnabledProp(this));
            this.setSheet(s);
        }

        public void setEnabled(boolean s) {
            if (s == this.enabled) {
                return;
            }
            this.enabled = s;
            Node[] all = this.standard.getNodes();
            for (int i = 0; i < all.length; ++i) {
                Node nn = all[i];
                if (!(nn instanceof Enabled)) continue;
                Enabled en = (Enabled)nn;
                en.firePropertyChange(null, null, null);
            }
            Node n = this.getParentNode();
            if (n instanceof Enabled) {
                Enabled en = (Enabled)n;
                en.firePropertyChange(null, null, null);
            }
            SuiteCustomizerLibraries.this.updateDependencyWarnings();
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

