/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public final class JavadocForBinaryImpl
implements JavadocForBinaryQueryImplementation {
    private static final String NB_ALL_INFIX = "nbbuild" + File.separatorChar + "build" + File.separatorChar + "javadoc" + File.separatorChar;
    private static final String EXT_INFIX = "build" + File.separatorChar + "javadoc" + File.separatorChar;
    static boolean ignoreNonexistentRoots = true;
    private final NbModuleProject project;

    public JavadocForBinaryImpl(NbModuleProject project) {
        this.project = project;
    }

    public JavadocForBinaryQuery.Result findJavadoc(URL binaryRoot) {
        if (!binaryRoot.equals(Util.urlForJar(this.project.getModuleJarLocation()))) {
            return null;
        }
        String cnbdashes = this.project.getCodeNameBase().replace('.', '-');
        try {
            final ArrayList<URL> candidates = new ArrayList<URL>();
            NbPlatform platform = this.project.getPlatform(false);
            if (platform == null) {
                return null;
            }
            URL[] roots = platform.getJavadocRoots();
            for (int i = 0; i < roots.length; ++i) {
                candidates.add(new URL(roots[i], cnbdashes + "/"));
            }
            NbModuleTypeProvider.NbModuleType type = Util.getModuleType(this.project);
            File dir = type == NbModuleTypeProvider.NETBEANS_ORG ? this.project.getNbrootFile(NB_ALL_INFIX + cnbdashes) : new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), EXT_INFIX + cnbdashes);
            candidates.add(Util.urlForDir(dir));
            if (ignoreNonexistentRoots) {
                Iterator it = candidates.iterator();
                while (it.hasNext()) {
                    URL u = (URL)it.next();
                    if (URLMapper.findFileObject((URL)u) != null) continue;
                    it.remove();
                }
            }
            return new JavadocForBinaryQuery.Result(){

                public URL[] getRoots() {
                    return candidates.toArray(new URL[candidates.size()]);
                }

                public void addChangeListener(ChangeListener l) {
                }

                public void removeChangeListener(ChangeListener l) {
                }
            };
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }
}

