/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.openide.awt.Actions;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

final class BadgingSupport
implements FileSystem.Status,
FileChangeListener {
    private String suffix = "";
    private ClassPath classpath;
    private final FileSystem fs;
    private final FileChangeListener fileChangeListener;
    private final List listeners = new ArrayList();

    public BadgingSupport(FileSystem fs) {
        this.fs = fs;
        this.fileChangeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);
        fs.addFileChangeListener(this.fileChangeListener);
    }

    public void setClasspath(ClassPath classpath) {
        this.classpath = classpath;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void addFileStatusListener(FileStatusListener l) {
        this.listeners.add(l);
    }

    public void removeFileStatusListener(FileStatusListener l) {
        this.listeners.remove(l);
    }

    private void fireFileStatusChanged(FileStatusEvent e) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((FileStatusListener)it.next()).annotationChanged(e);
        }
    }

    public String annotateName(String name, Set files) {
        return BadgingSupport.annotateNameGeneral(name, files, this.suffix, this.fileChangeListener, this.classpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static String annotateNameGeneral(String name, Set files, String suffix, FileChangeListener fileChangeListener, ClassPath cp) {
        Iterator it = files.iterator();
        while (it.hasNext()) {
            FileObject orig;
            Object originalFile;
            FileObject fo = (FileObject)it.next();
            String bundleName = (String)fo.getAttribute("SystemFileSystem.localizingBundle");
            if (bundleName != null) {
                try {
                    URL[] u = LayerUtils.currentify(new URL("nbresloc:/" + bundleName.replace('.', '/') + ".properties"), suffix, cp);
                    for (int i = 0; i < u.length; ++i) {
                        InputStream is = u[i].openStream();
                        try {
                            Properties p = new Properties();
                            p.load(is);
                            String key = fo.getPath();
                            String val = p.getProperty(key);
                            FileObject ufo = URLMapper.findFileObject((URL)u[i]);
                            if (ufo != null) {
                                ufo.removeFileChangeListener(fileChangeListener);
                                ufo.addFileChangeListener(fileChangeListener);
                                ufo.getParent().removeFileChangeListener(fileChangeListener);
                                ufo.getParent().addFileChangeListener(fileChangeListener);
                            }
                            if (val == null) continue;
                            if (fo.getPath().startsWith("Menu/")) {
                                String string = Actions.cutAmpersand((String)val);
                                return string;
                            }
                            String string = val;
                            return string;
                        }
                        finally {
                            is.close();
                        }
                    }
                }
                catch (IOException ioe) {
                    Util.err.notify(1, (Throwable)ioe);
                    return NbBundle.getMessage((Class)BadgingSupport.class, (String)"LBL_no_such_bundle", (Object)name, (Object)bundleName);
                }
            }
            if (fo.hasExt("instance")) {
                return BadgingSupport.getInstanceLabel(fo);
            }
            if (!fo.hasExt("shadow") || (originalFile = fo.getAttribute("originalFile")) == null || !(originalFile instanceof String)) continue;
            try {
                orig = fo.getFileSystem().findResource((String)originalFile);
            }
            catch (FileStateInvalidException e) {
                orig = null;
            }
            if (orig == null || !orig.hasExt("instance")) continue;
            return BadgingSupport.getInstanceLabel(orig);
        }
        return name;
    }

    private static String getInstanceLabel(FileObject fo) {
        String instanceCreate;
        try {
            InstanceCookie ic = (InstanceCookie)DataObject.find((FileObject)fo).getCookie(InstanceCookie.class);
            if (ic != null) {
                Object o = ic.instanceCreate();
                if (o instanceof Action) {
                    String name = (String)((Action)o).getValue("Name");
                    if (name != null) {
                        return Actions.cutAmpersand((String)name);
                    }
                    return BadgingSupport.toStringOf(o);
                }
                if (o instanceof Presenter.Menu) {
                    return ((Presenter.Menu)o).getMenuPresenter().getText();
                }
                if (o instanceof JSeparator) {
                    return NbBundle.getMessage((Class)BadgingSupport.class, (String)"LBL_separator");
                }
                return BadgingSupport.toStringOf(o);
            }
        }
        catch (IOException e) {
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        String clazz = (String)fo.getAttribute("instanceClass");
        if (clazz == null) {
            clazz = fo.getName().replace('-', '.');
        }
        if ((instanceCreate = (String)fo.getAttribute("literal:instanceCreate")) != null && instanceCreate.startsWith("new:")) {
            clazz = instanceCreate.substring("new:".length());
        } else if (instanceCreate != null && instanceCreate.startsWith("method:")) {
            String factoryDisplayLabel = instanceCreate.substring(instanceCreate.lastIndexOf(46, instanceCreate.lastIndexOf(46) - 1) + 1);
            return NbBundle.getMessage((Class)BadgingSupport.class, (String)"LBL_instance_from", (Object)factoryDisplayLabel);
        }
        String clazzDisplayLabel = clazz.substring(clazz.lastIndexOf(46) + 1);
        return NbBundle.getMessage((Class)BadgingSupport.class, (String)"LBL_instance_of", (Object)clazzDisplayLabel);
    }

    private static String toStringOf(Object o) {
        String s = o.toString();
        if ((o.getClass().getName() + "@" + Integer.toHexString(o.hashCode())).equals(s)) {
            String clazz = o.getClass().getName();
            String clazzDisplayLabel = clazz.substring(clazz.lastIndexOf(46) + 1);
            return NbBundle.getMessage((Class)BadgingSupport.class, (String)"LBL_instance_of", (Object)clazzDisplayLabel);
        }
        return s;
    }

    public Image annotateIcon(Image icon, int type, Set files) {
        return BadgingSupport.annotateIconGeneral(icon, type, files, this.suffix, this.fileChangeListener, this.classpath);
    }

    private static Image annotateIconGeneral(Image icon, int type, Set files, String suffix, FileChangeListener fileChangeListener, ClassPath cp) {
        String attr;
        if (type == 1) {
            attr = "SystemFileSystem.icon";
        } else if (type == 2) {
            attr = "SystemFileSystem.icon32";
        } else {
            return icon;
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            Object value = fo.getAttribute(attr);
            if (value instanceof Image) {
                return (Image)value;
            }
            if (value == null) continue;
            try {
                URL[] u = LayerUtils.currentify((URL)value, suffix, cp);
                FileObject ufo = URLMapper.findFileObject((URL)u[0]);
                if (ufo != null) {
                    ufo.removeFileChangeListener(fileChangeListener);
                    ufo.addFileChangeListener(fileChangeListener);
                }
                return Toolkit.getDefaultToolkit().getImage(u[0]);
            }
            catch (Exception e) {
                Util.err.notify(1, (Throwable)e);
            }
        }
        return icon;
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
        this.someFileChange(fe);
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        this.someFileChange((FileEvent)fe);
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.someFileChange((FileEvent)fe);
    }

    public void fileChanged(FileEvent fe) {
        this.someFileChange(fe);
    }

    private void someFileChange(FileEvent fe) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                BadgingSupport.this.fireFileStatusChanged(new FileStatusEvent(BadgingSupport.this.fs, true, true));
            }
        });
    }
}

