/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.xerces.util.XMLChar;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.wizards.TagHandlerPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TagInfoPanel
implements WizardDescriptor.Panel {
    private TagHandlerPanelGUI component;
    private transient TemplateWizard wizard;
    private transient Project proj;
    private transient SourceGroup[] sourceGroups;
    private String className;
    private final Set listeners = new HashSet(1);

    public TagInfoPanel(TemplateWizard wizard, Project proj, SourceGroup[] sourceGroups) {
        this.wizard = wizard;
        this.proj = proj;
        this.sourceGroups = sourceGroups;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new TagHandlerPanelGUI(this.wizard, this, this.proj, this.sourceGroups);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        if (this.writeToTLD() && this.getTLDFile() == null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TagInfoPanel.class, (String)"MSG_noTldSelected"));
            return false;
        }
        if (!this.isValidTagName(this.getTagName())) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TagInfoPanel.class, (String)"TXT_wrongTagName", (Object)this.getTagName()));
            return false;
        }
        if (this.tagNameExists(this.getTagName())) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TagInfoPanel.class, (String)"TXT_tagNameExists", (Object)this.getTagName()));
            return false;
        }
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        Boolean bodySupport;
        TemplateWizard w = (TemplateWizard)settings;
        String targetName = w.getTargetName();
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)w);
        Project project = Templates.getProject((WizardDescriptor)w);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        String packageName = null;
        for (int i = 0; i < groups.length && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder);
        }
        if (packageName == null) {
            packageName = "";
        }
        packageName = packageName.replace('/', '.');
        if (targetName != null) {
            this.className = packageName.length() > 0 ? packageName + "." + targetName : targetName;
            this.component.setClassName(this.className);
            if (this.component.getTagName().length() == 0) {
                this.component.setTagName(targetName);
            }
        }
        if ((bodySupport = (Boolean)w.getProperty("BODY_SUPPORT")) != null && bodySupport.booleanValue()) {
            this.component.setBodySupport(true);
        } else {
            this.component.setBodySupport(false);
        }
    }

    public void storeSettings(Object settings) {
    }

    public String getClassName() {
        return this.className;
    }

    public String getTagName() {
        return this.component.getTagName();
    }

    public FileObject getTLDFile() {
        return this.component.getTLDFile();
    }

    public boolean isEmpty() {
        return this.component.isEmpty();
    }

    public boolean isScriptless() {
        return this.component.isScriptless();
    }

    public boolean isTegdependent() {
        return this.component.isTegdependent();
    }

    public boolean writeToTLD() {
        return this.component.writeToTLD();
    }

    public Object[][] getAttributes() {
        return this.component.getAttributes();
    }

    private boolean isValidTagName(String name) {
        return XMLChar.isValidNCName((String)name);
    }

    private boolean tagNameExists(String name) {
        Set tagValues = this.component.getTagValues();
        return tagValues != null && tagValues.contains(name);
    }
}

