/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.Evaluator;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.FinishableProxyWizardPanel;
import org.netbeans.modules.web.wizards.ServletData;
import org.netbeans.modules.web.wizards.ServletPanel;
import org.netbeans.modules.web.wizards.TargetEvaluator;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.modules.web.wizards.WrapperSelection;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class ServletIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = -4147344271705652643L;
    private static final boolean debug = false;
    private transient FileType fileType;
    private transient Evaluator evaluator = null;
    private transient DeployData deployData = null;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wizard;
    private transient ServletPanel servletPanel;
    private transient WizardDescriptor.Panel customPanel;

    private ServletIterator(FileType fileType) {
        this.fileType = fileType;
    }

    public static ServletIterator createServletIterator() {
        return new ServletIterator(FileType.SERVLET);
    }

    public static ServletIterator createFilterIterator() {
        return new ServletIterator(FileType.FILTER);
    }

    public void initialize(TemplateWizard wizard) {
        this.wizard = wizard;
        this.index = 0;
        if (this.fileType.equals(FileType.SERVLET) || this.fileType.equals(FileType.FILTER)) {
            this.deployData = new ServletData(this.fileType);
            this.evaluator = new TargetEvaluator(this.fileType, this.deployData);
        }
        Project project = Templates.getProject((WizardDescriptor)wizard);
        DataFolder targetFolder = null;
        try {
            targetFolder = wizard.getTargetFolder();
        }
        catch (IOException ex) {
            targetFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        }
        this.evaluator.setInitialFolder(targetFolder, project);
        if (this.fileType == FileType.SERVLET) {
            this.panels = new WizardDescriptor.Panel[]{new FinishableProxyWizardPanel(this.createPackageChooserPanel(wizard, null)), ServletPanel.createServletPanel((TargetEvaluator)this.evaluator, wizard)};
        } else if (this.fileType == FileType.FILTER) {
            this.customPanel = new WrapperSelection(wizard);
            WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[3];
            panelArray[0] = this.createPackageChooserPanel(wizard, this.customPanel);
            this.servletPanel = ServletPanel.createServletPanel((TargetEvaluator)this.evaluator, wizard);
            panelArray[1] = this.servletPanel;
            panelArray[2] = ServletPanel.createFilterPanel((TargetEvaluator)this.evaluator, wizard);
            this.panels = panelArray;
        }
        Object prop = wizard.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = Utilities.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jc = (JComponent)this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = jc.getName();
            }
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    private WizardDescriptor.Panel createPackageChooserPanel(TemplateWizard wizard, WizardDescriptor.Panel customPanel) {
        Project project = Templates.getProject((WizardDescriptor)wizard);
        SourceGroup[] sourceGroups = Util.getJavaSourceGroups(project);
        if (customPanel == null) {
            if (sourceGroups.length == 0) {
                return Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups);
            }
            return JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups);
        }
        if (sourceGroups.length == 0) {
            return Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)customPanel);
        }
        return JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)customPanel);
    }

    public Set instantiate(TemplateWizard wizard) throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)wizard);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)wizard);
        if (FileType.FILTER.equals(this.fileType) && ((WrapperSelection)this.customPanel).isWrapper()) {
            template = Templates.getTemplate((WizardDescriptor)wizard);
            FileObject templateParent = template.getParent();
            template = templateParent.getFileObject("AdvancedFilter", "java");
        }
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, Templates.getTargetName((WizardDescriptor)wizard));
        if (!this.deployData.makeEntry()) {
            return Collections.singleton(dobj);
        }
        TargetEvaluator te = (TargetEvaluator)this.evaluator;
        if (this.deployData.getClassName().length() == 0) {
            String targetName = wizard.getTargetName();
            FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
            String packageName = null;
            Project project = Templates.getProject((WizardDescriptor)wizard);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] groups = sources.getSourceGroups("java");
            for (int i = 0; i < groups.length && packageName == null; ++i) {
                if (WebModule.getWebModule((FileObject)groups[i].getRootFolder()) == null) continue;
                packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder);
            }
            packageName = packageName != null ? packageName.replace('/', '.') : "";
            this.deployData.setClassName(packageName.length() == 0 ? targetName : packageName + "." + targetName);
            String servletName = ((ServletData)this.deployData).createDDServletName(targetName);
            ((ServletData)this.deployData).createDDServletMapping(servletName);
        }
        this.deployData.createDDEntries();
        return Collections.singleton(dobj);
    }

    private void log(String s) {
        System.out.println("ServletIterator" + s);
    }

    public void uninitialize(TemplateWizard wizard) {
        this.wizard = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(ServletIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1 && this.deployData.hasDD() && this.deployData.isAddToDD();
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

