/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.JFrame;
import javax.swing.plaf.basic.BasicHTML;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.AbstractModeContainer;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.tabcontrol.TabbedAdapter;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public final class DefaultSeparateContainer
extends AbstractModeContainer {
    private final JFrame frame;

    public DefaultSeparateContainer(final ModeView modeView, WindowDnDManager windowDnDManager, Rectangle bounds) {
        super(modeView, windowDnDManager);
        this.frame = new ModeFrame(this, modeView);
        this.frame.getContentPane().add(this.tabbedHandler.getComponent());
        this.frame.setBounds(bounds);
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                if (DefaultSeparateContainer.this.frame.getExtendedState() == 6) {
                    return;
                }
                modeView.getController().userResizedModeBounds(modeView, DefaultSeparateContainer.this.frame.getBounds());
            }

            public void componentMoved(ComponentEvent evt) {
                if (DefaultSeparateContainer.this.frame.getExtendedState() == 6) {
                    return;
                }
                modeView.getController().userResizedModeBounds(modeView, DefaultSeparateContainer.this.frame.getBounds());
            }
        });
        this.frame.addWindowStateListener(new WindowStateListener(){

            public void windowStateChanged(WindowEvent evt) {
                Component comp = modeView.getComponent();
                if (comp instanceof Frame) {
                    long currentStamp = System.currentTimeMillis();
                    if (currentStamp > modeView.getUserStamp() + 500L && currentStamp > modeView.getMainWindowStamp() + 1000L) {
                        modeView.getController().userChangedFrameStateMode(modeView, evt.getNewState());
                    } else {
                        modeView.setUserStamp(0L);
                        modeView.setMainWindowStamp(0L);
                        modeView.updateFrameState();
                    }
                    long stamp = System.currentTimeMillis();
                    modeView.setUserStamp(stamp);
                }
            }
        });
    }

    public void requestAttention(TopComponent tc) {
    }

    public void cancelRequestAttention(TopComponent tc) {
    }

    protected Component getModeComponent() {
        return this.frame;
    }

    protected Tabbed createTabbed() {
        TabbedAdapter tabbed = this.getKind() == 1 ? new TabbedAdapter(1) : new TabbedAdapter(0);
        return tabbed;
    }

    protected void updateTitle(String title) {
        if (BasicHTML.isHTMLString(title)) {
            char[] c = title.toCharArray();
            StringBuffer sb = new StringBuffer(title.length());
            boolean inTag = false;
            boolean inEntity = false;
            for (int i = 0; i < c.length; ++i) {
                if (inTag && c[i] == '>') {
                    inTag = false;
                    continue;
                }
                if (!inTag && c[i] == '<') {
                    inTag = true;
                    continue;
                }
                if (inTag) continue;
                sb.append(c[i]);
            }
            title = Utilities.replaceString((String)sb.toString(), (String)"&nbsp;", (String)" ");
        }
        this.frame.setTitle(title);
    }

    protected void updateActive(boolean active) {
        if (active && this.frame.isVisible() && !this.frame.isActive()) {
            this.frame.toFront();
        }
    }

    public boolean isActive() {
        return this.frame.isActive();
    }

    protected boolean isAttachingPossible() {
        return false;
    }

    protected TopComponentDroppable getModeDroppable() {
        return (ModeFrame)this.frame;
    }

    private static class ModeFrame
    extends JFrame
    implements ModeComponent,
    TopComponentDroppable {
        private final AbstractModeContainer abstractModeContainer;
        private final ModeView modeView;
        private long frametimestamp = 0L;

        public ModeFrame(AbstractModeContainer abstractModeContainer, ModeView view) {
            super("");
            this.abstractModeContainer = abstractModeContainer;
            this.modeView = view;
            this.enableEvents(16L);
            this.setIconImage(MainWindow.createIDEImage());
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    ModeFrame.this.modeView.getController().userClosingMode(ModeFrame.this.modeView);
                }

                public void windowActivated(WindowEvent event) {
                    if (ModeFrame.this.frametimestamp != 0L && System.currentTimeMillis() > ModeFrame.this.frametimestamp + 500L) {
                        ModeFrame.this.modeView.getController().userActivatedModeWindow(ModeFrame.this.modeView);
                    }
                    ModeFrame.this.frametimestamp = System.currentTimeMillis();
                }

                public void windowOpened(WindowEvent event) {
                    ModeFrame.this.frametimestamp = System.currentTimeMillis();
                }
            });
        }

        public void setVisible(boolean visible) {
            this.frametimestamp = System.currentTimeMillis();
            super.setVisible(visible);
        }

        public void toFront() {
            this.frametimestamp = System.currentTimeMillis();
            super.toFront();
        }

        public ModeView getModeView() {
            return this.abstractModeContainer.getModeView();
        }

        public int getKind() {
            return this.abstractModeContainer.getKind();
        }

        public Shape getIndicationForLocation(Point location) {
            return this.abstractModeContainer.getIndicationForLocation(location);
        }

        public Object getConstraintForLocation(Point location) {
            return this.abstractModeContainer.getConstraintForLocation(location);
        }

        public Component getDropComponent() {
            return this.abstractModeContainer.getDropComponent();
        }

        public ViewElement getDropViewElement() {
            return this.abstractModeContainer.getDropModeView();
        }

        public boolean canDrop(TopComponent transfer, Point location) {
            return this.abstractModeContainer.canDrop(transfer);
        }

        public boolean supportsKind(int kind, TopComponent transfer) {
            if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(transfer)) {
                return true;
            }
            return kind == 0 || kind == 2;
        }
    }
}

