/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.persistence;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.persistence.GroupConfig;
import org.netbeans.core.windows.persistence.ModeConfig;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.TCGroupConfig;
import org.netbeans.core.windows.persistence.TCRefConfig;
import org.netbeans.core.windows.persistence.WindowManagerParser;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;

class ModuleChangeHandler
implements FileChangeListener {
    private static final boolean DEBUG = Debug.isLoggable(ModuleChangeHandler.class);
    private boolean started = false;
    private FileSystem fs = null;
    private FileObject modesModuleFolder;
    private FileObject groupsModuleFolder;
    private FileObject componentsModuleFolder;
    private List tcRefsWaitingOnSettings;

    void startHandling() {
        if (this.started) {
            return;
        }
        PersistenceManager pm = PersistenceManager.getDefault();
        this.modesModuleFolder = pm.getModesModuleFolder();
        this.groupsModuleFolder = pm.getGroupsModuleFolder();
        this.componentsModuleFolder = pm.getComponentsModuleFolder();
        try {
            this.fs = this.modesModuleFolder.getFileSystem();
        }
        catch (FileStateInvalidException exc) {
            ErrorManager em = ErrorManager.getDefault();
            em.log(16, "[WinSys.ModuleChangeHandler.startHandling] Cannot get filesystem.");
            em.notify(1, (Throwable)exc);
            return;
        }
        this.fs.addFileChangeListener((FileChangeListener)this);
        this.started = true;
    }

    void stopHandling() {
        if (!this.started) {
            return;
        }
        this.fs.removeFileChangeListener((FileChangeListener)this);
        this.fs = null;
        this.started = false;
    }

    private boolean acceptEvent(FileObject fo) {
        FileObject parent = fo.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.getPath().equals(this.modesModuleFolder.getPath())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ MODE ++");
            }
            return true;
        }
        if (parent.getPath().equals(this.groupsModuleFolder.getPath())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ GROUP ++");
            }
            return true;
        }
        if (parent.getPath().equals(this.componentsModuleFolder.getPath())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ COMPONENT ++");
            }
            return true;
        }
        if ((parent = parent.getParent()) == null) {
            return false;
        }
        if (parent.getPath().equals(this.modesModuleFolder.getPath())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ tcRef ++");
            }
            return true;
        }
        if (parent.getPath().equals(this.groupsModuleFolder.getPath())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ tcGroup ++");
            }
            return true;
        }
        return false;
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
        FileObject fo = fe.getFile();
        boolean accepted = this.acceptEvent(fo);
        if (!accepted) {
            return;
        }
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "-- fileDataCreated fo: " + fo + " isFolder:" + fo.isFolder() + " ACCEPTED" + " th:" + Thread.currentThread().getName());
            if (accepted && fo.isFolder()) {
                FileObject[] files = fo.getChildren();
                for (int i = 0; i < files.length; ++i) {
                    System.err.println("fo[" + i + "]: " + files[i]);
                }
            }
        }
        this.processDataOrFolderCreated(fo);
    }

    public void fileFolderCreated(FileEvent fe) {
        FileObject fo = fe.getFile();
        boolean accepted = this.acceptEvent(fo);
        if (!accepted) {
            return;
        }
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "-- fileFolderCreated fo: " + fo + " isFolder:" + fo.isFolder() + " ACCEPTED" + " th:" + Thread.currentThread().getName());
            if (accepted && fo.isFolder()) {
                FileObject[] files = fo.getChildren();
                for (int i = 0; i < files.length; ++i) {
                    Debug.log(class$org$netbeans$core$windows$persistence$ModuleChangeHandler == null ? ModuleChangeHandler.class$("org.netbeans.core.windows.persistence.ModuleChangeHandler") : class$org$netbeans$core$windows$persistence$ModuleChangeHandler, "fo[" + i + "]: " + files[i]);
                }
            }
        }
        this.processDataOrFolderCreated(fo);
    }

    private void processDataOrFolderCreated(FileObject fo) {
        FileObject parent2;
        FileObject parent1 = fo.getParent();
        if (parent1.getPath().equals(this.modesModuleFolder.getPath())) {
            if (!fo.isFolder() && "wsmode".equals(fo.getExt())) {
                if (DEBUG) {
                    Debug.log(ModuleChangeHandler.class, "++ process MODE ADD ++");
                }
                this.addMode(fo.getName());
            }
        } else if (parent1.getPath().equals(this.groupsModuleFolder.getPath())) {
            if (!fo.isFolder() && "wsgrp".equals(fo.getExt())) {
                if (DEBUG) {
                    Debug.log(ModuleChangeHandler.class, "++ process GROUP ADD ++");
                }
                this.addGroup(fo.getName());
            }
        } else if (parent1.getPath().equals(this.componentsModuleFolder.getPath()) && !fo.isFolder() && "settings".equals(fo.getExt())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ process COMPONENT ADD ++");
            }
            this.addComponent(fo);
        }
        if ((parent2 = parent1.getParent()).getPath().equals(this.modesModuleFolder.getPath())) {
            if (!fo.isFolder() && "wstcref".equals(fo.getExt())) {
                if (DEBUG) {
                    Debug.log(ModuleChangeHandler.class, "++ process tcRef ADD ++");
                }
                this.processTCRef(parent1.getName(), fo);
            }
        } else if (parent2.getPath().equals(this.groupsModuleFolder.getPath()) && !fo.isFolder() && "wstcgrp".equals(fo.getExt())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ process tcGroup ADD ++");
            }
            this.addTCGroup(parent1.getName(), fo.getName());
        }
    }

    public void fileDeleted(FileEvent fe) {
        FileObject parent2;
        FileObject parent1;
        FileObject fo = fe.getFile();
        boolean accepted = this.acceptEvent(fo);
        if (!accepted) {
            return;
        }
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "-- fileDeleted fo: " + fo + " isFolder:" + fo.isFolder() + " isValid:" + fo.isValid() + " ACCEPTED" + " th:" + Thread.currentThread().getName());
        }
        if ((parent1 = fo.getParent()).getPath().equals(this.modesModuleFolder.getPath())) {
            if (!fo.isFolder() && "wsmode".equals(fo.getExt())) {
                if (DEBUG) {
                    Debug.log(ModuleChangeHandler.class, "++ process MODE REMOVE ++");
                }
                this.removeMode(fo.getName());
            }
        } else if (parent1.getPath().equals(this.groupsModuleFolder.getPath()) && !fo.isFolder() && "wsgrp".equals(fo.getExt())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ process GROUP REMOVE ++");
            }
            this.removeGroup(fo.getName());
        }
        if ((parent2 = parent1.getParent()).getPath().equals(this.modesModuleFolder.getPath())) {
            if (!fo.isFolder() && "wstcref".equals(fo.getExt())) {
                if (DEBUG) {
                    Debug.log(ModuleChangeHandler.class, "++ process tcRef REMOVE ++");
                }
                this.removeTCRef(fo.getName());
            }
        } else if (parent2.getPath().equals(this.groupsModuleFolder.getPath()) && !fo.isFolder() && "wstcgrp".equals(fo.getExt())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ process tcGroup REMOVE ++");
            }
            this.removeTCGroup(parent1.getName(), fo.getName());
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
    }

    private void addMode(String modeName) {
        WindowManagerParser wmParser;
        ModeConfig modeConfig;
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "addMode mo:" + modeName);
        }
        if ((modeConfig = (wmParser = PersistenceManager.getDefault().getWindowManagerParser()).addMode(modeName)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManagerImpl.getInstance().getPersistenceObserver().modeConfigAdded(modeConfig);
                }
            });
        }
    }

    private void addGroup(String groupName) {
        WindowManagerParser wmParser;
        GroupConfig groupConfig;
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "addGroup group:" + groupName);
        }
        if ((groupConfig = (wmParser = PersistenceManager.getDefault().getWindowManagerParser()).addGroup(groupName)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManagerImpl.getInstance().getPersistenceObserver().groupConfigAdded(groupConfig);
                }
            });
        }
    }

    private void processTCRef(String modeName, FileObject tcRefFO) {
        FileObject localSettings = PersistenceManager.getDefault().getComponentsLocalFolder().getFileObject(tcRefFO.getName(), "settings");
        if (localSettings != null) {
            this.addTCRef(modeName, tcRefFO.getName());
        } else {
            if (this.tcRefsWaitingOnSettings == null) {
                this.tcRefsWaitingOnSettings = new ArrayList(5);
            }
            this.tcRefsWaitingOnSettings.add(tcRefFO);
        }
    }

    private void addTCRef(final String modeName, String tcRefName) {
        ArrayList tcRefNameList;
        WindowManagerParser wmParser;
        TCRefConfig tcRefConfig;
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "addTCRef modeName:" + modeName + " tcRefName:" + tcRefName);
        }
        if ((tcRefConfig = (wmParser = PersistenceManager.getDefault().getWindowManagerParser()).addTCRef(modeName, tcRefName, tcRefNameList = new ArrayList(10))) != null) {
            final String[] tcRefNameArray = tcRefNameList.toArray(new String[tcRefNameList.size()]);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManagerImpl.getInstance().getPersistenceObserver().topComponentRefConfigAdded(modeName, tcRefConfig, tcRefNameArray);
                }
            });
        }
    }

    private void addTCGroup(final String groupName, String tcGroupName) {
        WindowManagerParser wmParser;
        TCGroupConfig tcGroupConfig;
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "addTCGroup groupName:" + groupName + " tcGroupName:" + tcGroupName);
        }
        if ((tcGroupConfig = (wmParser = PersistenceManager.getDefault().getWindowManagerParser()).addTCGroup(groupName, tcGroupName)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManagerImpl.getInstance().getPersistenceObserver().topComponentGroupConfigAdded(groupName, tcGroupConfig);
                }
            });
        }
    }

    private void addComponent(FileObject fo) {
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "addComponent settingsName:" + fo.getNameExt());
        }
        PersistenceManager.getDefault().copySettingsFileIfNeeded(fo);
        FileObject waitingTcRef = this.findWaitingTcRef(fo);
        if (waitingTcRef != null) {
            this.tcRefsWaitingOnSettings.remove(waitingTcRef);
            this.addTCRef(waitingTcRef.getParent().getName(), waitingTcRef.getName());
        }
    }

    private FileObject findWaitingTcRef(FileObject settingsFo) {
        if (this.tcRefsWaitingOnSettings == null) {
            return null;
        }
        String settingsName = settingsFo.getName();
        Iterator iter = this.tcRefsWaitingOnSettings.iterator();
        while (iter.hasNext()) {
            FileObject curTcRef = (FileObject)iter.next();
            if (!settingsName.equals(curTcRef.getName())) continue;
            return curTcRef;
        }
        return null;
    }

    private void removeMode(String modeName) {
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "removeMode mo:" + modeName);
        }
        WindowManagerParser wmParser = PersistenceManager.getDefault().getWindowManagerParser();
        wmParser.removeMode(modeName);
    }

    private void removeGroup(final String groupName) {
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "removeGroup group:" + groupName);
        }
        WindowManagerParser wmParser = PersistenceManager.getDefault().getWindowManagerParser();
        wmParser.removeGroup(groupName);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WindowManagerImpl.getInstance().getPersistenceObserver().groupConfigRemoved(groupName);
            }
        });
    }

    private void removeTCRef(final String tcRefName) {
        WindowManagerParser wmParser;
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "removeTCRef tcRefName:" + tcRefName);
        }
        if ((wmParser = PersistenceManager.getDefault().getWindowManagerParser()).removeTCRef(tcRefName)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManagerImpl.getInstance().getPersistenceObserver().topComponentRefConfigRemoved(tcRefName);
                }
            });
        }
    }

    private void removeTCGroup(final String groupName, final String tcGroupName) {
        WindowManagerParser wmParser;
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "removeTCGroup groupName:" + groupName + " tcGroupName:" + tcGroupName);
        }
        if ((wmParser = PersistenceManager.getDefault().getWindowManagerParser()).removeTCGroup(groupName, tcGroupName)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManagerImpl.getInstance().getPersistenceObserver().topComponentGroupConfigRemoved(groupName, tcGroupName);
                }
            });
        }
    }

    private void log(String s) {
        Debug.log(ModuleChangeHandler.class, s);
    }
}

