/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponentHandler;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.websvc.api.registry.WebServicesRegistryView;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.core.WebServiceReference;
import org.netbeans.modules.websvc.core.WebServiceTransferable;
import org.netbeans.modules.websvc.core.webservices.action.AddOperationAction;
import org.netbeans.modules.websvc.core.webservices.action.ConfigureHandlerAction;
import org.netbeans.modules.websvc.core.webservices.action.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.core.webservices.action.JaxRpcWsdlCookie;
import org.netbeans.modules.websvc.core.webservices.action.RegenerateFromWsdlAction;
import org.netbeans.modules.websvc.core.webservices.action.RegenerateFromWsdlCookie;
import org.netbeans.modules.websvc.core.webservices.action.WSRegisterCookie;
import org.netbeans.modules.websvc.core.webservices.ui.DeleteWsDialog;
import org.netbeans.modules.websvc.core.webservices.ui.WebServiceChildren;
import org.netbeans.modules.websvc.core.webservices.ui.panels.EnterWSDLUrlPanel;
import org.netbeans.modules.websvc.core.webservices.ui.panels.MessageHandlerPanel;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookie;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookieImpl;
import org.netbeans.modules.websvc.core.wseditor.support.WSEditAttributesAction;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

public class WebServiceNode
extends AbstractNode
implements WSRegisterCookie,
JaxRpcWsdlCookie,
ConfigureHandlerCookie,
OpenCookie,
RegenerateFromWsdlCookie {
    Webservices webServices;
    WebserviceDescription webServiceDescription;
    FileObject srcRoot;
    WebServicesSupport wsSupport;
    String wsName;
    Project project;

    public WebServiceNode(Webservices webServices, WebserviceDescription webServiceDescription, FileObject srcRoot) {
        this(new InstanceContent(), webServices, webServiceDescription, srcRoot);
    }

    private WebServiceNode(InstanceContent content, Webservices webServices, WebserviceDescription webServiceDescription, FileObject srcRoot) {
        super((Children)new WebServiceChildren(webServiceDescription, srcRoot), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.webServices = webServices;
        this.webServiceDescription = webServiceDescription;
        this.srcRoot = srcRoot;
        this.wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)srcRoot);
        this.project = FileOwnerQuery.getOwner((FileObject)srcRoot);
        this.wsName = webServiceDescription.getWebserviceDescriptionName();
        this.setDisplayName(this.wsName);
        this.setName(this.wsName);
        content.add((Object)this);
        this.addImplClassToContent(content, webServiceDescription);
    }

    public Image getIcon(int type) {
        return Utilities.loadImage((String)"org/netbeans/modules/websvc/core/webservices/ui/resources/XMLServiceDataIcon.gif");
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public void open() {
        OpenCookie oc = this.getOpenCookie();
        if (oc != null) {
            oc.open();
        }
    }

    public WebServicesSupport getWebServicesSupport() {
        return this.wsSupport;
    }

    private OpenCookie getOpenCookie() {
        FileObject f;
        OpenCookie oc = null;
        JavaClass ce = this.getImplBeanClass(this.webServiceDescription);
        if (ce != null && (f = JavaModel.getFileObject((Resource)ce.getResource())) != null) {
            try {
                DataObject d = DataObject.find((FileObject)f);
                oc = (OpenCookie)d.getCookie(OpenCookie.class);
            }
            catch (DataObjectNotFoundException de) {
                ErrorManager.getDefault().log(1, de.toString());
            }
        }
        return oc;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Node.Cookie getCookie(Class type) {
        if (type == EditWSAttributesCookie.class) {
            return new EditWSAttributesCookieImpl((Node)this, null);
        }
        return super.getCookie(type);
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(OpenAction.class), null, SystemAction.get(AddOperationAction.class), null, SystemAction.get(RegenerateFromWsdlAction.class), null, SystemAction.get(ConfigureHandlerAction.class), null, SystemAction.get(WSEditAttributesAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFile(FileObject f) {
        FileLock lock = null;
        try {
            DataFolder folder;
            lock = f.lock();
            if (f.isFolder() && (folder = DataFolder.findFolder((FileObject)f)) != null) {
                DataObject[] children = folder.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    SaveCookie save = (SaveCookie)children[i].getCookie(SaveCookie.class);
                    if (save == null) continue;
                    save.save();
                }
            }
            f.delete(lock);
        }
        catch (IOException e) {
            NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"MSG_Unable_Delete_File", (Object)f.getNameExt()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    private void deleteConfigFile() {
        String configFileName;
        ClassPathProvider cpp = (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
        assert (cpp != null);
        ClassPath classPath = cpp.findClassPath(this.srcRoot, "classpath/source");
        FileObject configFO = classPath.findResource(configFileName = this.getPackageName() + "/" + this.wsName + "-config" + ".xml");
        if (configFO != null) {
            this.deleteFile(configFO);
        }
    }

    private void deleteDDFile() {
        FileObject wsdd = this.wsSupport.getWebservicesDD();
        if (wsdd != null) {
            this.deleteFile(wsdd);
        }
    }

    public void destroy() throws IOException {
        super.destroy();
        String wsdlName = this.getWsdlName();
        FileObject wsdlFile = this.getWsdlFile(wsdlName);
        FileObject mappingFile = this.getMappingFile(wsdlName);
        String packageName = this.getPackageName();
        String deleteOptions = DeleteWsDialog.open(this.getDisplayName(), packageName.replace('/', '.'), wsdlFile == null ? null : wsdlName);
        if (!deleteOptions.equals("deleteNothing")) {
            FileObject wsPackage;
            boolean deletePackage = false;
            boolean deleteWsdl = false;
            if (deleteOptions.equals("deleteALL")) {
                deletePackage = true;
                deleteWsdl = true;
            } else if (deleteOptions.equals("deletePackage")) {
                deletePackage = true;
            } else if (deleteOptions.equals("deleteWsdl")) {
                deleteWsdl = true;
            }
            this.deleteConfigFile();
            this.webServices.removeWebserviceDescription(this.webServiceDescription);
            this.webServices.write(this.wsSupport.getWebservicesDD());
            if (this.webServices.sizeWebserviceDescription() == 0) {
                this.deleteDDFile();
            }
            this.wsSupport.removeServiceEntry(this.getLinkName());
            this.wsSupport.removeProjectEntries(this.wsName);
            if (deletePackage && (wsPackage = this.srcRoot.getFileObject(packageName)) != null) {
                this.deleteFile(wsPackage);
                for (FileObject parent = wsPackage.getParent(); parent != this.srcRoot && parent.getChildren().length == 0; parent = parent.getParent()) {
                    FileObject fileToDelete = parent;
                    this.deleteFile(fileToDelete);
                }
            }
            if (deleteWsdl) {
                if (wsdlFile != null) {
                    this.deleteFile(wsdlFile);
                }
                if (mappingFile != null) {
                    this.deleteFile(mappingFile);
                }
            }
        }
    }

    private String getLinkName() {
        PortComponent portComponent = this.webServiceDescription.getPortComponent(0);
        ServiceImplBean serviceImplBean = portComponent.getServiceImplBean();
        String link = serviceImplBean.getServletLink();
        if (link == null) {
            link = serviceImplBean.getEjbLink();
        }
        return link;
    }

    private String getPackageName() {
        String implClassName = this.getImplBeanClass(this.webServiceDescription).getName();
        int index = implClassName.lastIndexOf(".");
        return implClassName.substring(0, index).replace('.', '/');
    }

    private JavaClass getImplBeanClass(WebserviceDescription webServiceDescription) {
        WebServicesSupport wsSupport;
        String implBean;
        PortComponent portComponent = webServiceDescription.getPortComponent(0);
        ServiceImplBean serviceImplBean = portComponent.getServiceImplBean();
        String link = serviceImplBean.getServletLink();
        if (link == null) {
            link = serviceImplBean.getEjbLink();
        }
        if ((implBean = (wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)this.srcRoot)).getImplementationBean(link)) != null) {
            JavaClass javaClass = JMIUtils.findClass((String)implBean, (FileObject)this.srcRoot);
            return javaClass;
        }
        return null;
    }

    private void addImplClassToContent(final InstanceContent content, final WebserviceDescription webServiceDescription) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                JavaMetamodel.getManager().waitScanFinished();
                JavaClass implBeanClass = WebServiceNode.this.getImplBeanClass(webServiceDescription);
                if (implBeanClass != null) {
                    content.add((Object)implBeanClass);
                }
            }
        });
    }

    private String getDefaultWSDLUrl() {
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        InstanceProperties instanceProperties = provider.getInstanceProperties();
        String portNumber = instanceProperties.getProperty("httpportnumber");
        if (portNumber == null || portNumber.equals("")) {
            portNumber = "8080";
        }
        String contextRoot = "webservice";
        Object moduleType = provider.getJ2eeModule().getModuleType();
        String wsURI = this.wsName;
        if (J2eeModule.WAR.equals(moduleType)) {
            FileObject webXmlFo;
            J2eeModuleProvider.ConfigSupport configSupport = provider.getConfigSupport();
            WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)this.srcRoot);
            FileObject ddFolder = wsSupport.getWsDDFolder();
            if (ddFolder != null && (webXmlFo = ddFolder.getFileObject("web.xml")) != null && (wsURI = this.findUriForWS(webXmlFo, this.wsName)).startsWith("/")) {
                wsURI = wsURI.substring(1);
            }
            if ((contextRoot = configSupport.getWebContextRoot()) != null && contextRoot.startsWith("/")) {
                contextRoot = contextRoot.substring(1);
            }
        } else if (J2eeModule.EJB.equals(moduleType)) {
            contextRoot = "webservice";
        }
        return "http://localhost:" + portNumber + "/" + (contextRoot != null && !contextRoot.equals("") ? contextRoot + "/" : "") + wsURI + "?WSDL";
    }

    private String findUriForWS(FileObject webXmlFo, String wsName) {
        try {
            WebApp webApp = DDProvider.getDefault().getDDRoot(webXmlFo);
            if (webApp != null) {
                ServletMapping[] maps = webApp.getServletMapping();
                String servletName = "WSServlet_" + wsName;
                for (int i = 0; i < maps.length; ++i) {
                    if (!servletName.equals(maps[i].getServletName())) continue;
                    return maps[i].getUrlPattern();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return wsName;
    }

    private String getWsdlName() {
        int ind;
        String wsdlFile = this.webServiceDescription.getWsdlFile();
        if (wsdlFile != null && (ind = wsdlFile.lastIndexOf("/")) >= 0) {
            return wsdlFile.substring(ind + 1);
        }
        return wsdlFile;
    }

    private FileObject getWsdlFile(String wsdlName) {
        WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)this.srcRoot);
        FileObject wsdlFolder = wsSupport.getWsDDFolder().getFileObject("wsdl");
        FileObject wsdlFO = null;
        if (wsdlFolder != null && wsdlName != null) {
            wsdlFO = wsdlFolder.getFileObject(wsdlName);
        }
        return wsdlFO;
    }

    private FileObject getMappingFile(String wsdlName) {
        WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)this.srcRoot);
        FileObject ddFolder = wsSupport.getWsDDFolder();
        FileObject mappingFO = null;
        if (ddFolder != null && wsdlName != null) {
            String wsdlShortName = wsdlName;
            if (wsdlName.endsWith(".wsdl")) {
                wsdlShortName = wsdlName.substring(0, wsdlName.length() - 5);
            }
            mappingFO = ddFolder.getFileObject(wsdlShortName + "-mapping.xml");
        }
        return mappingFO;
    }

    public void registerWebService() {
        final EnterWSDLUrlPanel panel = new EnterWSDLUrlPanel(this.getDefaultWSDLUrl());
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, NbBundle.getMessage(WebServiceNode.class, (String)"Enter_WSDL_Url"), true, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == NotifyDescriptor.OK_OPTION) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            URL url = null;
                            try {
                                url = new URL(panel.getSelectedWSDLUrl());
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e.getMessage());
                            }
                            WebServicesRegistryView registryView = (WebServicesRegistryView)Lookup.getDefault().lookup(WebServicesRegistryView.class);
                            TopComponent currentComponent = TopComponent.getRegistry().getActivated();
                            currentComponent.setCursor(Utilities.createProgressCursor((Component)currentComponent));
                            try {
                                boolean success = registryView.registerService(url, true);
                                if (!success) {
                                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebServiceNode.class, (String)"MSG_UNABLE_TO_REGISTER_WS"), 0);
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                                }
                            }
                            finally {
                                currentComponent.setCursor(null);
                            }
                        }
                    });
                }
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebServiceNode.class, (String)"Enter_WSDL_Url_Desc"));
        dialog.setVisible(true);
    }

    private boolean isNewHandler(String className, PortComponent portComponent) {
        PortComponentHandler[] handlers = portComponent.getHandler();
        for (int i = 0; i < handlers.length; ++i) {
            if (!handlers[i].getHandlerClass().equals(className)) continue;
            return false;
        }
        return true;
    }

    private boolean isInModel(String className, ListModel model) {
        for (int i = 0; i < model.getSize(); ++i) {
            String cls = (String)model.getElementAt(i);
            if (!className.equals(cls)) continue;
            return true;
        }
        return false;
    }

    public void configureHandler() {
        final PortComponent portComponent = this.webServiceDescription.getPortComponent(0);
        PortComponentHandler[] handlers = portComponent.getHandler();
        ArrayList<String> handlerList = new ArrayList<String>();
        for (int j = 0; j < handlers.length; ++j) {
            handlerList.add(handlers[j].getHandlerClass());
        }
        final MessageHandlerPanel panel = new MessageHandlerPanel(this.project, handlerList.toArray(new String[handlerList.size()]), false, this.wsName);
        String title = NbBundle.getMessage(WebServiceNode.class, (String)"TTL_MessageHandlerPanel");
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, title, true, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == NotifyDescriptor.OK_OPTION) {
                    DefaultListModel listModel = panel.getListModel();
                    try {
                        PortComponentHandler handler;
                        for (int i = 0; i < listModel.getSize(); ++i) {
                            String className = (String)listModel.getElementAt(i);
                            if (!WebServiceNode.this.isNewHandler(className, portComponent)) continue;
                            handler = (PortComponentHandler)WebServiceNode.this.webServices.createBean("PortComponentHandler");
                            handler.setHandlerName(className);
                            handler.setHandlerClass(className);
                            portComponent.addHandler(handler);
                        }
                        PortComponentHandler[] handlers = portComponent.getHandler();
                        for (int j = 0; j < handlers.length; ++j) {
                            handler = handlers[j];
                            String clsName = handler.getHandlerClass();
                            if (WebServiceNode.this.isInModel(clsName, listModel)) continue;
                            portComponent.removeHandler(handler);
                        }
                        WebServiceNode.this.webServices.write(WebServiceNode.this.wsSupport.getWebservicesDD());
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                }
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.setVisible(true);
    }

    public Object getValue(String attributeName) {
        Object retValue = attributeName.equals("customDelete") ? Boolean.TRUE : super.getValue(attributeName);
        return retValue;
    }

    public String getWsdlURL() {
        return this.getDefaultWSDLUrl();
    }

    public void regenerate() {
        String implClassName = this.getImplBeanClass(this.webServiceDescription).getName();
        NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WebServiceNode.class, (String)"MSG_CONFIRM_REFRESH_IMPL"), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
        if (notifyDesc.getValue() == NotifyDescriptor.NO_OPTION) {
            return;
        }
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(WebServiceNode.class, (String)"TXT_Regenerating"));
        handle.start(100);
        handle.switchToIndeterminate();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    WebServiceNode.this.runWscompileTarget();
                }
                finally {
                    handle.finish();
                }
            }
        };
        RequestProcessor.getDefault().post(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable clipboardCopy() throws IOException {
        URL url;
        block10: {
            url = new URL(this.getWsdlURL());
            boolean connectionOK = false;
            try {
                URLConnection connection = url.openConnection();
                if (!(connection instanceof HttpURLConnection)) break block10;
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                try {
                    httpConnection.setRequestMethod("GET");
                    httpConnection.connect();
                    if (200 == httpConnection.getResponseCode()) {
                        connectionOK = true;
                    }
                }
                catch (ConnectException ex) {
                    url = null;
                }
                finally {
                    if (httpConnection != null) {
                        httpConnection.disconnect();
                    }
                }
                if (!connectionOK) {
                    url = null;
                }
            }
            catch (IOException ex) {
                url = null;
            }
        }
        return new WebServiceTransferable(new WebServiceReference(url, this.wsName, this.project.getProjectDirectory().getName()));
    }

    private void runWscompileTarget() {
        FileObject buildImplFo = this.project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
        try {
            ExecutorTask wscompileTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{this.wsName + "_wscompile"}, null);
            wscompileTask.waitFinished();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().log(ex.getLocalizedMessage());
        }
        catch (IllegalArgumentException ex) {
            ErrorManager.getDefault().log(ex.getLocalizedMessage());
        }
    }
}

