/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.netbeans.beaninfo.editors.StringCustomEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.modules.Dependency;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FileEditor
extends PropertyEditorSupport
implements ExPropertyEditor,
PropertyChangeListener {
    static final String PROPERTY_SHOW_DIRECTORIES = "directories";
    static final String PROPERTY_SHOW_FILES = "files";
    static final String PROPERTY_FILTER = "filter";
    static final String PROPERTY_CURRENT_DIR = "currentDir";
    static final String PROPERTY_BASE_DIR = "baseDir";
    static final String PROPERTY_FILE_HIDING = "file_hiding";
    private int mode = 2;
    private boolean directories = true;
    private boolean files = true;
    private boolean fileHiding = false;
    private javax.swing.filechooser.FileFilter fileFilter;
    private File currentDirectory;
    private File baseDirectory;
    static File lastCurrentDir;
    private JFileChooser chooser;
    private boolean editable = true;
    private static Boolean applehack;

    public void attachEnv(PropertyEnv env) {
        Object baseDir;
        Object filter;
        Object fil;
        this.directories = true;
        this.files = true;
        this.fileFilter = null;
        this.fileHiding = false;
        Object dirs = env.getFeatureDescriptor().getValue(PROPERTY_SHOW_DIRECTORIES);
        if (dirs instanceof Boolean) {
            this.directories = (Boolean)dirs;
        }
        if ((fil = env.getFeatureDescriptor().getValue(PROPERTY_SHOW_FILES)) instanceof Boolean) {
            this.files = (Boolean)fil;
        }
        if ((filter = env.getFeatureDescriptor().getValue(PROPERTY_FILTER)) instanceof FilenameFilter) {
            this.fileFilter = new DelegatingFilenameFilter((FilenameFilter)filter);
        } else if (filter instanceof javax.swing.filechooser.FileFilter) {
            this.fileFilter = (javax.swing.filechooser.FileFilter)filter;
        } else if (filter instanceof FileFilter) {
            this.fileFilter = new DelegatingFileFilter((FileFilter)filter);
        }
        Object curDir = env.getFeatureDescriptor().getValue(PROPERTY_CURRENT_DIR);
        if (curDir instanceof File) {
            this.currentDirectory = (File)curDir;
            if (!this.currentDirectory.isDirectory()) {
                ErrorManager.getDefault().log(16, "java.io.File will not accept currentDir=" + this.currentDirectory);
                this.currentDirectory = null;
            }
        }
        if ((baseDir = env.getFeatureDescriptor().getValue(PROPERTY_BASE_DIR)) instanceof File) {
            this.baseDirectory = (File)baseDir;
            if (!this.baseDirectory.isDirectory() || !this.baseDirectory.isAbsolute()) {
                ErrorManager.getDefault().log(16, "java.io.File will not accept baseDir=" + this.baseDirectory);
                this.baseDirectory = null;
            }
        }
        this.mode = this.files ? (this.directories ? 2 : 0) : (this.directories ? 1 : 2);
        Object fileHide = env.getFeatureDescriptor().getValue(PROPERTY_FILE_HIDING);
        if (fileHide instanceof Boolean) {
            this.fileHiding = (Boolean)fileHide;
        }
        if (env.getFeatureDescriptor() instanceof Node.Property) {
            Node.Property prop = (Node.Property)env.getFeatureDescriptor();
            this.editable = prop.canWrite();
        }
    }

    public String getAsText() {
        File file = (File)this.getValue();
        if (file == null) {
            return "";
        }
        String path = file.getPath();
        if (path.equals("")) {
            path = ".";
        }
        return path;
    }

    public void setAsText(String str) throws IllegalArgumentException {
        if (str == null) {
            throw new IllegalArgumentException("null");
        }
        if (str.equals("")) {
            this.setValue(null);
            return;
        }
        if (str.equals(".")) {
            str = "";
        }
        this.setValue(new File(str));
    }

    public Component getCustomEditor() {
        if (!this.editable) {
            String info = "";
            Object curVal = this.getValue();
            if (curVal instanceof File) {
                info = ((File)curVal).getAbsolutePath();
            }
            return new StringCustomEditor(info, false, true, null);
        }
        if (this.chooser == null) {
            this.chooser = FileEditor.createHackedFileChooser();
            File originalFile = (File)this.getValue();
            if (originalFile != null && !originalFile.isAbsolute() && this.baseDirectory != null) {
                originalFile = new File(this.baseDirectory, originalFile.getPath());
            }
            if (this.currentDirectory != null) {
                this.chooser.setCurrentDirectory(this.currentDirectory);
            } else if (originalFile != null && originalFile.getParentFile() != null) {
                this.chooser.setCurrentDirectory(originalFile.getParentFile());
                this.chooser.setSelectedFile(originalFile);
            } else if (lastCurrentDir != null) {
                this.chooser.setCurrentDirectory(lastCurrentDir);
            }
            this.chooser.setFileSelectionMode(this.mode);
            if (this.fileFilter != null) {
                this.chooser.setFileFilter(this.fileFilter);
            }
            switch (this.mode) {
                case 2: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFilesAndDirs"));
                    break;
                }
                case 0: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFiles"));
                    break;
                }
                case 1: {
                    this.chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleDirs"));
                }
            }
            this.chooser.setFileHidingEnabled(this.fileHiding);
            this.chooser.setControlButtonsAreShown(false);
            this.chooser.addPropertyChangeListener("SelectedFileChangedProperty", this);
            HelpCtx.setHelpIDString((JComponent)this.chooser, (String)this.getHelpCtx().getHelpID());
        }
        return this.chooser;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getJavaInitializationString() {
        File value = (File)this.getValue();
        if (value == null) {
            return "null";
        }
        if (this.baseDirectory != null && !value.isAbsolute()) {
            return "new java.io.File(" + FileEditor.stringify(this.baseDirectory.getPath()) + ", " + FileEditor.stringify(value.getPath()) + ")";
        }
        return "new java.io.File(" + FileEditor.stringify(value.getAbsolutePath()) + ")";
    }

    static String stringify(String in) {
        StringBuffer buf = new StringBuffer(in.length() * 2 + 2);
        buf.append('\"');
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '\\' || c == '\"') {
                buf.append('\\');
            }
            buf.append(c);
        }
        buf.append('\"');
        return buf.toString();
    }

    private HelpCtx getHelpCtx() {
        return new HelpCtx(FileEditor.class);
    }

    private static String getString(String key) {
        return NbBundle.getBundle((Class)FileEditor.class).getString(key);
    }

    static String getChildRelativePath(File baseDir, File file) {
        if (file.equals(baseDir)) {
            return "";
        }
        StringBuffer buf = new StringBuffer(file.getPath().length());
        buf.append(file.getName());
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.equals(baseDir)) {
                return buf.toString();
            }
            buf.insert(0, File.separatorChar);
            buf.insert(0, parent.getName());
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String rel;
        JFileChooser chooser = (JFileChooser)e.getSource();
        File f = chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        if (!this.files && f.isFile()) {
            return;
        }
        if (!this.directories && f.isDirectory()) {
            return;
        }
        if (this.baseDirectory != null && (rel = FileEditor.getChildRelativePath(this.baseDirectory, f)) != null) {
            f = new File(rel);
        }
        this.setValue(new File(f.getPath()));
        lastCurrentDir = chooser.getCurrentDirectory();
    }

    public static JFileChooser createHackedFileChooser() {
        JFileChooser chooser = new JFileChooser();
        FileEditor.hackFileChooser(chooser);
        return chooser;
    }

    public static void hackFileChooser(final JFileChooser chooser) {
        ActionMap parent;
        ActionMap map;
        KeyStroke enter;
        Object value;
        chooser.getAccessibleContext().setAccessibleDescription(FileEditor.getString("ACSD_FileEditor"));
        InputMap im = chooser.getInputMap(1);
        if (im != null && (value = im.get(enter = KeyStroke.getKeyStroke(10, 0))) == null) {
            im.put(enter, "approveSelection");
        }
        if ((map = chooser.getActionMap()) != null && (parent = map.getParent()) != null) {
            final Action original = parent.get("approveSelection");
            parent.put("approveSelection", new AbstractAction(){
                private String lastDir = null;

                public void actionPerformed(ActionEvent evt) {
                    block11: {
                        File afterfile;
                        File file;
                        File beforefile = chooser.getSelectedFile();
                        if (original != null) {
                            original.actionPerformed(evt);
                        }
                        if ((file = (afterfile = chooser.getSelectedFile()) != null ? afterfile : beforefile) != null) {
                            if (file.isDirectory()) {
                                try {
                                    file = file.getCanonicalFile();
                                    if (chooser.getFileSelectionMode() == 1) {
                                        String path = file.getPath();
                                        if (path.equals(this.lastDir)) {
                                            chooser.setCurrentDirectory(file);
                                            this.lastDir = null;
                                        } else {
                                            chooser.setCurrentDirectory(file.getParentFile());
                                            chooser.setSelectedFile(file);
                                            chooser.ensureFileIsVisible(file);
                                            this.lastDir = path;
                                        }
                                        break block11;
                                    }
                                    chooser.setCurrentDirectory(file);
                                }
                                catch (IOException ioe) {}
                            } else {
                                File dir = file.getParentFile();
                                chooser.setCurrentDirectory(dir);
                                chooser.setSelectedFile(file);
                                chooser.ensureFileIsVisible(file);
                            }
                        } else if (original != null) {
                            original.actionPerformed(evt);
                        }
                    }
                }
            });
        }
        final Object key = chooser.getInputMap(1).get(KeyStroke.getKeyStroke(27, 0));
        AbstractAction close = new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
                Action a;
                Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (key != null && (a = chooser.getActionMap().get(key)) != null) {
                    a.actionPerformed(ae);
                }
                if (comp.getParent() == null) {
                    return;
                }
                Container c = chooser.getTopLevelAncestor();
                if (c instanceof Dialog && ((Dialog)c).isVisible()) {
                    ((Dialog)c).setVisible(false);
                    ((Dialog)c).dispose();
                }
            }
        };
        chooser.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "close");
        chooser.getActionMap().put("close", close);
        if (FileEditor.needAppleHack()) {
            FileEditor.appleHackChooser(chooser);
        }
    }

    private static void appleHackChooser(JFileChooser jfc) {
        jfc.addPropertyChangeListener(new ButtonHider());
    }

    private static boolean needAppleHack() {
        if (applehack == null) {
            applehack = Utilities.getOperatingSystem() == 4096 ? ("1.4.2_03".equals(Dependency.JAVA_IMPL) ? ("Aqua".equals(UIManager.getLookAndFeel().getID()) || Boolean.getBoolean("netbeans.apple.filechooserhack") ? Boolean.TRUE : Boolean.FALSE) : Boolean.FALSE) : Boolean.FALSE;
        }
        return applehack;
    }

    static {
        applehack = null;
    }

    static class DelegatingFilenameFilter
    extends javax.swing.filechooser.FileFilter {
        private FilenameFilter filter;

        public DelegatingFilenameFilter(FilenameFilter f) {
            this.filter = f;
        }

        public boolean accept(File f) {
            return this.filter.accept(f.getParentFile(), f.getName());
        }

        public String getDescription() {
            return null;
        }
    }

    static class DelegatingFileFilter
    extends javax.swing.filechooser.FileFilter {
        private FileFilter filter;

        public DelegatingFileFilter(FileFilter f) {
            this.filter = f;
        }

        public boolean accept(File f) {
            return this.filter.accept(f);
        }

        public String getDescription() {
            return null;
        }
    }

    private static class ButtonHider
    implements PropertyChangeListener {
        private ButtonHider() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if ("ControlButtonsAreShownChangedProperty".equals(pce.getPropertyName())) {
                JFileChooser jfc = (JFileChooser)pce.getSource();
                try {
                    this.hideShowButtons(jfc, Boolean.TRUE.equals(pce.getNewValue()));
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        }

        private void hideShowButtons(Container cont, boolean val) {
            if (cont instanceof JComboBox || cont instanceof JScrollBar) {
                return;
            }
            Component[] c = cont.getComponents();
            for (int i = 0; i < c.length; ++i) {
                if (c[i] instanceof Container) {
                    this.hideShowButtons((Container)c[i], val);
                }
                if (!(c[i] instanceof AbstractButton)) continue;
                c[i].setVisible(val);
            }
        }
    }
}

