/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.classpath.support;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.classpath.ClassPathAccessor;
import org.netbeans.modules.java.classpath.ProxyClassPathImplementation;
import org.netbeans.modules.java.classpath.SimpleClassPathImplementation;
import org.netbeans.modules.java.classpath.SimplePathResourceImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public class ClassPathSupport {
    static final /* synthetic */ boolean $assertionsDisabled;

    private ClassPathSupport() {
    }

    public static PathResourceImplementation createResource(URL url) {
        if (url == null) {
            throw new NullPointerException("Cannot pass null URL to ClassPathSupport.createResource");
        }
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertions && FileUtil.isArchiveFile((URL)url)) {
            throw new IllegalArgumentException("File URL pointing to JAR is not valid classpath entry. Use jar: URL. Was: " + url);
        }
        if (!url.toExternalForm().endsWith("/")) {
            throw new IllegalArgumentException("URL must be a folder URL (append '/' if necessary): " + url);
        }
        return new SimplePathResourceImplementation(url);
    }

    public static ClassPathImplementation createClassPathImplementation(List entries) {
        if (entries == null) {
            throw new NullPointerException("Cannot pass null entries");
        }
        return new SimpleClassPathImplementation(entries);
    }

    public static ClassPath createClassPath(List entries) {
        if (entries == null) {
            throw new NullPointerException("Cannot pass null entries");
        }
        return ClassPathFactory.createClassPath(ClassPathSupport.createClassPathImplementation(entries));
    }

    public static ClassPath createClassPath(FileObject[] roots) {
        if (!$assertionsDisabled && roots == null) {
            throw new AssertionError();
        }
        ArrayList<PathResourceImplementation> l = new ArrayList<PathResourceImplementation>();
        for (int i = 0; i < roots.length; ++i) {
            if (roots[i] == null) continue;
            try {
                URL u = roots[i].getURL();
                l.add(ClassPathSupport.createResource(u));
                continue;
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return ClassPathSupport.createClassPath(l);
    }

    public static ClassPath createClassPath(URL[] roots) {
        if (!$assertionsDisabled && roots == null) {
            throw new AssertionError();
        }
        ArrayList<PathResourceImplementation> l = new ArrayList<PathResourceImplementation>();
        for (int i = 0; i < roots.length; ++i) {
            if (roots[i] == null) continue;
            l.add(ClassPathSupport.createResource(roots[i]));
        }
        return ClassPathSupport.createClassPath(l);
    }

    public static ClassPathImplementation createProxyClassPathImplementation(ClassPathImplementation[] delegates) {
        return new ProxyClassPathImplementation(delegates);
    }

    public static ClassPath createProxyClassPath(ClassPath[] delegates) {
        if (!$assertionsDisabled && delegates == null) {
            throw new AssertionError();
        }
        ClassPathImplementation[] impls = new ClassPathImplementation[delegates.length];
        for (int i = 0; i < delegates.length; ++i) {
            impls[i] = ClassPathAccessor.DEFAULT.getClassPathImpl(delegates[i]);
        }
        return ClassPathFactory.createClassPath(ClassPathSupport.createProxyClassPathImplementation(impls));
    }

    static {
        $assertionsDisabled = !ClassPathSupport.class.desiredAssertionStatus();
    }
}

