/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.dao;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.persistence.action.EntityManagerGenerator;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.PersistenceClientEntitySelection;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.dao.EjbFacadeWizardPanel2;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class EjbFacadeWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;
    private String[] steps;
    private int stepsStartPos;

    private WizardDescriptor.Panel[] getPanels() {
        return this.panels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate() throws IOException {
        List entities = (List)this.wizard.getProperty("EntityClass");
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        HashSet<FileObject> createdFiles = new HashSet<FileObject>();
        EjbFacadeWizardPanel2 panel = (EjbFacadeWizardPanel2)this.panels[1];
        String pkg = panel.getPackage();
        PersistenceUnit persistenceUnit = (PersistenceUnit)((Object)this.wizard.getProperty("PersistenceUnit"));
        if (persistenceUnit != null) {
            ProviderUtil.addPersistenceUnit(persistenceUnit, Templates.getProject((WizardDescriptor)this.wizard));
        }
        for (Entity entity : entities) {
            String entityClass = entity.getClass2();
            String simpleClassName = Util.simpleClassName(entityClass);
            String variableName = simpleClassName.toLowerCase().charAt(0) + simpleClassName.substring(1);
            String facadeNameBase = pkg + "." + simpleClassName;
            String classBean = JMIUtils.uniqueClassName((String)(facadeNameBase + "Facade"), (FileObject)targetFolder);
            classBean = classBean.substring(classBean.lastIndexOf(".") + 1);
            JavaClass jc = JMIGenerationUtil.createClass((FileObject)targetFolder, (String)classBean);
            boolean rollback = true;
            JMIUtils.beginJmiTransaction((boolean)true);
            try {
                Annotation stateless = JMIGenerationUtil.createAnnotation((Element)jc, (String)"javax.ejb.Stateless", (List)Collections.EMPTY_LIST);
                jc.getAnnotations().add(stateless);
                JavaClass localIF = null;
                JavaClass remoteIF = null;
                boolean hasLocal = panel.isLocal();
                boolean hasRemote = panel.isRemote();
                if (hasLocal) {
                    String classLocal = JMIUtils.uniqueClassName((String)(facadeNameBase + "FacadeLocal"), (FileObject)targetFolder);
                    classLocal = classLocal.substring(classLocal.lastIndexOf(".") + 1);
                    localIF = JMIGenerationUtil.createInterface((FileObject)targetFolder, (String)classLocal);
                    Annotation localAnn = JMIGenerationUtil.createAnnotation((Element)localIF, (String)"javax.ejb.Local", (List)Collections.EMPTY_LIST);
                    localIF.getAnnotations().add(localAnn);
                    JMIUtils.addInterface((JavaClass)jc, (String)localIF.getName());
                }
                if (hasRemote) {
                    String classRemote = JMIUtils.uniqueClassName((String)(facadeNameBase + "FacadeRemote"), (FileObject)targetFolder);
                    classRemote = classRemote.substring(classRemote.lastIndexOf(".") + 1);
                    remoteIF = JMIGenerationUtil.createInterface((FileObject)targetFolder, (String)classRemote);
                    Annotation remoteAnn = JMIGenerationUtil.createAnnotation((Element)remoteIF, (String)"javax.ejb.Remote", (List)Collections.EMPTY_LIST);
                    remoteIF.getAnnotations().add(remoteAnn);
                    JMIUtils.addInterface((JavaClass)jc, (String)remoteIF.getName());
                }
                Parameter p = JMIGenerationUtil.createParameter((Element)jc, (String)variableName, (String)entityClass);
                EntityManagerGenerator.generate(jc, "em.persist({0});", "create", "void", p, null, false, false);
                EjbFacadeWizardIterator.addMethodToInterface("create", "void", p, localIF, remoteIF);
                p = JMIGenerationUtil.createParameter((Element)jc, (String)variableName, (String)entityClass);
                EntityManagerGenerator.generate(jc, "em.merge({0});", "edit", "void", p, null, false, false);
                EjbFacadeWizardIterator.addMethodToInterface("edit", "void", p, localIF, remoteIF);
                p = JMIGenerationUtil.createParameter((Element)jc, (String)variableName, (String)entityClass);
                EntityManagerGenerator.generate(jc, "em.merge({0});\nem.remove({0});", "destroy", "void", p, null, false, false);
                EjbFacadeWizardIterator.addMethodToInterface("destroy", "void", p, localIF, remoteIF);
                p = JMIGenerationUtil.createParameter((Element)jc, (String)"pk", (String)Object.class.getName());
                EntityManagerGenerator.generate(jc, "return ({2}) em.find({2}.class, {0});", "find", entityClass, p, entityClass, false, false);
                EjbFacadeWizardIterator.addMethodToInterface("find", entityClass, p, localIF, remoteIF);
                EntityManagerGenerator.generate(jc, "return em.createQuery(\"select object(o) from {2} as o\").getResultList();", "findAll", List.class.getName(), null, entity.getName(), false, false);
                EjbFacadeWizardIterator.addMethodToInterface("findAll", List.class.getName(), null, localIF, remoteIF);
                createdFiles.add(JavaModel.getFileObject((Resource)jc.getResource()));
                rollback = false;
            }
            finally {
                JMIUtils.endJmiTransaction((boolean)rollback);
            }
            EntityManagerGenerator.fixImports(jc);
        }
        return createdFiles;
    }

    private static void addMethodToInterface(String name, String type, Parameter p, JavaClass localIF, JavaClass remoteIF) {
        Method m;
        if (localIF != null) {
            m = JMIGenerationUtil.createMethod((Element)localIF, (String)name, (int)0, (String)type);
            if (p != null) {
                m.getParameters().add(p.duplicate());
            }
            localIF.getFeatures().add(m);
        }
        if (remoteIF != null) {
            m = JMIGenerationUtil.createMethod((Element)remoteIF, (String)name, (int)0, (String)type);
            if (p != null) {
                m.getParameters().add(p.duplicate());
            }
            remoteIF.getFeatures().add(m);
        }
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        wizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(EjbFacadeWizardIterator.class, (String)"Templates/Persistence/ejbFacade"));
        Project project = Templates.getProject((WizardDescriptor)wizard);
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new PersistenceClientEntitySelection(NbBundle.getMessage(EjbFacadeWizardIterator.class, (String)"LBL_EntityClasses"), new HelpCtx(EjbFacadeWizardIterator.class.getName() + "$PersistenceClientEntitySelection"), wizard), new EjbFacadeWizardPanel2(project, wizard)};
            if (this.steps == null) {
                this.mergeSteps(new String[]{NbBundle.getMessage(EjbFacadeWizardIterator.class, (String)"LBL_EntityClasses"), NbBundle.getMessage(EjbFacadeWizardIterator.class, (String)"LBL_GeneratedSessionBeans")});
            }
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty(WIZARD_PANEL_CONTENT_DATA, this.steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return NbBundle.getMessage(EjbFacadeWizardIterator.class, (String)"LBL_FacadeWizardTitle");
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private void mergeSteps(String[] thisSteps) {
        String[] beforeSteps;
        Object prop = this.wizard.getProperty(WIZARD_PANEL_CONTENT_DATA);
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
            this.stepsStartPos = beforeSteps.length;
            if (this.stepsStartPos > 0 && "...".equals(beforeSteps[this.stepsStartPos - 1])) {
                --this.stepsStartPos;
            }
        } else {
            beforeSteps = null;
            this.stepsStartPos = 0;
        }
        this.steps = new String[this.stepsStartPos + thisSteps.length];
        System.arraycopy(beforeSteps, 0, this.steps, 0, this.stepsStartPos);
        System.arraycopy(thisSteps, 0, this.steps, this.stepsStartPos, thisSteps.length);
    }
}

