/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.bridge;

import com.sun.enterprise.admin.jmx.remote.SunOneHttpJmxConnectorFactory;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.deployapi.SunDeploymentManager;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.deployment.client.ServerConnectionEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.netbeans.modules.j2ee.sun.bridge.X509TrustManager;

public class AppServerBridge {
    public static File getDirLocation(TargetModuleID tmid) {
        File dirLocation = null;
        try {
            SunTargetModuleID ddd = (SunTargetModuleID)tmid;
            if (ddd.getModuleType().equals(ModuleType.WAR)) {
                ObjectName aaaa = new ObjectName("com.sun.appserv:type=web-module,name=" + ddd.getModuleID() + ",category=config");
                dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "location"));
            } else if (ddd.getModuleType().equals(ModuleType.EJB)) {
                ObjectName aaaa = new ObjectName("com.sun.appserv:type=ejb-module,name=" + ddd.getModuleID() + ",category=config");
                dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "location"));
            } else if (ddd.getModuleType().equals(ModuleType.EAR)) {
                ObjectName aaaa = new ObjectName("com.sun.appserv:type=application,name=" + ddd.getModuleID() + ",category=config");
                dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "location"));
            } else {
                System.out.println("Still Some Work to do in ModuleRestartActikon is AS 8.1 plugin code");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
        return dirLocation;
    }

    public static boolean isApp(TargetModuleID tmid) {
        ModuleType mt = ((SunTargetModuleID)tmid).getModuleType();
        return mt.equals(ModuleType.EAR);
    }

    public static boolean isWar(TargetModuleID tmid) {
        ModuleType mt = ((SunTargetModuleID)tmid).getModuleType();
        return mt.equals(ModuleType.WAR);
    }

    public static Boolean isCar(TargetModuleID tmid) {
        ModuleType mt = ((SunTargetModuleID)tmid).getModuleType();
        return mt.equals(ModuleType.CAR);
    }

    public static String getModuleUrl(TargetModuleID module) {
        String moduleID;
        int i;
        ModuleType mt = ((SunTargetModuleID)module).getModuleType();
        String suffix = ".jar";
        if (mt.equals(ModuleType.EAR)) {
            suffix = ".ear";
        }
        if (mt.equals(ModuleType.WAR)) {
            suffix = ".war";
        }
        if (mt.equals(ModuleType.RAR)) {
            suffix = ".rar";
        }
        if ((i = (moduleID = module.getModuleID()).indexOf(35)) > -1) {
            moduleID = moduleID.substring(i + 1);
        }
        if (moduleID.endsWith(suffix) || moduleID.endsWith(suffix.toUpperCase())) {
            return moduleID;
        }
        return moduleID + suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostPort(File domainXml, File platformDir) {
        String hostPort = null;
        InputStream inFile = null;
        try {
            File defDomainXml = new File(platformDir, "lib/install/templates/default-domain.xml.template");
            inFile = new FileInputStream(defDomainXml);
            Domain domain = Domain.createGraph((InputStream)inFile);
            String defDomainSysID = domain.graphManager().getXmlDocument().getDoctype().getSystemId();
            inFile.close();
            inFile = null;
            inFile = new FileInputStream(domainXml);
            domain = Domain.createGraph((InputStream)inFile);
            String domainSysID = domain.graphManager().getXmlDocument().getDoctype().getSystemId();
            if (!defDomainSysID.equals(domainSysID)) {
                String string = null;
                return string;
            }
            Config conf = domain.getConfigs().getConfigByName("server-config");
            HttpListener list = conf.getHttpService().getHttpListenerById("admin-listener");
            hostPort = "localhost:" + list.getPort();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (null != inFile) {
                try {
                    inFile.close();
                }
                catch (IOException ioe) {}
            }
        }
        return hostPort;
    }

    public String getNonAdminPortNumber(File domainXml) {
        String port = null;
        try {
            FileInputStream inFile = new FileInputStream(domainXml);
            Domain domain = Domain.createGraph((InputStream)inFile);
            Config conf = domain.getConfigs().getConfigByName("server-config");
            HttpListener list = conf.getHttpService().getHttpListenerById("http-listener-1");
            port = list.getPort();
            ((InputStream)inFile).close();
        }
        catch (Exception ex) {
            return null;
        }
        return port;
    }

    public static MBeanServerConnection getJMXConnector(String host, int port, String username, String password, boolean secure) throws MalformedURLException, IOException {
        MBeanServerConnection serverConn = null;
        String mode = null;
        mode = secure ? "s1ashttps" : "s1ashttp";
        JMXServiceURL serverUrl = new JMXServiceURL(mode, host, port);
        JMXConnector connector = SunOneHttpJmxConnectorFactory.connect((JMXServiceURL)serverUrl, (String)username, (String)password);
        serverConn = connector.getMBeanServerConnection();
        return serverConn;
    }

    public static void setServerConnectionEnvironment(DeploymentManager dm) {
        ServerConnectionEnvironment env = new ServerConnectionEnvironment();
        env.put((Object)"TRUST_MANAGER_KEY", (Object)new X509TrustManager());
        if (dm instanceof SunDeploymentManager) {
            ((SunDeploymentManager)dm).setServerConnectionEnvironment(env);
        }
    }
}

