/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.modules.editor.hints.spi.HintsProvider;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.hints.ExposeMethodHint;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

public class EjbHintsProvider
extends HintsProvider {
    private static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.ejbcore");
    private static MethodHintCreator[] methodHintCreators = new MethodHintCreator[]{new ExposeInLocalHintCreator(), new ExposeInRemoteHintCreator()};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getHints(Document doc, int offset) {
        if (!(doc instanceof BaseDocument)) return Collections.EMPTY_LIST;
        BaseDocument baseDoc = (BaseDocument)doc;
        JMIUtils.beginJmiTransaction();
        org.netbeans.modules.editor.java.JMIUtils utils = null;
        Resource resource = null;
        try {
            utils = org.netbeans.modules.editor.java.JMIUtils.get((BaseDocument)baseDoc);
            resource = utils.getResource();
            FileObject fo = JavaModel.getFileObject((Resource)resource);
            if (fo == null || EjbJar.getEjbJar((FileObject)fo) == null) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
        }
        finally {
            JMIUtils.endJmiTransaction();
        }
        try {
            int realStart = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDoc, (int)Utilities.getRowStart((BaseDocument)baseDoc, (int)offset));
            int realEnd = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDoc, (int)Utilities.getRowEnd((BaseDocument)baseDoc, (int)offset));
            if (realStart > realEnd) {
                return Collections.EMPTY_LIST;
            }
            offset = Math.min(Math.max(offset, realStart), realEnd);
            ArrayList result = new ArrayList();
            HashSet handledDescriptions = new HashSet();
            JavaModel.getJavaRepository().beginTrans(false);
            try {
                Element e;
                if (resource == null) {
                    ArrayList arrayList = result;
                    return arrayList;
                }
                JavaModel.setClassPath((Resource)resource);
                if (ERR.isLoggable(1)) {
                    Element el = resource.getElementByOffset(offset);
                    ERR.log("el=" + el);
                }
                for (e = resource.getElementByOffset(offset); !(e == null || e instanceof Feature || e instanceof StatementBlock || e instanceof Resource); e = (Element)e.refImmediateComposite()) {
                }
                if (!(e instanceof CallableFeature)) return result;
                CallableFeature feature = (CallableFeature)e;
                if (feature == null) return result;
                PositionBounds bounds = JavaMetamodel.getManager().getElementPosition((Element)feature);
                if (!(feature instanceof Method)) return result;
                if (bounds.getBegin().getOffset() > offset) return result;
                if (bounds.getEnd().getOffset() < offset) return result;
                int i = 0;
                while (i < methodHintCreators.length) {
                    methodHintCreators[i].createHint(utils, resource, doc, (Method)feature, offset, result);
                    ++i;
                }
                return result;
            }
            finally {
                JavaModel.getJavaRepository().endTrans();
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return Collections.EMPTY_LIST;
    }

    private static class ExposeInRemoteHintCreator
    extends MethodHintCreator {
        private ExposeInRemoteHintCreator() {
        }

        public void createHint(org.netbeans.modules.editor.java.JMIUtils utils, Resource resource, Document doc, Method method, int offset, List result) {
            if (Utils.canExposeInRemote(method)) {
                result.add(new ExposeMethodHint(method, 1));
            }
        }
    }

    private static class ExposeInLocalHintCreator
    extends MethodHintCreator {
        private ExposeInLocalHintCreator() {
        }

        public void createHint(org.netbeans.modules.editor.java.JMIUtils utils, Resource resource, Document doc, Method method, int offset, List result) {
            if (Utils.canExposeInLocal(method)) {
                result.add(new ExposeMethodHint(method, 0));
            }
        }
    }

    private static abstract class MethodHintCreator {
        private MethodHintCreator() {
        }

        public abstract void createHint(org.netbeans.modules.editor.java.JMIUtils var1, Resource var2, Document var3, Method var4, int var5, List var6);
    }
}

