/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard;

import java.io.IOException;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.Transaction;
import org.netbeans.modules.j2ee.common.TransactionSupport;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class TransactionHelper {
    private Transaction transaction;

    public void initialize(final WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        EjbJar ejbModule = EjbJar.getEjbJars((Project)project)[0];
        try {
            FileObject ejbJarFile = ejbModule.getDeploymentDescriptor();
            if (ejbJarFile == null) {
                return;
            }
            DataObject dataObject = DataObject.find((FileObject)ejbJarFile);
            final TransactionSupport transactionSupport = (TransactionSupport)dataObject.getCookie(TransactionSupport.class);
            if (transactionSupport != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Transaction transaction = transactionSupport.openTransaction();
                        if (transaction == null) {
                            ((JButton)wizardDescriptor.getClosingOptions()[1]).doClick();
                        } else {
                            TransactionHelper.this.transaction = transaction;
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write() throws IOException {
        if (this.transaction != null) {
            this.transaction.commit();
            this.transaction = null;
        }
    }

    public void uninitialize() {
        if (this.transaction != null) {
            this.transaction.rollback();
            this.transaction = null;
        }
    }
}

