/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.web.monitor.client.DisplayTable;
import org.netbeans.modules.web.monitor.client.SortButton;
import org.netbeans.modules.web.monitor.data.Param;

public abstract class DataDisplay
extends JPanel {
    static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    static final Insets tableInsets = new Insets(0, 18, 12, 12);
    static final Insets labelInsets = new Insets(0, 6, 0, 0);
    static final Insets buttonInsets = new Insets(6, 0, 5, 6);
    static final Insets sortButtonInsets = new Insets(0, 12, 0, 0);
    static final Insets indentInsets = new Insets(0, 18, 0, 0);
    static final Insets topSpacerInsets = new Insets(12, 0, 0, 0);
    static final int fullGridWidth = 0;
    static final double tableWeightX = 1.0;
    static final double tableWeightY = 0.0;

    public DataDisplay() {
        this.setLayout(new GridBagLayout());
    }

    void addGridBagComponent(Container parent, Component comp, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets, int ipadx, int ipady) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = gridx;
        cons.gridy = gridy;
        cons.gridwidth = gridwidth;
        cons.gridheight = gridheight;
        cons.weightx = weightx;
        cons.weighty = weighty;
        cons.anchor = anchor;
        cons.fill = fill;
        cons.insets = insets;
        cons.ipadx = ipadx;
        cons.ipady = ipady;
        parent.add(comp, cons);
    }

    static JButton createSortButton(DisplayTable dt) {
        SortButton b = new SortButton(dt);
        return b;
    }

    static Component createTopSpacer() {
        return Box.createVerticalStrut(1);
    }

    static Component createRigidArea() {
        return Box.createRigidArea(new Dimension(0, 5));
    }

    static Component createGlue() {
        return Box.createGlue();
    }

    static JLabel createHeaderLabel(String label) {
        return DataDisplay.createHeaderLabel(label, ' ', null, null);
    }

    static JLabel createHeaderLabel(String label, char mnemonic, String ad, Component comp) {
        JLabel jl = new JLabel(label);
        Font labelFont = jl.getFont();
        Font boldFont = labelFont.deriveFont(1);
        jl.setFont(boldFont);
        if (mnemonic != ' ') {
            jl.setDisplayedMnemonic(mnemonic);
        }
        if (ad != null) {
            jl.getAccessibleContext().setAccessibleDescription(ad);
        }
        if (comp != null) {
            jl.setLabelFor(comp);
        }
        return jl;
    }

    static JLabel createDataLabel(String label) {
        JLabel jl = new JLabel(label);
        return jl;
    }

    static Component createSortButtonLabel(String label, DisplayTable dt, char mnemonic, String ad) {
        JPanel panel = new JPanel();
        panel.add(DataDisplay.createHeaderLabel(label, mnemonic, ad, dt));
        panel.add(DataDisplay.createSortButton(dt));
        return panel;
    }

    void log(String s) {
        System.out.println("DataDisplay::" + s);
    }

    Param findParam(Param[] myParams, String name, String value) {
        for (int i = 0; i < myParams.length; ++i) {
            Param param = myParams[i];
            if (!name.equals(param.getName()) || !value.equals(param.getValue())) continue;
            return param;
        }
        return null;
    }
}

