/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.mapping.core;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractState
implements Cloneable {
    private Model _model;
    private MappingClassElement _mappingElement;
    private PersistenceClassElement _persistenceElement;

    public AbstractState(Model model) {
        this(model, null);
    }

    public AbstractState(Model model, MappingClassElement mappingClass) {
        this._model = model;
        this._mappingElement = mappingClass;
    }

    public Object clone() {
        try {
            return (AbstractState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    protected Map getClonedMap(Map originalMap) {
        Iterator iterator = originalMap.keySet().iterator();
        HashMap newMap = new HashMap();
        while (iterator.hasNext()) {
            Object nextKey = iterator.next();
            newMap.put(nextKey, ((AbstractState)originalMap.get(nextKey)).clone());
        }
        return newMap;
    }

    public abstract String getDebugInfo();

    protected Model getModel() {
        return this._model;
    }

    public MappingClassElement getMappingClassElement() {
        return this._mappingElement;
    }

    protected void setMappingClassElement(MappingClassElement mappingElement) {
        this._mappingElement = mappingElement;
    }

    public PersistenceClassElement getPersistenceClassElement() {
        if (this._persistenceElement == null && this._mappingElement != null) {
            this._persistenceElement = this.getModel().getPersistenceClass(this._mappingElement.getName());
        }
        return this._persistenceElement;
    }
}

