/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Abbrev;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.codetemplates.CodeTemplateCompletionItem;
import org.netbeans.lib.editor.codetemplates.CodeTemplateManagerOperation;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public final class CodeTemplateCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int type, JTextComponent component) {
        return CodeTemplateCompletionProvider.isAbbrevDisabled(component) ? null : new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    private static boolean isAbbrevDisabled(JTextComponent component) {
        return Abbrev.isAbbrevDisabled((JTextComponent)component);
    }

    private static final class Query
    extends AsyncCompletionQuery
    implements ChangeListener {
        private String identifierBeforeCursor;

        private Query() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            CodeTemplateManagerOperation op = CodeTemplateManagerOperation.get(doc);
            this.identifierBeforeCursor = null;
            if (doc instanceof AbstractDocument) {
                AbstractDocument adoc = (AbstractDocument)doc;
                adoc.readLock();
                try {
                    if (adoc instanceof BaseDocument) {
                        this.identifierBeforeCursor = Utilities.getIdentifierBefore((BaseDocument)((BaseDocument)adoc), (int)caretOffset);
                    }
                }
                catch (BadLocationException e) {
                }
                finally {
                    adoc.readUnlock();
                }
            }
            op.waitLoaded();
            List cts = this.identifierBeforeCursor != null ? op.findByParametrizedText(this.identifierBeforeCursor, true) : Collections.EMPTY_LIST;
            ArrayList<CodeTemplateCompletionItem> items = new ArrayList<CodeTemplateCompletionItem>(cts.size());
            Iterator it = cts.iterator();
            while (it.hasNext()) {
                CodeTemplate ct = (CodeTemplate)it.next();
                items.add(new CodeTemplateCompletionItem(ct));
            }
            resultSet.addAllItems(items);
            resultSet.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent evt) {
            Query query = this;
            synchronized (query) {
                this.notify();
            }
        }
    }
}

