/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seproject.J2SEActionProvider;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.SourceRoots;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class J2SEProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private J2SEProject project;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$api$project$ProjectInformation;

    public J2SEProjectOperations(J2SEProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList files = new ArrayList();
        J2SEProjectOperations.addFile(projectDirectory, "nbproject", files);
        J2SEProjectOperations.addFile(projectDirectory, "build.xml", files);
        J2SEProjectOperations.addFile(projectDirectory, "xml-resources", files);
        J2SEProjectOperations.addFile(projectDirectory, "catalog.xml", files);
        return files;
    }

    public List getDataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        SourceRoots src = this.project.getSourceRoots();
        FileObject[] srcRoots = src.getRoots();
        for (int cntr = 0; cntr < srcRoots.length; ++cntr) {
            files.add(srcRoots[cntr]);
        }
        SourceRoots test = this.project.getTestSourceRoots();
        FileObject[] testRoots = test.getRoots();
        for (int cntr = 0; cntr < testRoots.length; ++cntr) {
            files.add(testRoots[cntr]);
        }
        J2SEProjectOperations.addFile(projectDirectory, "manifest.mf", files);
        return files;
    }

    public void notifyDeleting() throws IOException {
        J2SEActionProvider ap = (J2SEActionProvider)this.project.getLookup().lookup(J2SEActionProvider.class);
        if (!$assertionsDisabled && ap == null) {
            throw new AssertionError();
        }
        Lookup context = Lookups.fixed((Object[])new Object[0]);
        Properties p = new Properties();
        String[] targetNames = ap.getTargetNames("clean", context, p);
        FileObject buildXML = this.project.getProjectDirectory().getFileObject("build.xml");
        if (!$assertionsDisabled && targetNames == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && targetNames.length <= 0) {
            throw new AssertionError();
        }
        ActionUtils.runTarget((FileObject)buildXML, (String[])targetNames, (Properties)p).waitFinished();
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
    }

    public void notifyCopied(Project original, File originalPath, String nueName) {
        if (original == null) {
            return;
        }
        this.fixDistJarProperty(nueName);
        this.project.getReferenceHelper().fixReferences(originalPath);
        this.project.setName(nueName);
    }

    public void notifyMoving() throws IOException {
        if (!this.project.getUpdateHelper().requestSave()) {
            throw new IOException(NbBundle.getMessage((Class)J2SEProjectOperations.class, (String)"MSG_OldProjectMetadata"));
        }
        this.notifyDeleting();
    }

    public void notifyMoved(Project original, File originalPath, String nueName) {
        if (original == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        this.fixDistJarProperty(nueName);
        this.project.setName(nueName);
        this.project.getReferenceHelper().fixReferences(originalPath);
    }

    private static boolean isParent(File folder, File fo) {
        if (folder.equals(fo)) {
            return false;
        }
        while (fo != null) {
            if (fo.equals(folder)) {
                return true;
            }
            fo = fo.getParentFile();
        }
        return false;
    }

    private void fixDistJarProperty(final String newName) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                ProjectInformation pi = (ProjectInformation)J2SEProjectOperations.this.project.getLookup().lookup(class$org$netbeans$api$project$ProjectInformation == null ? (class$org$netbeans$api$project$ProjectInformation = J2SEProjectOperations.class$("org.netbeans.api.project.ProjectInformation")) : class$org$netbeans$api$project$ProjectInformation);
                String oldDistJar = pi == null ? null : "${dist.dir}/" + PropertyUtils.getUsablePropertyName((String)pi.getDisplayName()) + ".jar";
                EditableProperties ep = J2SEProjectOperations.this.project.getUpdateHelper().getProperties("nbproject/project.properties");
                String propValue = ep.getProperty("dist.jar");
                if (oldDistJar != null && oldDistJar.equals(propValue)) {
                    ep.put((Object)"dist.jar", (Object)("${dist.dir}/" + PropertyUtils.getUsablePropertyName((String)newName) + ".jar"));
                    J2SEProjectOperations.this.project.getUpdateHelper().putProperties("nbproject/project.properties", ep);
                }
            }
        });
    }

    static {
        $assertionsDisabled = !J2SEProjectOperations.class.desiredAssertionStatus();
    }
}

