/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.java.parser;

import org.netbeans.lib.java.parser.ASTClass;
import org.netbeans.lib.java.parser.ASTContext;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;

class ASTreeNode
extends ASTClass
implements ASTreeTypes {
    private int firstToken;
    private int lastToken;
    ASTree[] subTrees;

    ASTreeNode(ASTContext context, int type, ASTree first, ASTree last, ASTree[] sub) {
        super(context, type);
        this.firstToken = first.getFirstToken();
        this.lastToken = last.getLastToken();
        this.subTrees = sub;
    }

    ASTreeNode(ASTContext context, int type, ASTree first, ASTree last, ASTree sub) {
        this(context, type, first, last, new ASTree[]{sub});
    }

    ASTreeNode(ASTContext context, int type, ASTree token) {
        super(context, type);
        this.subTrees = new ASTree[]{token};
        this.firstToken = token.getFirstToken();
        this.lastToken = token.getLastToken();
    }

    ASTreeNode(ASTContext context, int type, ASTree[] sub) {
        super(context, type);
        this.subTrees = sub;
        this.computeBounds();
    }

    ASTreeNode(ASTContext context, int type, ASTree leftAST, ASTree rightAST) {
        super(context, type);
        this.subTrees = new ASTree[]{leftAST, rightAST};
        this.computeBounds();
    }

    private void computeBounds() {
        int i;
        for (i = 0; i < this.subTrees.length; ++i) {
            if (this.subTrees[i] == null) continue;
            this.firstToken = this.subTrees[i].getFirstToken();
            break;
        }
        for (int j = this.subTrees.length - 1; j >= i; --j) {
            if (this.subTrees[j] == null) continue;
            this.lastToken = this.subTrees[j].getLastToken();
            break;
        }
    }

    final ASTClass setLastToken(ASTree token) {
        this.lastToken = token.getLastToken();
        return this;
    }

    final ASTClass setLastToken(int tokenIndex) {
        this.lastToken = tokenIndex;
        return this;
    }

    public final int getLastToken() {
        return this.lastToken;
    }

    final ASTClass setFirstToken(ASTree token) {
        this.firstToken = token.getFirstToken();
        return this;
    }

    final ASTClass setFirstToken(int tokenIndex) {
        this.firstToken = tokenIndex;
        return this;
    }

    public final int getFirstToken() {
        return this.firstToken;
    }

    final ASTClass addSubTree(ASTree sub) {
        if (this.subTrees != null) {
            int size = this.subTrees.length;
            ASTree[] trees = new ASTree[size + 1];
            System.arraycopy(this.subTrees, 0, trees, 0, size);
            trees[size] = sub;
            this.subTrees = trees;
        } else {
            this.subTrees = new ASTree[]{sub};
        }
        if (sub != null) {
            this.lastToken = sub.getLastToken();
        }
        return this;
    }

    final ASTClass setFirstAndLastToken(ASTree first, ASTree last) {
        this.firstToken = first.getFirstToken();
        this.lastToken = last.getLastToken();
        return this;
    }

    public final String toString() {
        String text = "ASTreeNode Type:" + this.getType() + "\n{\n";
        if (this.subTrees != null) {
            for (int i = 0; i < this.subTrees.length; ++i) {
                ASTree t = this.subTrees[i];
                String subText = t != null ? t.toString() : "NULL";
                text = text + subText + "\n";
            }
        }
        return text + "}\n";
    }

    public final ASTree[] getSubTrees() {
        return this.subTrees;
    }
}

