/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.clientproject.UpdateHelper;
import org.netbeans.modules.j2ee.clientproject.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

public class AppClientProjectClassPathExtender
implements ProjectClassPathExtender,
PropertyChangeListener {
    private static final String DEFAULT_CLASS_PATH = "javac.classpath";
    private static final String DEFAULT_INCLUDED_LIBS_ELEMENT = "included-library";
    private Project project;
    private UpdateHelper helper;
    private ReferenceHelper refHelper;
    private PropertyEvaluator eval;
    private ClassPathSupport cs;
    private volatile boolean projectDeleted;

    public AppClientProjectClassPathExtender(Project project, UpdateHelper helper, PropertyEvaluator eval, ReferenceHelper refHelper) {
        this.project = project;
        this.helper = helper;
        this.eval = eval;
        this.refHelper = refHelper;
        this.cs = new ClassPathSupport(eval, refHelper, helper.getAntProjectHelper(), AppClientProjectProperties.WELL_KNOWN_PATHS, "${libs.", ".classpath}", "${reference.");
        eval.addPropertyChangeListener((PropertyChangeListener)this);
        this.registerLibraryListeners();
    }

    public boolean addLibrary(Library library) throws IOException {
        return this.addLibraries(DEFAULT_CLASS_PATH, new Library[]{library}, DEFAULT_INCLUDED_LIBS_ELEMENT);
    }

    public boolean addLibraries(final String classPathId, final Library[] libraries, final String includedLibrariesElement) throws IOException {
        assert (libraries != null) : "Parameter cannot be null";
        try {
            return (Boolean)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    EditableProperties props = AppClientProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathId);
                    List<ClassPathSupport.Item> resources = AppClientProjectClassPathExtender.this.cs.itemsList(raw, includedLibrariesElement);
                    boolean added = false;
                    for (int i = 0; i < libraries.length; ++i) {
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(libraries[i], null, includedLibrariesElement != null);
                        if (resources.contains(item)) continue;
                        resources.add(item);
                        added = true;
                    }
                    if (added) {
                        String[] itemRefs = AppClientProjectClassPathExtender.this.cs.encodeToStrings(resources.iterator(), includedLibrariesElement);
                        props = AppClientProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathId, itemRefs);
                        AppClientProjectClassPathExtender.this.helper.putProperties("nbproject/project.properties", props);
                        EditableProperties privateProps = AppClientProjectClassPathExtender.this.helper.getProperties("nbproject/private/private.properties");
                        ArrayList<ClassPathSupport.Item> l = new ArrayList<ClassPathSupport.Item>();
                        l.addAll(resources);
                        AppClientProjectProperties.storeLibrariesLocations(l.iterator(), privateProps);
                        AppClientProjectClassPathExtender.this.helper.putProperties("nbproject/private/private.properties", privateProps);
                        ProjectManager.getDefault().saveProject(AppClientProjectClassPathExtender.this.project);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException t = new IOException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)t, (Throwable)e);
        }
    }

    public boolean addArchiveFile(FileObject archiveFile) throws IOException {
        return this.addArchiveFiles(DEFAULT_CLASS_PATH, new FileObject[]{archiveFile}, DEFAULT_INCLUDED_LIBS_ELEMENT);
    }

    public boolean addArchiveFiles(final String classPathId, final FileObject[] archiveFiles, final String includedLibrariesElement) throws IOException {
        assert (archiveFiles != null) : "Parameter cannot be null";
        try {
            return (Boolean)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    EditableProperties props = AppClientProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathId);
                    List<ClassPathSupport.Item> resources = AppClientProjectClassPathExtender.this.cs.itemsList(raw, includedLibrariesElement);
                    boolean added = false;
                    for (int i = 0; i < archiveFiles.length; ++i) {
                        File f = FileUtil.toFile((FileObject)archiveFiles[i]);
                        if (f == null) {
                            throw new IllegalArgumentException("The file must exist on disk");
                        }
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(f, null, includedLibrariesElement != null);
                        if (resources.contains(item)) continue;
                        resources.add(item);
                        added = true;
                    }
                    if (added) {
                        String[] itemRefs = AppClientProjectClassPathExtender.this.cs.encodeToStrings(resources.iterator(), includedLibrariesElement);
                        props = AppClientProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathId, itemRefs);
                        AppClientProjectClassPathExtender.this.helper.putProperties("nbproject/project.properties", props);
                        ProjectManager.getDefault().saveProject(AppClientProjectClassPathExtender.this.project);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException t = new IOException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)t, (Throwable)e);
        }
    }

    public boolean addAntArtifact(AntArtifact artifact, URI artifactElement) throws IOException {
        return this.addAntArtifacts(DEFAULT_CLASS_PATH, new AntArtifactChooser.ArtifactItem[]{new AntArtifactChooser.ArtifactItem(artifact, artifactElement)}, DEFAULT_INCLUDED_LIBS_ELEMENT);
    }

    public boolean addAntArtifacts(final String classPathId, final AntArtifactChooser.ArtifactItem[] artifactItems, final String includedLibrariesElement) throws IOException {
        assert (artifactItems != null) : "Parameter cannot be null";
        try {
            return (Boolean)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    EditableProperties props = AppClientProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                    String raw = props.getProperty(classPathId);
                    List<ClassPathSupport.Item> resources = AppClientProjectClassPathExtender.this.cs.itemsList(raw, includedLibrariesElement);
                    boolean added = false;
                    for (int i = 0; i < artifactItems.length; ++i) {
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(artifactItems[i].getArtifact(), artifactItems[i].getArtifactURI(), null, includedLibrariesElement != null);
                        if (resources.contains(item)) continue;
                        resources.add(item);
                        added = true;
                    }
                    if (added) {
                        String[] itemRefs = AppClientProjectClassPathExtender.this.cs.encodeToStrings(resources.iterator(), includedLibrariesElement);
                        props = AppClientProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                        props.setProperty(classPathId, itemRefs);
                        AppClientProjectClassPathExtender.this.helper.putProperties("nbproject/project.properties", props);
                        ProjectManager.getDefault().saveProject(AppClientProjectClassPathExtender.this.project);
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException t = new IOException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)t, (Throwable)e);
        }
    }

    private void registerLibraryListeners() {
        EditableProperties props = this.helper.getProperties("nbproject/project.properties");
        Library[] libs = LibraryManager.getDefault().getLibraries();
        for (int i = 0; i < libs.length; ++i) {
            libs[i].removePropertyChangeListener((PropertyChangeListener)this);
        }
        Iterator<ClassPathSupport.Item> i = this.cs.itemsIterator(props.getProperty(DEFAULT_CLASS_PATH), DEFAULT_INCLUDED_LIBS_ELEMENT);
        while (i.hasNext()) {
            ClassPathSupport.Item item = i.next();
            if (item.getType() != 1 || item.isBroken()) continue;
            item.getLibrary().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (this.projectDeleted) {
            return;
        }
        if (e.getSource().equals(this.eval) && e.getPropertyName().equals(DEFAULT_CLASS_PATH)) {
            EditableProperties props = this.helper.getProperties("nbproject/project.properties");
            String javacCp = props.getProperty(DEFAULT_CLASS_PATH);
            if (javacCp != null) {
                this.registerLibraryListeners();
                this.storeLibLocations();
            }
        } else if (e.getPropertyName().equals("content")) {
            this.storeLibLocations();
        }
    }

    private void storeLibLocations() {
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                EditableProperties props = AppClientProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                EditableProperties privateProps = AppClientProjectClassPathExtender.this.helper.getProperties("nbproject/private/private.properties");
                List<ClassPathSupport.Item> wmLibs = AppClientProjectClassPathExtender.this.cs.itemsList(props.getProperty(AppClientProjectClassPathExtender.DEFAULT_CLASS_PATH), AppClientProjectClassPathExtender.DEFAULT_INCLUDED_LIBS_ELEMENT);
                AppClientProjectClassPathExtender.this.cs.encodeToStrings(wmLibs.iterator(), AppClientProjectClassPathExtender.DEFAULT_INCLUDED_LIBS_ELEMENT);
                AppClientProjectProperties.storeLibrariesLocations(wmLibs.iterator(), privateProps);
                AppClientProjectClassPathExtender.this.helper.putProperties("nbproject/private/private.properties", privateProps);
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            ProjectManager.getDefault().saveProject(AppClientProjectClassPathExtender.this.project);
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    public void notifyDeleting() {
        this.projectDeleted = true;
        this.eval.removePropertyChangeListener((PropertyChangeListener)this);
    }
}

