# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.


from elisa.core.components.message import Message
from elisa.extern import enum

class MediaLocationMessage(Message):
    """
    Sent when a new device has been found

    @cvar action:           One of L{MediaLocation.ActionType} enum values
    @cvar name:             Name of the device
    @type name:             string
    @cvar fstype:           Filesystem type
    @type fstype:           string
    @cvar mount_point:      Mount point
    @type mount_point:      string
    @cvar media_types:      list of media_types stored on the device
    @type media_types:      list
    @cvar removable:        whether the media location is on a device which can
                            be ejected
    @type removable:        bool
    @cvar theme_icon:       the name of the icon the theme should use for
                            that location to display
    @type theme_icon:       string
    """

    ActionType = enum.Enum('NO_ACTION', 'LOCATION_ADDED', 'LOCATION_REMOVED',
                           'EJECT')

    action = ActionType.NO_ACTION
    name = ''
    fstype = ''
    mount_point = ''
    media_types = ['audio', 'video', 'image']
    removable = False
    theme_icon = None
    
    def __init__(self, action, name, fstype, mount_point, media_types=None,
                 removable=True, theme_icon=None):
        self.action = action
        self.name = name
        self.fstype = fstype
        self.mount_point = mount_point
        if media_types is not None:
            self.media_types = media_types
        self.removable = removable
        self.theme_icon = theme_icon
        
    def __repr__(self):
        return "<MediaLocation %s %s %s>" % (self.action, self.name,
                                             self.mount_point)


