# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

from elisa.core.utils import defer

from elisa.plugins.pigment.widgets.list_vertical import ListVertical

from elisa.plugins.poblesec.base.list import BaseListController
from elisa.plugins.poblesec.base.preview_list import ListItemWidgetWithActions
from elisa.plugins.poblesec.widgets.info_screen import InfoScreen
from elisa.plugins.poblesec.widgets.menu_item import MenuItemWidget

import pgm


class ButtonItem(MenuItemWidget):
    def __init__(self):
        super(ButtonItem, self).__init__(with_artwork_box=False)


class ListItemWidgetWithoutActions(ListItemWidgetWithActions):
    # This is a workaround the fact that the base ListItemWidgetWithActions
    # class has a default style with a width of 0.7 for its item widget.
    pass


class ListInfoScreen(InfoScreen):

    """
    DOCME
    """

    node_widget = ListItemWidgetWithoutActions
    item_widget_cls = ButtonItem

    def __init__(self, contextual_actions, item_widget_name=None):
        self._contextual_actions = contextual_actions
        self._item_widget_name = item_widget_name
        super(ListInfoScreen, self).__init__()

    def create_contents(self):
        widget_kwargs = {'item_widget_cls': self.item_widget_cls,
                         'item_widget_name': self._item_widget_name,
                         'contextual_actions': self._contextual_actions}
        contents = ListVertical(self.node_widget, visible_range_size=9,
                                widget_kwargs=widget_kwargs)
        contents.visible = True
        contents.render_empty_items = True
        return contents


class InfoListController(BaseListController):

    """
    A controller that displays an information screen with a vertical list
    of items/actions associated to the model.
    """

    info_screen_cls = ListInfoScreen

    def set_frontend(self, frontend):
        super(InfoListController, self).set_frontend(frontend)
        self.populate_info()

    def nodes_setup(self):
        item_widget_name = self._view_mode.name
        self.info_screen = self.info_screen_cls(self._contextual_actions,
                                                item_widget_name)
        self.info_screen.set_name('info_screen')
        self.widget.add(self.info_screen)
        self.info_screen.visible = True
        right_panel = self.info_screen.right_panel
        self.nodes = right_panel.contents

    def populate_info(self):
        """
        DOCME
        """
        # To be overridden by subclasses.

        # FIXME: This method returns a deferred, but with the current
        # architecture where set_frontend does not return a deferred, we are
        # loosing it anyway...
        return defer.succeed(None)
