/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.CombinedClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;
import java.util.ArrayList;

public class RMIObjectInputStream
extends ObjectInputStream {
    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = (String)this.getAnnotation();
        try {
            if (string == null) {
                return RMIClassLoader.loadClass(objectStreamClass.getName());
            }
            return RMIClassLoader.loadClass(string, objectStreamClass.getName());
        }
        catch (MalformedURLException malformedURLException) {
            throw new ClassNotFoundException(objectStreamClass.getName());
        }
    }

    protected Object getAnnotation() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        ClassLoader classLoader;
        String string = (String)this.getAnnotation();
        Class[] classArray = new Class[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            classArray[n] = string == null ? RMIClassLoader.loadClass(stringArray[n]) : RMIClassLoader.loadClass(string, stringArray[n]);
            ++n;
        }
        if (classArray.length > 0) {
            ArrayList arrayList = new ArrayList(stringArray.length);
            int n2 = 0;
            while (n2 < classArray.length) {
                ClassLoader classLoader2 = classArray[n2].getClassLoader();
                if (!arrayList.contains(classLoader2)) {
                    arrayList.add(0, classLoader2);
                }
                ++n2;
            }
            classLoader = new CombinedClassLoader(arrayList);
        } else {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            return Proxy.getProxyClass(classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }

    protected Object readValue(Class clazz) throws IOException, ClassNotFoundException {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return this.readBoolean();
            }
            if (clazz == Byte.TYPE) {
                return new Byte(this.readByte());
            }
            if (clazz == Character.TYPE) {
                return new Character(this.readChar());
            }
            if (clazz == Short.TYPE) {
                return new Short(this.readShort());
            }
            if (clazz == Integer.TYPE) {
                return new Integer(this.readInt());
            }
            if (clazz == Long.TYPE) {
                return new Long(this.readLong());
            }
            if (clazz == Float.TYPE) {
                return new Float(this.readFloat());
            }
            if (clazz == Double.TYPE) {
                return new Double(this.readDouble());
            }
            throw new Error("Unsupported primitive class: " + clazz);
        }
        return this.readObject();
    }

    public RMIObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.enableResolveObject(true);
    }
}

