%%<copyright>
%% <year>2003-2008</year>
%% <holder>Ericsson AB, All Rights Reserved</holder>
%%</copyright>
%%<legalnotice>
%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved online at http://www.erlang.org/.
%%
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%%
%% The Initial Developer of the Original Code is Ericsson AB.
%%</legalnotice>
%%

-define(priv_dir,"log_private").
-define(MAIN_PORT,3289).
-define(ACCEPT_TIMEOUT,20000).

%% Target information generated by test_server:init_target_info/0 and 
%% test_server_ctrl:contact_main_target/2
%% Once initiated, this information will never change!!
-record(target_info, {where,           % local | Socket
		      os_family,       % atom(); win32 | unix | vxworks | ose
		      os_type,         % result of os:type()
		      host,            % string(); the name of the target machine
		      version,         % string()
		      system_version,  % string()
		      root_dir,        % string()
		      test_server_dir, % string()
		      emulator,        % string()
		      otp_release,     % string()
		      username,        % string()
		      cookie,          % string(); Cookie for target node
		      naming,          % string(); "-name" | "-sname"
		      master,          % string(); For OSE this is the master
				       % node for main target and slave nodes.
				       % For other platforms the target node
				       % itself is master for slave nodes

		      %% The following are only used for remote targets
		      target_client,   % reference to a client talking to target
		      slave_targets=[]}).% list() of atom(); all available 
				         % targets for starting slavenodes

%% Temporary information generated by test_server_ctrl:read_parameters/X
%% This information is used when starting the main target, and for 
%% initiating the #target_info record.
-record(par, {type,
	      target,
	      slave_targets=[],
	      naming,
	      master,
	      cookie}).
	      
