/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.SizeCache;
import org.eclipse.ui.internal.forms.Messages;
import org.eclipse.ui.internal.forms.widgets.BusyIndicator;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.internal.forms.widgets.FormsResources;

public class FormHeading
extends Canvas {
    private int TITLE_HMARGIN = 10;
    private int TITLE_VMARGIN = 5;
    private int TITLE_GAP = 5;
    private int SEPARATOR_HEIGHT = 6;
    private static final int SEPARATOR = 2;
    private static final int TILED = 4;
    private Image gradientImage;
    private Image image;
    private Color baseBg;
    private int flags;
    private Color separatorColor;
    private GradientInfo gradientInfo;
    private String text;
    private ToolBarManager toolBarManager;
    private SizeCache titleCache = new SizeCache();
    private SizeCache toolbarCache = new SizeCache();
    private SizeCache clientCache = new SizeCache();
    private BusyIndicator busyLabel;
    private Label titleLabel;
    private Control headClient;
    private MessageArea messageArea;

    public FormHeading(Composite parent, int style) {
        super(parent, style);
        this.setBackgroundMode(1);
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                FormHeading.this.onPaint(e.gc);
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                if (FormHeading.this.gradientImage != null) {
                    FormHeading.this.gradientImage.dispose();
                    FormHeading.this.gradientImage = null;
                }
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                if (FormHeading.this.gradientInfo != null) {
                    FormHeading.this.updateGradientImage();
                }
            }
        });
        super.setLayout((Layout)new FormHeadingLayout());
        this.titleLabel = new Label((Composite)this, 64);
        this.titleCache = new SizeCache((Control)this.titleLabel);
    }

    public final Point computeSize(int wHint, int hHint, boolean changed) {
        return ((FormHeadingLayout)this.getLayout()).computeSize((Composite)this, wHint, hHint, changed);
    }

    public final void setLayout(Layout layout) {
    }

    public String getText() {
        return this.text;
    }

    public Image getImage() {
        return this.image;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.titleLabel.setBackground(bg);
        if (this.toolBarManager != null) {
            this.toolBarManager.getControl().setBackground(bg);
        }
        this.baseBg = bg;
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.titleLabel.setForeground(fg);
    }

    public void setText(String text) {
        this.text = text;
        if (this.toolBarManager != null) {
            this.toolBarManager.getControl().setVisible(this.image != null || text != null);
        }
        if (text != null) {
            this.titleCache.setControl((Control)this.titleLabel);
            this.titleLabel.setText(text);
        }
        this.titleLabel.setVisible(text != null);
        this.layout();
        this.redraw();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.titleLabel.setFont(font);
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.toolBarManager != null) {
            this.toolBarManager.getControl().setVisible(image != null || this.text != null);
        }
        if (image != null) {
            this.createBusyLabel();
        } else if (image == null && this.busyLabel != null && !this.busyLabel.isBusy()) {
            this.busyLabel.dispose();
            this.busyLabel = null;
        }
        this.busyLabel.setImage(image);
        this.layout();
    }

    private void createBusyLabel() {
        if (this.busyLabel == null) {
            this.busyLabel = new BusyIndicator((Composite)this, 0);
            if (this.gradientInfo == null && this.getBackgroundImage() == null) {
                this.busyLabel.setBackground(this.getBackground());
            }
        }
    }

    public void setTextBackground(Color[] gradientColors, int[] percents, boolean vertical) {
        this.gradientInfo = new GradientInfo();
        this.gradientInfo.gradientColors = gradientColors;
        this.gradientInfo.percents = percents;
        this.gradientInfo.vertical = vertical;
        this.titleLabel.setBackground(null);
        super.setBackground(null);
        if (this.toolBarManager != null) {
            this.toolBarManager.getControl().setBackground(null);
        }
        if (this.busyLabel != null) {
            this.busyLabel.setBackground(null);
        }
        this.updateGradientImage();
    }

    public void setBackgroundImage(Image image) {
        super.setBackgroundImage(image);
        if (image != null) {
            this.titleLabel.setBackground(null);
            if (this.toolBarManager != null) {
                this.toolBarManager.getControl().setBackground(null);
            }
            if (this.busyLabel != null) {
                this.busyLabel.setBackground(null);
            }
        }
    }

    public IToolBarManager getToolBarManager() {
        if (this.toolBarManager == null) {
            this.toolBarManager = new ToolBarManager(0x800000);
            ToolBar toolbar = this.toolBarManager.createControl((Composite)this);
            toolbar.setBackground(this.getBackground());
            toolbar.setForeground(this.getForeground());
            toolbar.setCursor(FormsResources.getHandCursor());
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (FormHeading.this.toolBarManager != null) {
                        FormHeading.this.toolBarManager.dispose();
                        FormHeading.this.toolBarManager = null;
                    }
                }
            });
        }
        return this.toolBarManager;
    }

    public void updateToolBar() {
        if (this.toolBarManager != null) {
            this.toolBarManager.update(false);
        }
    }

    private void onPaint(GC gc) {
        if (!this.isSeparatorVisible() && this.getBackgroundImage() == null) {
            return;
        }
        Rectangle carea = this.getClientArea();
        Image buffer = new Image((Device)this.getDisplay(), carea.width, carea.height);
        buffer.setBackground(this.getBackground());
        GC igc = new GC((Drawable)buffer);
        igc.setBackground(this.getBackground());
        igc.fillRectangle(0, 0, carea.width, carea.height);
        if (this.getBackgroundImage() != null) {
            if (this.gradientInfo != null || this.isBackgroundImageTiled()) {
                this.drawBackground(igc, carea.x, carea.y, carea.width, carea.height);
            } else {
                Image bgImage = this.getBackgroundImage();
                Rectangle ibounds = bgImage.getBounds();
                this.drawBackground(igc, carea.x, carea.y, ibounds.width, ibounds.height);
            }
        }
        if (this.isSeparatorVisible()) {
            if (this.gradientInfo != null && this.gradientInfo.gradientColors.length >= 2) {
                igc.setBackground(this.gradientInfo.gradientColors[0]);
                igc.setForeground(this.gradientInfo.gradientColors[this.gradientInfo.gradientColors.length - 1]);
                igc.fillGradientRectangle(0, carea.height - this.SEPARATOR_HEIGHT + 3, carea.width, this.SEPARATOR_HEIGHT - 2, this.gradientInfo.vertical);
            }
            igc.setForeground(this.baseBg);
            int[] nArray = new int[8];
            nArray[1] = carea.height - this.SEPARATOR_HEIGHT + 2;
            nArray[2] = 2;
            nArray[3] = carea.height - this.SEPARATOR_HEIGHT;
            nArray[4] = carea.width - 3;
            nArray[5] = carea.height - this.SEPARATOR_HEIGHT;
            nArray[6] = carea.width - 1;
            nArray[7] = carea.height - this.SEPARATOR_HEIGHT + 2;
            igc.drawPolyline(nArray);
            if (this.separatorColor != null) {
                igc.setForeground(this.separatorColor);
            } else {
                igc.setForeground(this.getForeground());
            }
            int[] nArray2 = new int[12];
            nArray2[1] = carea.height;
            nArray2[3] = carea.height - this.SEPARATOR_HEIGHT + 3;
            nArray2[4] = 2;
            nArray2[5] = carea.height - this.SEPARATOR_HEIGHT + 1;
            nArray2[6] = carea.width - 3;
            nArray2[7] = carea.height - this.SEPARATOR_HEIGHT + 1;
            nArray2[8] = carea.width - 1;
            nArray2[9] = carea.height - this.SEPARATOR_HEIGHT + 3;
            nArray2[10] = carea.width - 1;
            nArray2[11] = carea.height;
            igc.drawPolyline(nArray2);
        }
        gc.drawImage(buffer, carea.x, carea.y);
        igc.dispose();
        buffer.dispose();
    }

    private void updateGradientImage() {
        Rectangle rect = this.getBounds();
        boolean vertical = this.gradientInfo.vertical;
        if (this.gradientImage != null) {
            this.gradientImage.dispose();
        }
        int width = vertical ? 1 : rect.width;
        int height = vertical ? rect.height : 1;
        this.gradientImage = new Image((Device)this.getDisplay(), Math.max(width, 1), Math.max(height, 1));
        GC gc = new GC((Drawable)this.gradientImage);
        this.drawTextGradient(gc, width, height);
        gc.dispose();
        this.setBackgroundImage(this.gradientImage);
    }

    private void drawTextGradient(GC gc, int width, int height) {
        Color oldBackground = gc.getBackground();
        if (this.gradientInfo.gradientColors.length == 1) {
            if (this.gradientInfo.gradientColors[0] != null) {
                gc.setBackground(this.gradientInfo.gradientColors[0]);
            }
            gc.fillRectangle(0, 0, width, height);
        } else {
            Color oldForeground = gc.getForeground();
            Color lastColor = this.gradientInfo.gradientColors[0];
            if (lastColor == null) {
                lastColor = oldBackground;
            }
            int pos = 0;
            int i = 0;
            while (i < this.gradientInfo.percents.length) {
                gc.setForeground(lastColor);
                lastColor = this.gradientInfo.gradientColors[i + 1];
                if (lastColor == null) {
                    lastColor = oldBackground;
                }
                gc.setBackground(lastColor);
                if (this.gradientInfo.vertical) {
                    int gradientHeight = this.gradientInfo.percents[i] * height / 100 - pos;
                    gc.fillGradientRectangle(0, pos, width, gradientHeight, true);
                    pos += gradientHeight;
                } else {
                    int gradientWidth = this.gradientInfo.percents[i] * width / 100 - pos;
                    gc.fillGradientRectangle(pos, 0, gradientWidth, height, false);
                    pos += gradientWidth;
                }
                ++i;
            }
            if (this.gradientInfo.vertical && pos < height) {
                gc.setBackground(this.baseBg);
                gc.fillRectangle(0, pos, width, height - pos);
            }
            if (!this.gradientInfo.vertical && pos < width) {
                gc.setBackground(this.baseBg);
                gc.fillRectangle(pos, 0, width - pos, height);
            }
            gc.setForeground(oldForeground);
        }
    }

    public boolean isBackgroundImageTiled() {
        return (this.flags & 4) != 0;
    }

    public void setBackgroundImageTiled(boolean backgroundImageTiled) {
        this.flags = backgroundImageTiled ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public int getBackgroundImageAlignment() {
        return 16384;
    }

    public void setBackgroundImageAlignment(int backgroundImageAlignment) {
    }

    public boolean isBackgroundImageClipped() {
        return true;
    }

    public void setBackgroundImageClipped(boolean backgroundImageClipped) {
    }

    public boolean isSeparatorVisible() {
        return (this.flags & 2) != 0;
    }

    public void setSeparatorVisible(boolean addSeparator) {
        this.flags = addSeparator ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color separatorColor) {
        this.separatorColor = separatorColor;
    }

    public void setMessage(String message) {
        this.setMessage(message, 0);
    }

    public void setMessage(String newMessage, int newType) {
        Image newImage = null;
        if (newMessage != null) {
            switch (newType) {
                case 0: {
                    break;
                }
                case 1: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_info_image");
                    break;
                }
                case 2: {
                    newImage = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                    break;
                }
                case 3: {
                    newImage = JFaceResources.getImage((String)"dialog_message_error_image");
                }
            }
        }
        this.showMessage(newMessage, newImage);
    }

    private void showMessage(String newMessage, Image newImage) {
        if (newMessage == null) {
            if (this.messageArea != null) {
                this.setMessageAreaVisible(false);
            }
        } else {
            if (this.messageArea == null) {
                this.messageArea = new MessageArea((Composite)this, 0);
                this.messageArea.setBackground(this.baseBg);
                this.messageArea.setForeground(this.separatorColor != null ? this.separatorColor : this.getForeground());
            }
            this.messageArea.setText(newMessage);
            this.messageArea.setImage(newImage);
            this.setMessageAreaVisible(true);
        }
    }

    private void setMessageAreaVisible(boolean visible) {
        if (this.messageArea.isMinimized()) {
            if (!visible) {
                this.messageArea.setState(0);
            }
            this.messageArea.setMinimized(false);
        }
        switch (this.messageArea.getState()) {
            case 1: 
            case 2: {
                if (!visible) break;
                return;
            }
            case 0: 
            case 3: {
                if (visible) break;
                return;
            }
        }
        this.messageArea.moveAbove(null);
        this.messageArea.setAnimationStart(true);
        this.messageArea.setState(visible ? 1 : 3);
        this.layout(true);
        Rectangle startBounds = this.messageArea.getBounds();
        final int endY = visible ? startBounds.y - startBounds.height : startBounds.y + startBounds.height;
        Runnable runnable = new Runnable(){

            public void run() {
                final boolean[] result = new boolean[1];
                while (true) {
                    FormHeading.this.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            Point loc = FormHeading.this.messageArea.getLocation();
                            if (FormHeading.this.messageArea.getState() == 1) {
                                --loc.y;
                                if (loc.y > endY) {
                                    FormHeading.this.messageArea.setLocation(loc);
                                } else {
                                    result[0] = true;
                                    FormHeading.this.messageArea.setState(2);
                                    FormHeading.this.layout(true);
                                }
                            } else {
                                ++loc.y;
                                if (loc.y < endY) {
                                    FormHeading.this.messageArea.setLocation(loc);
                                } else {
                                    result[0] = true;
                                    FormHeading.this.messageArea.setState(0);
                                    FormHeading.this.layout(true);
                                }
                            }
                        }
                    });
                    if (result[0]) break;
                    Thread.yield();
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    public boolean isBusy() {
        return this.busyLabel != null && this.busyLabel.isBusy();
    }

    public void setBusy(boolean busy) {
        if (busy) {
            this.createBusyLabel();
        }
        if (busy == this.busyLabel.isBusy()) {
            return;
        }
        this.busyLabel.setBusy(busy);
        this.layout();
    }

    public Control getHeadClient() {
        return this.headClient;
    }

    public void setHeadClient(Control headClient) {
        Assert.isTrue((headClient.getParent() == this ? 1 : 0) != 0);
        this.headClient = headClient;
        this.layout();
    }

    private class GradientInfo {
        Color[] gradientColors;
        int[] percents;
        boolean vertical;

        private GradientInfo() {
        }
    }

    private class MessageArea
    extends Composite {
        static final int BUTTON_BORDER = 17;
        static final int BUTTON_FILL = 25;
        static final int BUTTON_SIZE = 18;
        private Image normal;
        private Image hot;
        static final int CLOSED = 0;
        static final int OPENNING = 1;
        static final int OPEN = 2;
        static final int CLOSING = 3;
        private CLabel label;
        private ImageHyperlink rlink;
        private ImageHyperlink mlink;
        private int state;
        private boolean minimized;
        private boolean animationStart;

        public MessageArea(Composite parent, int style) {
            super(parent, 0);
            this.state = 0;
            Composite container = new Composite((Composite)this, 0);
            GridLayout glayout = new GridLayout();
            glayout.numColumns = 2;
            glayout.marginWidth = 0;
            glayout.marginHeight = 0;
            container.setLayout((Layout)glayout);
            this.label = new CLabel(container, 0);
            this.label.setLayoutData((Object)new GridData(1808));
            this.mlink = new ImageHyperlink(container, 0);
            this.mlink.addHyperlinkListener(new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    MessageArea.this.setMinimized(true);
                }
            });
            this.mlink.setToolTipText(Messages.Form_tooltip_minimize);
            this.rlink = new ImageHyperlink(this, 0);
            this.rlink.addHyperlinkListener(new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    MessageArea.this.setMinimized(false);
                }
            });
            if (FormHeading.this.gradientInfo == null && this.getBackgroundImage() == null) {
                this.rlink.setBackground(this.getBackground());
            }
            this.rlink.setVisible(false);
            this.rlink.setToolTipText(Messages.Form_tooltip_restore);
            this.createMinimizedImages();
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    MessageArea.this.onPaint(e);
                }
            });
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MessageArea.this.disposeMinimizeImages();
                }
            });
            super.setLayout(new Layout(){

                public void layout(Composite parent, boolean changed) {
                    Rectangle carea = MessageArea.this.getClientArea();
                    if (MessageArea.this.minimized) {
                        MessageArea.this.rlink.setBounds(carea.x, carea.y, carea.width, carea.height);
                    } else {
                        MessageArea.this.label.getParent().setBounds(carea.x + 2, carea.y + 2, carea.width - 4, carea.height - 4);
                    }
                }

                public Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
                    Point size = new Point(0, 0);
                    size = MessageArea.this.minimized ? MessageArea.this.rlink.computeSize(wHint, hHint, changed) : MessageArea.this.label.getParent().computeSize(wHint, hHint, changed);
                    if (!MessageArea.this.minimized) {
                        size.x += 4;
                        size.y += 4;
                    }
                    return size;
                }
            });
        }

        public void setMinimized(boolean minimized) {
            this.setBackground(minimized ? null : FormHeading.this.baseBg);
            this.minimized = minimized;
            if (minimized) {
                this.rlink.setImage(this.label.getImage());
            }
            this.rlink.setVisible(minimized);
            this.label.getParent().setVisible(!minimized);
            this.layout();
            FormHeading.this.layout();
            FormHeading.this.redraw();
        }

        public boolean isMinimized() {
            return this.minimized;
        }

        public synchronized void setState(int state) {
            this.state = state;
            if (state == 1) {
                this.setVisible(true);
            } else if (state == 0) {
                this.setVisible(false);
            }
        }

        public int getState() {
            return this.state;
        }

        public void setBackground(Color bg) {
            super.setBackground(bg);
            this.label.setBackground(bg);
            this.mlink.setBackground(bg);
            this.rlink.setBackground(bg);
            this.label.getParent().setBackground(bg);
            this.createMinimizedImages();
        }

        public void setText(String text) {
            this.label.setText(text);
        }

        public void setImage(Image image) {
            this.label.setImage(image);
        }

        public boolean isInTransition() {
            return this.state == 1 || this.state == 3;
        }

        private void onPaint(PaintEvent e) {
            if (this.minimized) {
                return;
            }
            Rectangle carea = this.getClientArea();
            e.gc.setForeground(this.getForeground());
            e.gc.drawPolyline(new int[]{carea.x, carea.y + carea.height - 1, carea.x, carea.y + 2, carea.x + 2, carea.y, carea.x + carea.width - 3, carea.y, carea.x + carea.width - 1, carea.y + 2, carea.x + carea.width - 1, carea.y + carea.height - 1});
        }

        public boolean isAnimationStart() {
            return this.animationStart;
        }

        public void setAnimationStart(boolean animationStart) {
            this.animationStart = animationStart;
        }

        private void createMinimizedImages() {
            this.disposeMinimizeImages();
            this.normal = new Image((Device)this.getDisplay(), 18, 18);
            GC gc = new GC((Drawable)this.normal);
            this.paintNormalImage(this.getDisplay(), gc);
            gc.dispose();
            this.hot = new Image((Device)this.getDisplay(), 18, 18);
            gc = new GC((Drawable)this.hot);
            this.paintHotImage(this.getDisplay(), gc);
            gc.dispose();
            this.mlink.setImage(this.normal);
            this.mlink.setHoverImage(this.hot);
        }

        private void disposeMinimizeImages() {
            if (this.normal != null) {
                this.normal.dispose();
                this.normal = null;
            }
            if (this.hot != null) {
                this.hot.dispose();
                this.hot = null;
            }
        }

        private void paintNormalImage(Display display, GC gc) {
            gc.setForeground(display.getSystemColor(17));
            gc.setBackground(this.getBackground());
            this.paintInnerContent(gc);
        }

        private void paintHotImage(Display display, GC gc) {
            gc.setForeground(display.getSystemColor(17));
            gc.drawRoundRectangle(0, 0, 17, 17, 6, 6);
            this.paintInnerContent(gc);
        }

        private void paintInnerContent(GC gc) {
            int x = 4;
            int y = 2;
            gc.fillRectangle(x, y, 9, 3);
            gc.drawRectangle(x, y, 9, 3);
        }
    }

    private class FormHeadingLayout
    extends Layout
    implements ILayoutExtension {
        private FormHeadingLayout() {
        }

        public int computeMinimumWidth(Composite composite, boolean flushCache) {
            return this.computeSize((Composite)composite, (int)5, (int)-1, (boolean)flushCache).x;
        }

        public int computeMaximumWidth(Composite composite, boolean flushCache) {
            return this.computeSize((Composite)composite, (int)-1, (int)-1, (boolean)flushCache).x;
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int ihHint;
            ToolBar toolBar;
            if (flushCache) {
                FormHeading.this.titleCache.flush();
                FormHeading.this.toolbarCache.flush();
                FormHeading.this.clientCache.flush();
            }
            int width = 0;
            int height = 0;
            Point tbsize = null;
            if (FormHeading.this.headClient != null) {
                FormHeading.this.clientCache.setControl(FormHeading.this.headClient);
                Point clsize = FormHeading.this.clientCache.computeSize(-1, -1);
                if (FormHeading.this.text != null) {
                    width += FormHeading.this.TITLE_GAP;
                }
                width += clsize.x;
                height += clsize.y;
            }
            if (FormHeading.this.toolBarManager != null && (toolBar = FormHeading.this.toolBarManager.getControl()) != null) {
                FormHeading.this.toolbarCache.setControl((Control)toolBar);
                tbsize = FormHeading.this.toolbarCache.computeSize(-1, -1);
                if (FormHeading.this.headClient == null) {
                    if (FormHeading.this.text != null) {
                        width += FormHeading.this.TITLE_GAP;
                    }
                    width += tbsize.x;
                    height = tbsize.y;
                }
            }
            int iwidth = 0;
            int iheight = 0;
            if (FormHeading.this.messageArea != null && FormHeading.this.messageArea.isMinimized()) {
                Point rsize = FormHeading.this.messageArea.computeSize(-1, -1);
                iwidth = Math.max(iwidth, rsize.x);
                iheight = Math.max(iheight, rsize.y);
            }
            if (FormHeading.this.busyLabel != null) {
                Point bsize = FormHeading.this.busyLabel.computeSize(-1, -1);
                iwidth = Math.max(iwidth, bsize.x);
                iheight = Math.max(iheight, bsize.y);
            }
            if (iwidth > 0) {
                if (FormHeading.this.text != null) {
                    width += FormHeading.this.TITLE_GAP;
                }
                width += iwidth;
                height = Math.max(height, iheight);
            }
            if (FormHeading.this.text != null) {
                GC gc = new GC((Drawable)composite);
                gc.setFont(FormHeading.this.getFont());
                if (wHint != -1) {
                    int twHint = wHint - width;
                    Point wsize = FormUtil.computeWrapSize(gc, FormHeading.this.text, twHint);
                    width += wsize.x;
                    height = Math.max(wsize.y, height);
                } else {
                    Point extent = gc.textExtent(FormHeading.this.text);
                    width += extent.x;
                    height = Math.max(extent.y, height);
                }
                gc.dispose();
            }
            int secondRowHeight = 0;
            if (FormHeading.this.headClient != null && tbsize != null) {
                secondRowHeight = tbsize.y;
            }
            if (FormHeading.this.messageArea != null) {
                Point masize = FormHeading.this.messageArea.computeSize(-1, -1);
                if (FormHeading.this.headClient == null) {
                    height = Math.max(masize.y, height);
                } else {
                    secondRowHeight = Math.max(secondRowHeight, masize.y);
                }
            }
            if (secondRowHeight > 0) {
                height += secondRowHeight;
            }
            if (FormHeading.this.isSeparatorVisible()) {
                height += FormHeading.this.SEPARATOR_HEIGHT;
            }
            if (height != 0) {
                height += FormHeading.this.TITLE_VMARGIN * 2;
            }
            if (width != 0) {
                width += FormHeading.this.TITLE_HMARGIN * 2;
            }
            if ((ihHint = hHint) > 0 && ihHint != -1) {
                ihHint -= height;
            }
            return new Point(width, height);
        }

        protected void layout(Composite composite, boolean flushCache) {
            ToolBar toolBar;
            if (flushCache) {
                FormHeading.this.toolbarCache.flush();
            }
            Rectangle carea = composite.getClientArea();
            int height = 0;
            Point tbsize = null;
            Point clsize = null;
            int twidth = carea.width - FormHeading.this.TITLE_HMARGIN * 2;
            if ((FormHeading.this.image != null || FormHeading.this.text != null || FormHeading.this.messageArea != null && FormHeading.this.messageArea.isMinimized()) && FormHeading.this.toolBarManager != null && (toolBar = FormHeading.this.toolBarManager.getControl()) != null) {
                FormHeading.this.toolbarCache.setControl((Control)toolBar);
                tbsize = FormHeading.this.toolbarCache.computeSize(-1, -1);
                if (FormHeading.this.headClient == null) {
                    FormHeading.this.toolbarCache.setBounds(carea.width - 1 - FormHeading.this.TITLE_HMARGIN - tbsize.x, FormHeading.this.TITLE_VMARGIN, tbsize.x, tbsize.y);
                    height = tbsize.y;
                }
            }
            Rectangle clientRect = null;
            if (FormHeading.this.headClient != null) {
                FormHeading.this.clientCache.setControl(FormHeading.this.headClient);
                clsize = FormHeading.this.clientCache.computeSize(-1, -1);
                clientRect = new Rectangle(carea.width - 1 - FormHeading.this.TITLE_HMARGIN - clsize.x, FormHeading.this.TITLE_VMARGIN, clsize.x, clsize.y);
                height = clsize.y;
                twidth -= clsize.x + FormHeading.this.TITLE_GAP;
            }
            if (FormHeading.this.headClient == null && tbsize != null) {
                twidth -= tbsize.x + FormHeading.this.TITLE_GAP;
            }
            int tx = FormHeading.this.TITLE_HMARGIN;
            int iwidth = 0;
            if (FormHeading.this.image != null) {
                Rectangle ibounds = FormHeading.this.image.getBounds();
                iwidth = ibounds.width;
            }
            Point msize = null;
            Point bsize = null;
            int mx = 0;
            if (FormHeading.this.messageArea != null && FormHeading.this.messageArea.isMinimized()) {
                msize = FormHeading.this.messageArea.computeSize(-1, -1);
                iwidth = Math.max(msize.x, iwidth);
                mx = tx;
            }
            if (FormHeading.this.busyLabel != null) {
                bsize = FormHeading.this.busyLabel.computeSize(-1, -1);
                iwidth = Math.max(bsize.x, iwidth);
                mx = tx;
            }
            if (iwidth > 0) {
                tx += iwidth + FormHeading.this.TITLE_GAP;
                if (FormHeading.this.text != null) {
                    twidth -= FormHeading.this.TITLE_GAP;
                }
                twidth -= iwidth;
            }
            Rectangle titleRect = new Rectangle(0, 0, 0, 0);
            if (FormHeading.this.text != null) {
                Point tsize = FormHeading.this.titleCache.computeSize(twidth, -1);
                height = tsize.y;
                if (FormHeading.this.headClient == null) {
                    if (tbsize != null) {
                        height = Math.max(tbsize.y, height);
                    }
                } else {
                    height = Math.max(clsize.y, height);
                }
                int minTextWidth = tsize.x;
                Point realtsize = FormHeading.this.titleCache.computeSize(-1, -1);
                minTextWidth = Math.min(realtsize.x, minTextWidth);
                FormHeading.this.titleCache.setBounds(tx, FormHeading.this.TITLE_VMARGIN, minTextWidth, height);
                titleRect = FormHeading.this.titleCache.getControl().getBounds();
                if (minTextWidth < tsize.x && FormHeading.this.headClient != null) {
                    int hx = tx + minTextWidth + FormHeading.this.TITLE_GAP;
                    int hwidth = carea.width - FormHeading.this.TITLE_HMARGIN - hx;
                    clientRect.x = hx;
                    clientRect.width = hwidth;
                }
            }
            if (FormHeading.this.headClient != null && clientRect != null) {
                FormHeading.this.clientCache.setBounds(clientRect);
            }
            if (msize != null) {
                FormHeading.this.messageArea.setBounds(mx, titleRect.y + titleRect.height / 2 - msize.y / 2, msize.x, msize.y);
            }
            if (bsize != null) {
                FormHeading.this.busyLabel.setBounds(mx, titleRect.y + titleRect.height / 2 - bsize.y / 2, bsize.x, bsize.y);
            }
            if (FormHeading.this.headClient != null && tbsize != null) {
                FormHeading.this.toolbarCache.setBounds(carea.width - 1 - FormHeading.this.TITLE_HMARGIN - tbsize.x, FormHeading.this.TITLE_VMARGIN + (height += FormHeading.this.TITLE_GAP), tbsize.x, tbsize.y);
                height += tbsize.y;
            }
            if (height > 0) {
                height += FormHeading.this.TITLE_VMARGIN * 2;
            }
            if (FormHeading.this.isSeparatorVisible()) {
                height += FormHeading.this.SEPARATOR_HEIGHT;
            }
            if (FormHeading.this.messageArea != null && !FormHeading.this.messageArea.isMinimized() && (FormHeading.this.messageArea.isAnimationStart() || !FormHeading.this.messageArea.isInTransition()) && FormHeading.this.messageArea.isVisible()) {
                int may;
                Point masize = FormHeading.this.messageArea.computeSize(-1, -1);
                int n = may = FormHeading.this.messageArea.isAnimationStart() && FormHeading.this.messageArea.getState() == 1 ? height - 1 : height - 1 - masize.y;
                if (FormHeading.this.isSeparatorVisible()) {
                    may -= FormHeading.this.SEPARATOR_HEIGHT;
                }
                if (FormHeading.this.headClient != null) {
                    may -= 2;
                }
                int mawidth = carea.width - FormHeading.this.TITLE_HMARGIN - FormHeading.this.TITLE_HMARGIN;
                if (tbsize != null) {
                    mawidth -= tbsize.x + FormHeading.this.TITLE_GAP;
                }
                FormHeading.this.messageArea.setBounds(FormHeading.this.TITLE_HMARGIN, may, mawidth, masize.y);
                FormHeading.this.messageArea.setAnimationStart(false);
            }
        }
    }
}

