/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.IMarkerImageProvider;
import org.eclipse.ui.internal.ide.registry.IDERegistryReader;
import org.osgi.framework.Bundle;

public class MarkerImageProviderRegistry {
    private static final String ATT_PROVIDER_CLASS = "class";
    private static final String ATT_ICON = "icon";
    private static final String ATT_MARKER_TYPE = "markertype";
    private static final String ATT_ID = "id";
    private static final String MARKER_ATT_KEY = "org.eclipse.ui.internal.registry.MarkerImageProviderRegistry";
    private static final String TAG_PROVIDER = "imageprovider";
    private ArrayList descriptors = new ArrayList();

    public MarkerImageProviderRegistry() {
        private class MarkerImageReader
        extends IDERegistryReader {
            MarkerImageReader() {
            }

            protected boolean readElement(IConfigurationElement element) {
                if (element.getName().equals(MarkerImageProviderRegistry.TAG_PROVIDER)) {
                    MarkerImageProviderRegistry.this.addProvider(element);
                    return true;
                }
                return false;
            }

            public void readRegistry() {
                this.readRegistry(Platform.getExtensionRegistry(), "org.eclipse.ui.ide", "markerImageProviders");
            }
        }
        new MarkerImageReader().readRegistry();
    }

    public void addProvider(IConfigurationElement element) {
        Descriptor desc = new Descriptor();
        desc.element = element;
        desc.pluginBundle = Platform.getBundle((String)element.getNamespace());
        desc.id = element.getAttribute(ATT_ID);
        desc.markerType = element.getAttribute(ATT_MARKER_TYPE);
        desc.imagePath = element.getAttribute(ATT_ICON);
        desc.className = element.getAttribute(ATT_PROVIDER_CLASS);
        if (desc.imagePath != null) {
            desc.imageDescriptor = this.getImageDescriptor(desc);
        }
        if (desc.className == null) {
            desc.element = null;
            desc.pluginBundle = null;
        }
        this.descriptors.add(desc);
    }

    public ImageDescriptor getImageDescriptor(IMarker marker) {
        int size = this.descriptors.size();
        int i = 0;
        while (i < size) {
            Descriptor desc = (Descriptor)this.descriptors.get(i);
            try {
                if (marker.isSubtypeOf(desc.markerType)) {
                    if (desc.className != null) {
                        if (desc.pluginBundle.getState() == 32) {
                            String path;
                            if (desc.provider == null) {
                                desc.provider = (IMarkerImageProvider)IDEWorkbenchPlugin.createExtension(desc.element, ATT_PROVIDER_CLASS);
                            }
                            if ((path = desc.provider.getImagePath(marker)) != desc.imagePath) {
                                desc.imagePath = path;
                                desc.imageDescriptor = this.getImageDescriptor(desc);
                                return desc.imageDescriptor;
                            }
                            return desc.imageDescriptor;
                        }
                        if (desc.imageDescriptor == null) {
                            desc.imagePath = (String)marker.getAttribute(MARKER_ATT_KEY);
                            desc.imageDescriptor = this.getImageDescriptor(desc);
                        }
                        return desc.imageDescriptor;
                    }
                    if (desc.imageDescriptor != null) {
                        return desc.imageDescriptor;
                    }
                }
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui", 0, "Exception creating image descriptor for: " + desc.markerType, (Throwable)e));
                return null;
            }
            ++i;
        }
        return null;
    }

    ImageDescriptor getImageDescriptor(Descriptor desc) {
        URL url = Platform.find((Bundle)desc.pluginBundle, (IPath)new Path(desc.imagePath));
        return ImageDescriptor.createFromURL((URL)url);
    }

    class Descriptor {
        String id;
        String markerType;
        String className;
        String imagePath;
        ImageDescriptor imageDescriptor;
        IConfigurationElement element;
        Bundle pluginBundle;
        IMarkerImageProvider provider;

        Descriptor() {
        }
    }
}

