/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.Calendar;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileHistory;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSLocalFileRevision;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryFilter;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryFilterAction;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryTableProvider;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.TextViewerAction;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.actions.MoveRemoteTagAction;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ccvs.ui.operations.TagInRepositoryOperation;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOperation;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.actions.CompareRevisionAction;
import org.eclipse.team.internal.ui.actions.OpenRevisionAction;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;
import org.eclipse.team.internal.ui.history.DateHistoryCategory;
import org.eclipse.team.internal.ui.history.DialogHistoryPageSite;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.history.GenericHistoryView;
import org.eclipse.team.internal.ui.history.MessageHistoryCategory;
import org.eclipse.team.internal.ui.history.TypedBufferedContent;
import org.eclipse.team.internal.ui.history.WorkbenchHistoryPageSite;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryCompareAdapter;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class CVSHistoryPage
extends HistoryPage
implements IAdaptable,
IHistoryCompareAdapter {
    ICVSFile file;
    ICVSFile previousFile;
    IFileRevision currentFileRevision;
    CVSFileHistory cvsFileHistory;
    IFileRevision[] entries;
    protected CVSHistoryTableProvider historyTableProvider;
    TreeViewer treeViewer;
    protected TextViewer textViewer;
    protected TableViewer tagViewer;
    CompareRevisionAction compareAction;
    OpenRevisionAction openAction;
    private CVSHistoryFilterAction cvsHistoryFilter;
    private IAction toggleTextAction;
    private IAction toggleTextWrapAction;
    private IAction toggleListAction;
    private IAction toggleFilterAction;
    private TextViewerAction copyAction;
    private TextViewerAction selectAllAction;
    private Action getContentsAction;
    private Action getRevisionAction;
    private Action refreshAction;
    private Action tagWithExistingAction;
    private Action localMode;
    private Action remoteMode;
    private Action remoteLocalMode;
    private Action groupByDateMode;
    private Action collapseAll;
    private Action compareModeAction;
    private SashForm sashForm;
    private SashForm innerSashForm;
    private Image branchImage;
    private Image versionImage;
    protected IFileRevision currentSelection;
    protected RefreshCVSFileHistory refreshCVSFileHistoryJob;
    boolean shutdown = false;
    boolean localFilteredOut = false;
    boolean remoteFilteredOut = false;
    private HistoryResourceListener resourceListener;
    private boolean compareMode = false;
    public static final int REMOTE_LOCAL_MODE = 0;
    public static final int REMOTE_MODE = 1;
    public static final int LOCAL_MODE = 2;
    private int currentFilerMode = 0;
    private boolean groupingOn;
    private CVSHistoryFilter historyFilter;

    public CVSHistoryPage(Object object) {
        this.file = this.getCVSFile(object);
    }

    public void createControl(Composite parent) {
        this.initializeImages();
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.treeViewer = this.createTree((Composite)this.sashForm);
        this.innerSashForm = new SashForm((Composite)this.sashForm, 256);
        this.tagViewer = this.createTagTable(this.innerSashForm);
        this.textViewer = this.createText(this.innerSashForm);
        this.sashForm.setWeights(new int[]{70, 30});
        this.innerSashForm.setWeights(new int[]{50, 50});
        this.contributeActions();
        this.setViewerVisibility();
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        if (parentSite != null && parentSite instanceof DialogHistoryPageSite && this.treeViewer != null) {
            parentSite.setSelectionProvider((ISelectionProvider)this.treeViewer);
        }
        this.resourceListener = new HistoryResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener, 1);
    }

    private TextViewer createText(SashForm parent) {
        TextViewer result = new TextViewer((Composite)parent, 778);
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CVSHistoryPage.this.copyAction.update();
            }
        });
        return result;
    }

    private TableViewer createTagTable(SashForm parent) {
        Table table = new Table((Composite)parent, 66304);
        TableViewer result = new TableViewer(table);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)layout);
        result.setContentProvider((IContentProvider)new SimpleContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return new Object[0];
                }
                Object[] tags = (ITag[])inputElement;
                return tags;
            }
        });
        result.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element == null) {
                    return null;
                }
                ITag tag = (ITag)element;
                if (!(tag instanceof CVSTag)) {
                    return null;
                }
                switch (((CVSTag)tag).getType()) {
                    case 0: 
                    case 1: {
                        return CVSHistoryPage.this.branchImage;
                    }
                    case 2: {
                        return CVSHistoryPage.this.versionImage;
                    }
                }
                return null;
            }

            public String getText(Object element) {
                return ((ITag)element).getName();
            }
        });
        result.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int type2;
                if (!(e1 instanceof ITag) || !(e2 instanceof ITag)) {
                    return super.compare(viewer, e1, e2);
                }
                CVSTag tag1 = (CVSTag)e1;
                CVSTag tag2 = (CVSTag)e2;
                int type1 = tag1.getType();
                if (type1 != (type2 = tag2.getType())) {
                    return type2 - type1;
                }
                return super.compare(viewer, (Object)tag1, (Object)tag2);
            }
        });
        return result;
    }

    public void setFocus() {
        this.sashForm.setFocus();
    }

    protected void contributeActions() {
        IToolBarManager tbm;
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.refreshAction = new Action(CVSUIMessages.HistoryView_refreshLabel, plugin.getImageDescriptor("elcl16/refresh.gif")){

            public void run() {
                CVSHistoryPage.this.refresh();
            }
        };
        this.refreshAction.setToolTipText(CVSUIMessages.HistoryView_refresh);
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/refresh.gif"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/refresh.gif"));
        final IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        this.localMode = new Action(CVSUIMessages.CVSHistoryPage_LocalModeAction, plugin.getImageDescriptor("elcl16/local_history_mode.gif")){

            public void run() {
                if (this.isChecked()) {
                    store.setValue("pref_revision_mode", 2);
                    CVSHistoryPage.this.updateFilterMode(2);
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.localMode.setToolTipText(CVSUIMessages.CVSHistoryPage_LocalModeTooltip);
        this.localMode.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/local_history_mode.gif"));
        this.localMode.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/local_history_mode.gif"));
        this.remoteMode = new Action(CVSUIMessages.CVSHistoryPage_RemoteModeAction, plugin.getImageDescriptor("elcl16/remote_history_mode.gif")){

            public void run() {
                if (this.isChecked()) {
                    store.setValue("pref_revision_mode", 1);
                    CVSHistoryPage.this.updateFilterMode(1);
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.remoteMode.setToolTipText(CVSUIMessages.CVSHistoryPage_RemoteModeTooltip);
        this.remoteMode.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/remote_history_mode.gif"));
        this.remoteMode.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/remote_history_mode.gif"));
        this.remoteLocalMode = new Action(CVSUIMessages.CVSHistoryPage_CombinedModeAction, plugin.getImageDescriptor("elcl16/all_history_mode.gif")){

            public void run() {
                if (this.isChecked()) {
                    store.setValue("pref_revision_mode", 0);
                    CVSHistoryPage.this.updateFilterMode(0);
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.remoteLocalMode.setToolTipText(CVSUIMessages.CVSHistoryPage_CombinedModeTooltip);
        this.remoteLocalMode.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/all_history_mode.gif"));
        this.remoteLocalMode.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/all_history_mode.gif"));
        this.updateFilterMode(store.getInt("pref_revision_mode"));
        this.groupByDateMode = new Action(CVSUIMessages.CVSHistoryPage_GroupByDate, CVSUIPlugin.getPlugin().getImageDescriptor("obj16/dates.gif")){

            public void run() {
                CVSHistoryPage.this.groupingOn = !CVSHistoryPage.this.groupingOn;
                store.setValue("pref_groupbydate_mode", CVSHistoryPage.this.groupingOn);
                CVSHistoryPage.this.refreshHistory(false, false);
            }
        };
        this.groupingOn = store.getBoolean("pref_groupbydate_mode");
        this.groupByDateMode.setChecked(this.groupingOn);
        this.groupByDateMode.setToolTipText(CVSUIMessages.CVSHistoryPage_GroupByDate);
        this.groupByDateMode.setDisabledImageDescriptor(plugin.getImageDescriptor("obj16/dates.gif"));
        this.groupByDateMode.setHoverImageDescriptor(plugin.getImageDescriptor("obj16/dates.gif"));
        this.collapseAll = new Action(CVSUIMessages.CVSHistoryPage_CollapseAllAction, plugin.getImageDescriptor("elcl16/collapseall.gif")){

            public void run() {
                CVSHistoryPage.this.treeViewer.collapseAll();
            }
        };
        this.collapseAll.setToolTipText(CVSUIMessages.CVSHistoryPage_CollapseAllTooltip);
        this.collapseAll.setDisabledImageDescriptor(plugin.getImageDescriptor("elcl16/collapseall.gif"));
        this.collapseAll.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/collapseall.gif"));
        this.compareModeAction = new Action(CVSUIMessages.CVSHistoryPage_CompareModeToggleAction, plugin.getImageDescriptor("eview16/compare_view.gif")){

            public void run() {
                CVSHistoryPage.this.compareMode = !CVSHistoryPage.this.compareMode;
                CVSHistoryPage.this.compareModeAction.setChecked(CVSHistoryPage.this.compareMode);
            }
        };
        this.compareModeAction.setToolTipText(CVSUIMessages.CVSHistoryPage_CompareModeTooltip);
        this.compareModeAction.setDisabledImageDescriptor(plugin.getImageDescriptor("eview16/compare_view.gif"));
        this.compareModeAction.setHoverImageDescriptor(plugin.getImageDescriptor("eview16/compare_view.gif"));
        this.compareModeAction.setChecked(false);
        this.compareAction = new CompareRevisionAction(CVSUIMessages.CVSHistoryPage_CompareRevisionAction);
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSHistoryPage.this.compareAction.setCurrentFileRevision(CVSHistoryPage.this.getCurrentFileRevision());
                CVSHistoryPage.this.compareAction.selectionChanged((IStructuredSelection)CVSHistoryPage.this.treeViewer.getSelection());
            }
        });
        this.compareAction.setPage((HistoryPage)this);
        this.openAction = new OpenRevisionAction(CVSUIMessages.CVSHistoryPage_OpenAction);
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSHistoryPage.this.openAction.selectionChanged((IStructuredSelection)CVSHistoryPage.this.treeViewer.getSelection());
            }
        });
        this.openAction.setPage((HistoryPage)this);
        OpenStrategy handler = new OpenStrategy((Control)this.treeViewer.getTree());
        handler.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                StructuredSelection tableStructuredSelection = (StructuredSelection)CVSHistoryPage.this.treeViewer.getSelection();
                if (CVSHistoryPage.this.compareMode) {
                    StructuredSelection sel = new StructuredSelection(new Object[]{CVSHistoryPage.this.getCurrentFileRevision(), tableStructuredSelection.getFirstElement()});
                    CVSHistoryPage.this.compareAction.selectionChanged((IStructuredSelection)sel);
                    CVSHistoryPage.this.compareAction.run();
                } else {
                    StructuredSelection sel = tableStructuredSelection;
                    CVSHistoryPage.this.openAction.selectionChanged((IStructuredSelection)sel);
                    CVSHistoryPage.this.openAction.run();
                }
            }
        });
        this.getContentsAction = this.getContextMenuAction(CVSUIMessages.HistoryView_getContentsAction, true, new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(null, 100);
                try {
                    try {
                        if (CVSHistoryPage.this.confirmOverwrite() && CVSHistoryPage.this.validateChange()) {
                            IStorage currentStorage = CVSHistoryPage.this.currentSelection.getStorage((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                            InputStream in = currentStorage.getContents();
                            ((IFile)CVSHistoryPage.this.file.getIResource()).setContents(in, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                    }
                    catch (TeamException e) {
                        throw new CoreException(e.getStatus());
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getContentsAction, "org.eclipse.team.cvs.ui.get_file_contents_action_context");
        this.getRevisionAction = this.getContextMenuAction(CVSUIMessages.HistoryView_getRevisionAction, true, new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ICVSRemoteFile remoteFile = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((ICVSResource)((CVSFileRevision)CVSHistoryPage.this.currentSelection).getCVSRemoteFile());
                try {
                    if (CVSHistoryPage.this.confirmOverwrite() && CVSHistoryPage.this.validateChange()) {
                        CVSTag revisionTag = new CVSTag(remoteFile.getRevision(), 2);
                        if (CVSAction.checkForMixingTags(CVSHistoryPage.this.getSite().getShell(), new IResource[]{CVSHistoryPage.this.file.getIResource()}, revisionTag)) {
                            new UpdateOperation(null, new IResource[]{CVSHistoryPage.this.file.getIResource()}, new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES}, revisionTag).run(monitor);
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    CVSHistoryPage.this.refresh();
                                }
                            });
                        }
                    }
                }
                catch (InvocationTargetException e) {
                    CVSException.wrapException((Exception)e);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getRevisionAction, "org.eclipse.team.cvs.ui.get_file_revision_action_context");
        MoveRemoteTagAction tagActionDelegate = new MoveRemoteTagAction(){

            protected ICVSResource[] getSelectedCVSResources() {
                ICVSResource[] resources = super.getSelectedCVSResources();
                if (resources == null || resources.length == 0) {
                    ArrayList<ICVSRemoteFile> logEntrieFiles = null;
                    IStructuredSelection selection = this.getSelection();
                    if (!selection.isEmpty()) {
                        logEntrieFiles = new ArrayList<ICVSRemoteFile>();
                        for (Object next : selection) {
                            IAdaptable a;
                            Object adapter;
                            if (next instanceof CVSFileRevision) {
                                logEntrieFiles.add(((CVSFileRevision)next).getCVSRemoteFile());
                                continue;
                            }
                            if (!(next instanceof IAdaptable) || !((adapter = (a = (IAdaptable)next).getAdapter(ICVSResource.class)) instanceof ICVSResource)) continue;
                            logEntrieFiles.add(((ILogEntry)adapter).getRemoteFile());
                        }
                    }
                    if (logEntrieFiles != null && !logEntrieFiles.isEmpty()) {
                        return logEntrieFiles.toArray(new ICVSResource[logEntrieFiles.size()]);
                    }
                }
                return resources;
            }

            protected ITagOperation createTagOperation() {
                return new TagInRepositoryOperation(this.getTargetPart(), this.getSelectedRemoteResources()){

                    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
                        super.execute(monitor);
                        Display.getDefault().asyncExec(new Runnable(this){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                if (!1.access$0(this.this$2).wasCancelled()) {
                                    17.access$0(1.access$0(this.this$2)).refresh();
                                }
                            }
                        });
                    }

                    static /* synthetic */ 17 access$0(1 var0) {
                        return var0.this;
                    }
                };
            }

            static /* synthetic */ CVSHistoryPage access$0(17 var0) {
                return var0.CVSHistoryPage.this;
            }
        };
        this.tagWithExistingAction = this.getContextMenuAction(CVSUIMessages.HistoryView_tagWithExistingAction, false, new IWorkspaceRunnable((IActionDelegate)tagActionDelegate){
            private final /* synthetic */ IActionDelegate val$tagActionDelegate;
            {
                this.val$tagActionDelegate = iActionDelegate;
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                this.val$tagActionDelegate.selectionChanged((IAction)CVSHistoryPage.this.tagWithExistingAction, CVSHistoryPage.this.treeViewer.getSelection());
                this.val$tagActionDelegate.run((IAction)CVSHistoryPage.this.tagWithExistingAction);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getRevisionAction, "org.eclipse.team.cvs.ui.tag_with_existing_action_context");
        this.toggleTextAction = new Action(TeamUIMessages.GenericHistoryView_ShowCommentViewer){

            public void run() {
                CVSHistoryPage.this.setViewerVisibility();
                store.setValue("pref_show_comments", CVSHistoryPage.this.toggleTextAction.isChecked());
            }
        };
        this.toggleTextAction.setChecked(store.getBoolean("pref_show_comments"));
        this.toggleTextWrapAction = new Action(TeamUIMessages.GenericHistoryView_WrapComments){

            public void run() {
                CVSHistoryPage.this.setViewerVisibility();
                store.setValue("pref_wrap_comments", CVSHistoryPage.this.toggleTextWrapAction.isChecked());
            }
        };
        this.toggleTextWrapAction.setChecked(store.getBoolean("pref_wrap_comments"));
        this.toggleListAction = new Action(TeamUIMessages.GenericHistoryView_ShowTagViewer){

            public void run() {
                CVSHistoryPage.this.setViewerVisibility();
                store.setValue("pref_show_tags", CVSHistoryPage.this.toggleListAction.isChecked());
            }
        };
        this.toggleListAction.setChecked(store.getBoolean("pref_show_tags"));
        this.toggleFilterAction = new Action(CVSUIMessages.CVSHistoryPage_NoFilter){

            public void run() {
                IWorkbenchPart part;
                if (CVSHistoryPage.this.historyFilter != null) {
                    CVSHistoryPage.this.treeViewer.removeFilter((ViewerFilter)CVSHistoryPage.this.historyFilter);
                }
                CVSHistoryPage.this.historyFilter = null;
                IHistoryPageSite historyPageSite = CVSHistoryPage.this.getHistoryPageSite();
                if (historyPageSite instanceof WorkbenchHistoryPageSite && (part = ((WorkbenchHistoryPageSite)historyPageSite).getPart()) instanceof GenericHistoryView) {
                    ((GenericHistoryView)part).updateContentDescription(CVSHistoryPage.this.file.getName());
                }
                CVSHistoryPage.this.toggleFilterAction.setEnabled(false);
            }
        };
        this.toggleFilterAction.setEnabled(this.historyFilter != null);
        this.cvsHistoryFilter = new CVSHistoryFilterAction(this);
        this.cvsHistoryFilter.setText(CVSUIMessages.CVSHistoryPage_FilterOn);
        this.cvsHistoryFilter.init(this.treeViewer);
        this.cvsHistoryFilter.setToolTipText(CVSUIMessages.CVSHistoryPage_FilterHistoryTooltip);
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                CVSHistoryPage.this.fillTableMenu(menuMgr);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.treeViewer.getTree().setMenu(menu);
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        if (!parentSite.isModal()) {
            IPageSite pageSite;
            IWorkbenchPart part = parentSite.getPart();
            if (part != null) {
                IWorkbenchPartSite workbenchPartSite = part.getSite();
                workbenchPartSite.registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
            }
            if ((pageSite = parentSite.getWorkbenchPageSite()) != null) {
                IActionBars actionBars = pageSite.getActionBars();
                IMenuManager actionBarsMenu = actionBars.getMenuManager();
                if (actionBarsMenu != null) {
                    actionBarsMenu.add(this.toggleTextWrapAction);
                    actionBarsMenu.add((IContributionItem)new Separator());
                    actionBarsMenu.add(this.toggleTextAction);
                    actionBarsMenu.add(this.toggleListAction);
                    actionBarsMenu.add((IContributionItem)new Separator());
                    actionBarsMenu.add((IAction)this.cvsHistoryFilter);
                    actionBarsMenu.add(this.toggleFilterAction);
                }
                this.copyAction = new TextViewerAction((ITextViewer)this.textViewer, 4);
                this.copyAction.setText(CVSUIMessages.HistoryView_copy);
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.copyAction);
                this.selectAllAction = new TextViewerAction((ITextViewer)this.textViewer, 7);
                this.selectAllAction.setText(CVSUIMessages.HistoryView_selectAll);
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this.selectAllAction);
                actionBars.updateActionBars();
            }
        }
        if ((tbm = parentSite.getToolBarManager()) != null) {
            String fileNameQualifier = this.getFileNameQualifier();
            tbm.add((IContributionItem)new Separator(String.valueOf(fileNameQualifier) + "grouping"));
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "grouping", (IAction)this.groupByDateMode);
            tbm.add((IContributionItem)new Separator(String.valueOf(fileNameQualifier) + "modes"));
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "modes", (IAction)this.remoteLocalMode);
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "modes", (IAction)this.localMode);
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "modes", (IAction)this.remoteMode);
            tbm.add((IContributionItem)new Separator(String.valueOf(fileNameQualifier) + "collapse"));
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "collapse", (IAction)this.collapseAll);
            if (!parentSite.isModal()) {
                tbm.appendToGroup(String.valueOf(fileNameQualifier) + "collapse", (IAction)this.compareModeAction);
            }
            tbm.update(false);
        }
        menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                CVSHistoryPage.this.fillTextMenu(menuMgr);
            }
        });
        StyledText text = this.textViewer.getTextWidget();
        menu = menuMgr.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private String getFileNameQualifier() {
        return Long.toString(System.currentTimeMillis());
    }

    private boolean isLocalHistoryFilteredOut() {
        return this.localFilteredOut;
    }

    private boolean isRemoteHistoryFilteredOut() {
        return this.remoteFilteredOut;
    }

    void fillTableMenu(IMenuManager manager) {
        IStructuredSelection tempSelection;
        ISelection sel;
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        manager.add((IContributionItem)new Separator("group.file"));
        if (this.file != null && !parentSite.isModal()) {
            manager.add((IAction)this.openAction);
            manager.add((IAction)this.compareAction);
            manager.add((IContributionItem)new Separator("openCompare"));
        }
        if (this.file != null && !(this.file instanceof RemoteFile) && !(sel = this.treeViewer.getSelection()).isEmpty() && sel instanceof IStructuredSelection && (tempSelection = (IStructuredSelection)sel).size() == 1) {
            manager.add((IAction)this.getContentsAction);
            if (!(tempSelection.getFirstElement() instanceof LocalFileRevision)) {
                manager.add((IAction)this.getRevisionAction);
                manager.add((IContributionItem)new Separator());
                if (!parentSite.isModal()) {
                    manager.add((IAction)this.tagWithExistingAction);
                }
            }
        }
        if (!parentSite.isModal()) {
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IAction)this.refreshAction);
            manager.add((IContributionItem)new Separator("additions-end"));
        }
    }

    private void fillTextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.selectAllAction);
    }

    protected TreeViewer createTree(Composite parent) {
        this.historyTableProvider = new CVSHistoryTableProvider();
        TreeViewer viewer = this.historyTableProvider.createTree(parent);
        viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (CVSHistoryPage.this.entries != null) {
                    return CVSHistoryPage.this.entries;
                }
                if (!(inputElement instanceof IFileHistory) && !(inputElement instanceof AbstractHistoryCategory[])) {
                    return new Object[0];
                }
                if (inputElement instanceof AbstractHistoryCategory[]) {
                    return (AbstractHistoryCategory[])inputElement;
                }
                IFileHistory fileHistory = (IFileHistory)inputElement;
                CVSHistoryPage.this.entries = fileHistory.getFileRevisions();
                return CVSHistoryPage.this.entries;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                CVSHistoryPage.this.entries = null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof AbstractHistoryCategory) {
                    return ((AbstractHistoryCategory)parentElement).getRevisions();
                }
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                IFileRevision[] revs;
                if (element instanceof AbstractHistoryCategory && (revs = ((AbstractHistoryCategory)element).getRevisions()) != null) {
                    return revs.length > 0;
                }
                return false;
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    CVSHistoryPage.this.textViewer.setDocument((IDocument)new Document(""));
                    CVSHistoryPage.this.tagViewer.setInput(null);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    CVSHistoryPage.this.textViewer.setDocument((IDocument)new Document(""));
                    CVSHistoryPage.this.tagViewer.setInput(null);
                    return;
                }
                Object o = ss.getFirstElement();
                if (o instanceof AbstractHistoryCategory) {
                    CVSHistoryPage.this.textViewer.setDocument((IDocument)new Document(""));
                    CVSHistoryPage.this.tagViewer.setInput(null);
                    return;
                }
                IFileRevision entry = (IFileRevision)o;
                CVSHistoryPage.this.textViewer.setDocument((IDocument)new Document(entry.getComment()));
                CVSHistoryPage.this.tagViewer.setInput((Object)entry.getTags());
            }
        });
        return viewer;
    }

    private Action getContextMenuAction(String title, final boolean needsProgressDialog, final IWorkspaceRunnable action) {
        return new Action(title){

            public void run() {
                block9: {
                    try {
                        if (CVSHistoryPage.this.file == null) {
                            return;
                        }
                        ISelection selection = CVSHistoryPage.this.treeViewer.getSelection();
                        if (!(selection instanceof IStructuredSelection)) {
                            return;
                        }
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        Object o = ss.getFirstElement();
                        if (o instanceof AbstractHistoryCategory) {
                            return;
                        }
                        CVSHistoryPage.this.currentSelection = (IFileRevision)o;
                        if (needsProgressDialog) {
                            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        action.run(monitor);
                                    }
                                    catch (CoreException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                }
                            });
                            break block9;
                        }
                        try {
                            action.run(null);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (InvocationTargetException e) {
                        IHistoryPageSite parentSite = CVSHistoryPage.this.getHistoryPageSite();
                        CVSUIPlugin.openError(parentSite.getShell(), null, null, e, 12);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            public boolean isEnabled() {
                ISelection selection = CVSHistoryPage.this.treeViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                return ss.size() == 1;
            }
        };
    }

    private boolean confirmOverwrite() {
        if (this.file != null && this.file.getIResource().exists()) {
            try {
                if (this.file.isModified(null)) {
                    String title = CVSUIMessages.HistoryView_overwriteTitle;
                    String msg = CVSUIMessages.HistoryView_overwriteMsg;
                    IHistoryPageSite parentSite = this.getHistoryPageSite();
                    final MessageDialog dialog = new MessageDialog(parentSite.getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    final int[] result = new int[1];
                    parentSite.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            result[0] = dialog.open();
                        }
                    });
                    if (result[0] != 0) {
                        return false;
                    }
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return true;
    }

    private boolean validateChange() {
        if (this.file != null && this.file.getIResource().exists()) {
            IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
            factory.change((IFile)this.file.getIResource());
            return IDE.promptToConfirm((Shell)this.getHistoryPageSite().getShell(), (String)CVSUIMessages.CVSHistoryPage_ValidateChangeTitle, (String)NLS.bind((String)CVSUIMessages.CVSHistoryPage_ValidateChangeMessage, (Object[])new String[]{this.file.getName()}), (IResourceDelta)factory.getDelta(), (String[])new String[0], (boolean)true);
        }
        return false;
    }

    public void refresh() {
        this.refreshHistory(true, false);
    }

    private void refreshHistory(boolean refetch, boolean selectOnly) {
        if (this.refreshCVSFileHistoryJob.getState() != 0) {
            this.refreshCVSFileHistoryJob.cancel();
        }
        this.refreshCVSFileHistoryJob.setFileHistory(this.cvsFileHistory);
        IResource resource = this.previousFile.getIResource();
        if (resource != null) {
            IResource workspaceFile = ResourcesPlugin.getWorkspace().getRoot().findMember(resource.getFullPath());
            this.refreshCVSFileHistoryJob.setWorkspaceFile((IFile)workspaceFile);
        }
        this.refreshCVSFileHistoryJob.setSelectOnly(selectOnly);
        this.refreshCVSFileHistoryJob.setRefetchHistory(refetch);
        this.refreshCVSFileHistoryJob.setIncludeLocals(!this.isLocalHistoryFilteredOut());
        this.refreshCVSFileHistoryJob.setIncludeRemote(!this.isRemoteHistoryFilteredOut());
        this.refreshCVSFileHistoryJob.setGrouping(this.groupingOn);
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        Utils.schedule((Job)this.refreshCVSFileHistoryJob, (IWorkbenchSite)this.getWorkbenchSite(parentSite));
    }

    private IWorkbenchPartSite getWorkbenchSite(IHistoryPageSite parentSite) {
        IWorkbenchPart part = parentSite.getPart();
        if (part != null) {
            return part.getSite();
        }
        return null;
    }

    public void selectRevision(String revision) {
        IFileRevision entry = null;
        if (this.entries != null) {
            int i = 0;
            while (i < this.entries.length) {
                if (this.entries[i].getContentIdentifier().equals(revision)) {
                    entry = this.entries[i];
                    break;
                }
                ++i;
            }
        } else if (this.cvsFileHistory != null) {
            entry = this.cvsFileHistory.getFileRevision(revision);
        }
        if (entry != null) {
            StructuredSelection selection = new StructuredSelection((Object)entry);
            this.treeViewer.getTree().setRedraw(false);
            this.treeViewer.setSelection((ISelection)selection, true);
            this.treeViewer.getTree().setRedraw(true);
        } else {
            this.treeViewer.getTree().deselectAll();
        }
    }

    public void selectLocalRevision(long timeStamp) {
        IFileRevision entry = null;
        if (this.entries != null) {
            int i = 0;
            while (i < this.entries.length) {
                if (this.entries[i].getTimestamp() == timeStamp) {
                    entry = this.entries[i];
                    break;
                }
                ++i;
            }
        } else if (this.cvsFileHistory != null) {
            IFileRevision[] tempEntries = this.cvsFileHistory.getFileRevisions();
            int i = 0;
            while (i < tempEntries.length) {
                if (tempEntries[i].getTimestamp() == timeStamp) {
                    entry = tempEntries[i];
                    break;
                }
                ++i;
            }
        }
        if (entry != null) {
            StructuredSelection selection = new StructuredSelection(entry);
            this.treeViewer.getTree().setRedraw(false);
            this.treeViewer.setSelection((ISelection)selection, true);
            this.treeViewer.getTree().setRedraw(true);
        } else {
            this.treeViewer.getTree().deselectAll();
        }
    }

    private ICVSFile getCVSFile(Object object) {
        if (object instanceof IFile) {
            return CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)object));
        }
        Object cvsFileAdapter = Utils.getAdapter((Object)object, ICVSFile.class);
        if (cvsFileAdapter != null) {
            return (ICVSFile)cvsFileAdapter;
        }
        return null;
    }

    void setViewerVisibility() {
        boolean showText = this.toggleTextAction.isChecked();
        boolean showList = this.toggleListAction.isChecked();
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        if (parentSite.isModal()) {
            showText = false;
            showList = false;
        }
        if (showText && showList) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl(null);
        } else if (showText) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.textViewer.getTextWidget());
        } else if (showList) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.tagViewer.getTable());
        } else {
            this.sashForm.setMaximizedControl(this.treeViewer.getControl());
        }
        boolean wrapText = this.toggleTextWrapAction.isChecked();
        this.textViewer.getTextWidget().setWordWrap(wrapText);
    }

    private void initializeImages() {
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.versionImage = plugin.getImageDescriptor("obj16/prjversions_rep.gif").createImage();
        this.branchImage = plugin.getImageDescriptor("obj16/tag.gif").createImage();
    }

    public void dispose() {
        this.shutdown = true;
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
            this.resourceListener = null;
        }
        if (this.branchImage != null) {
            this.branchImage.dispose();
            this.branchImage = null;
        }
        if (this.versionImage != null) {
            this.versionImage.dispose();
            this.versionImage = null;
        }
        if (this.refreshCVSFileHistoryJob != null && this.refreshCVSFileHistoryJob.getState() != 0) {
            this.refreshCVSFileHistoryJob.cancel();
        }
    }

    public IFileRevision getCurrentFileRevision() {
        if (this.currentFileRevision != null) {
            return this.currentFileRevision;
        }
        if (this.file != null) {
            try {
                if (this.file instanceof RemoteFile) {
                    RemoteFile remote = (RemoteFile)this.file;
                    this.currentFileRevision = this.cvsFileHistory.getFileRevision(remote.getContentIdentifier());
                    return this.currentFileRevision;
                }
                IFile localFile = (IFile)this.file.getIResource();
                if (localFile != null) {
                    this.currentFileRevision = new LocalFileRevision(localFile);
                } else if (this.file.getSyncInfo() != null) {
                    this.currentFileRevision = this.cvsFileHistory.getFileRevision(this.file.getSyncInfo().getRevision());
                }
                return this.currentFileRevision;
            }
            catch (CVSException cVSException) {}
        }
        return null;
    }

    public Control getControl() {
        return this.sashForm;
    }

    public boolean isValidInput(Object object) {
        if (object instanceof IResource) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)((IResource)object).getProject());
            if (provider instanceof CVSTeamProvider) {
                return true;
            }
        } else {
            if (object instanceof ICVSRemoteResource) {
                return true;
            }
            if (object instanceof CVSFileRevision) {
                return true;
            }
            if (object instanceof CVSLocalFileRevision) {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return "";
    }

    public IPath getFilePath() {
        if (this.file != null) {
            return this.file.getIResource().getFullPath();
        }
        return null;
    }

    public void setSorter(boolean localDisplayed) {
        this.historyTableProvider.setLocalRevisionsDisplayed(localDisplayed);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IHistoryCompareAdapter.class) {
            return this;
        }
        return null;
    }

    public ICompareInput getCompareInput(Object object) {
        Object o;
        IStructuredSelection ss;
        if (object != null && object instanceof IStructuredSelection && (ss = (IStructuredSelection)object).size() == 1 && (o = ss.getFirstElement()) instanceof IFileRevision) {
            IFileRevision selectedFileRevision = (IFileRevision)o;
            TypedBufferedContent left = new TypedBufferedContent((IFile)this.file.getIResource());
            FileRevisionTypedElement right = new FileRevisionTypedElement(selectedFileRevision);
            DiffNode node = new DiffNode((ITypedElement)left, (ITypedElement)right);
            return node;
        }
        return null;
    }

    public void setClickAction(boolean compare) {
        this.compareMode = !compare;
        this.compareModeAction.run();
    }

    public void prepareInput(ICompareInput input, CompareConfiguration configuration, IProgressMonitor monitor) {
        this.initLabels(input, configuration);
    }

    private void initLabels(ICompareInput input, CompareConfiguration cc) {
        cc.setLeftEditable(false);
        cc.setRightEditable(false);
        String leftLabel = this.getFileRevisionLabel(input.getLeft(), cc);
        cc.setLeftLabel(leftLabel);
        String rightLabel = this.getFileRevisionLabel(input.getRight(), cc);
        cc.setRightLabel(rightLabel);
    }

    private String getFileRevisionLabel(ITypedElement element, CompareConfiguration cc) {
        String label = null;
        if (element instanceof TypedBufferedContent) {
            Date dateFromLong = new Date(((TypedBufferedContent)element).getModificationDate());
            label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_workspace, (Object[])new Object[]{element.getName(), DateFormat.getDateTimeInstance().format(dateFromLong)});
            cc.setLeftEditable(true);
            return label;
        }
        if (element instanceof FileRevisionTypedElement) {
            Object fileObject = ((FileRevisionTypedElement)element).getFileRevision();
            if (fileObject instanceof LocalFileRevision) {
                try {
                    IStorage storage = ((LocalFileRevision)fileObject).getStorage((IProgressMonitor)new NullProgressMonitor());
                    if (Utils.getAdapter((Object)storage, IFileState.class) != null) {
                        label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_localRevision, (Object[])new Object[]{element.getName(), ((FileRevisionTypedElement)element).getTimestamp()});
                    }
                }
                catch (CoreException coreException) {}
            } else {
                label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_repository, (Object[])new Object[]{element.getName(), ((FileRevisionTypedElement)element).getContentIdentifier()});
            }
        }
        return label;
    }

    public String getDescription() {
        try {
            if (this.file != null) {
                return this.file.getRepositoryRelativePath();
            }
        }
        catch (CVSException cVSException) {}
        return null;
    }

    public boolean inputSet() {
        this.currentFileRevision = null;
        Object inputObj = this.getInput();
        ICVSFile cvsFile = this.getCVSFile(inputObj);
        if (cvsFile == null) {
            return false;
        }
        this.file = cvsFile;
        if (this.refreshCVSFileHistoryJob == null) {
            this.refreshCVSFileHistoryJob = new RefreshCVSFileHistory(this);
        }
        boolean needRefresh = this.checkPreviousInput();
        if (inputObj instanceof CVSLocalFileRevision) {
            this.refreshCVSFileHistoryJob.setLocalFileRevision((CVSLocalFileRevision)inputObj);
        } else if (inputObj instanceof IFile) {
            this.refreshCVSFileHistoryJob.setLocalFileRevision(new CVSLocalFileRevision((IFile)inputObj));
        }
        this.refreshCVSFileHistoryJob.setSelectLocal(inputObj instanceof CVSLocalFileRevision || inputObj instanceof IFile);
        if (needRefresh) {
            this.cvsFileHistory = new CVSFileHistory(cvsFile);
            this.cvsFileHistory.includeLocalRevisions(true);
            this.treeViewer.setInput(null);
        }
        this.refreshHistory(needRefresh, !needRefresh);
        return true;
    }

    private boolean checkPreviousInput() {
        if (this.previousFile != null) {
            try {
                if (this.isSameRemote(this.file, this.previousFile) && (this.isSameLocalFile(this.file, this.previousFile) || !this.isLocal(this.file) && this.isLocal(this.previousFile))) {
                    return false;
                }
            }
            catch (CVSException cVSException) {}
        }
        this.previousFile = this.file;
        return true;
    }

    private boolean isLocal(ICVSFile file) {
        return file.getIResource() != null;
    }

    private boolean isSameLocalFile(ICVSFile file, ICVSFile previousFile) {
        IResource r1 = file.getIResource();
        IResource r2 = previousFile.getIResource();
        return r1 != null && r2 != null && r1.equals((Object)r2);
    }

    private boolean isSameRemote(ICVSFile file, ICVSFile previousFile) throws CVSException {
        String path = file.getRepositoryRelativePath();
        String previousPath = previousFile.getRepositoryRelativePath();
        if (path == null && previousPath == null) {
            return true;
        }
        return path != null && previousPath != null && path.equals(previousPath);
    }

    private void updateFilterMode(int mode) {
        this.currentFilerMode = mode;
        switch (mode) {
            case 2: {
                this.localFilteredOut = false;
                this.remoteFilteredOut = true;
                this.localMode.setChecked(true);
                this.remoteMode.setChecked(false);
                this.remoteLocalMode.setChecked(false);
                break;
            }
            case 1: {
                this.localFilteredOut = true;
                this.remoteFilteredOut = false;
                this.localMode.setChecked(false);
                this.remoteMode.setChecked(true);
                this.remoteLocalMode.setChecked(false);
                break;
            }
            case 0: {
                this.localFilteredOut = false;
                this.remoteFilteredOut = false;
                this.localMode.setChecked(false);
                this.remoteMode.setChecked(false);
                this.remoteLocalMode.setChecked(true);
            }
        }
        if (this.refreshCVSFileHistoryJob != null) {
            this.refreshHistory(false, false);
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void showFilter(CVSHistoryFilter filter) {
        IWorkbenchPart part;
        if (this.historyFilter != null) {
            this.treeViewer.removeFilter((ViewerFilter)this.historyFilter);
        }
        this.historyFilter = filter;
        int before = this.cvsFileHistory.getFileRevisions().length;
        this.treeViewer.addFilter((ViewerFilter)this.historyFilter);
        IHistoryPageSite historyPageSite = this.getHistoryPageSite();
        if (historyPageSite instanceof WorkbenchHistoryPageSite && (part = ((WorkbenchHistoryPageSite)historyPageSite).getPart()) instanceof GenericHistoryView) {
            String revisions = NLS.bind((String)CVSUIMessages.CVSHistoryPage_FilterOnMessage, (Object[])new Object[]{new Integer(this.historyFilter.getMatchCount()), new Integer(before)});
            ((GenericHistoryView)part).updateContentDescription(NLS.bind((String)CVSUIMessages.CVSHistoryPage_FilterDescription, (Object[])new Object[]{this.file.getName(), revisions}));
        }
        this.toggleFilterAction.setEnabled(true);
    }

    public void setMode(int flag) {
        switch (flag) {
            case 2: {
                this.localMode.setChecked(true);
                this.localMode.run();
                break;
            }
            case 1: {
                this.remoteMode.setChecked(true);
                this.remoteMode.run();
                break;
            }
            case 0: {
                this.remoteLocalMode.setChecked(true);
                this.remoteLocalMode.run();
            }
        }
        this.refreshHistory(true, false);
    }

    private class RefreshCVSFileHistory
    extends Job {
        private static final int NUMBER_OF_CATEGORIES = 4;
        private CVSFileHistory fileHistory;
        private AbstractHistoryCategory[] categories;
        private boolean grouping;
        private Object[] elementsToExpand;
        private boolean revisionsFound;
        private IFile workspaceFile;
        private CVSHistoryPage page;
        private boolean selectOnly;
        private boolean useLocalSelect;
        private CVSLocalFileRevision localFileRevision;

        public RefreshCVSFileHistory(CVSHistoryPage page) {
            super(CVSUIMessages.HistoryView_fetchHistoryJob);
            this.page = page;
        }

        public void setWorkspaceFile(IFile workspaceFile) {
            this.workspaceFile = workspaceFile;
        }

        public void setIncludeLocals(boolean flag) {
            if (this.fileHistory != null) {
                this.fileHistory.includeLocalRevisions(flag);
            }
        }

        public void setIncludeRemote(boolean flag) {
            if (this.fileHistory != null) {
                this.fileHistory.includeRemoteRevisions(flag);
            }
        }

        public void setRefetchHistory(boolean refetch) {
            if (this.fileHistory != null) {
                this.fileHistory.setRefetchRevisions(refetch);
            }
        }

        public void setFileHistory(CVSFileHistory fileHistory) {
            this.fileHistory = fileHistory;
        }

        public void setGrouping(boolean value) {
            this.grouping = value;
        }

        public void setSelectOnly(boolean select) {
            this.selectOnly = select;
        }

        public void setSelectLocal(boolean localSelect) {
            this.useLocalSelect = localSelect;
        }

        public void setLocalFileRevision(CVSLocalFileRevision localRev) {
            this.localFileRevision = localRev;
        }

        public IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            if (this.fileHistory != null && !CVSHistoryPage.this.shutdown) {
                boolean localFetched = false;
                boolean needsUpdate = true;
                if (!this.fileHistory.isInitialized() && this.fileHistory.isIncludeLocal()) {
                    this.fileHistory.fetchLocalOnly(monitor);
                    this.updateTable();
                    localFetched = true;
                    needsUpdate = false;
                }
                try {
                    this.fileHistory.refresh(monitor);
                    needsUpdate = true;
                }
                catch (TeamException ex) {
                    if (!localFetched) {
                        this.fileHistory.fetchLocalOnly(monitor);
                        needsUpdate = true;
                    }
                    status = new CVSStatus(ex.getStatus().getSeverity(), ex.getStatus().getCode(), ex.getMessage(), (Throwable)ex);
                }
                if (needsUpdate) {
                    this.updateTable();
                }
            }
            if (status != Status.OK_STATUS) {
                this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
                this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
            }
            return status;
        }

        private void updateTable() {
            if (this.grouping) {
                this.revisionsFound = this.sortRevisions();
            }
            Utils.asyncExec((Runnable)new Runnable(){

                public void run() {
                    ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.historyTableProvider.setLocalRevisionsDisplayed(RefreshCVSFileHistory.this.fileHistory.getIncludesExists());
                    ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.historyTableProvider.setFile((IFileHistory)RefreshCVSFileHistory.this.fileHistory, RefreshCVSFileHistory.this.workspaceFile);
                    if (!RefreshCVSFileHistory.this.selectOnly) {
                        if (RefreshCVSFileHistory.this.grouping) {
                            RefreshCVSFileHistory.this.mapExpandedElements(((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.getExpandedElements());
                            ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.getTree().setLinesVisible(RefreshCVSFileHistory.this.revisionsFound);
                            ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.getTree().setRedraw(false);
                            ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.setInput((Object)RefreshCVSFileHistory.this.categories);
                            if (RefreshCVSFileHistory.this.elementsToExpand.length > 0) {
                                ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.setExpandedElements(RefreshCVSFileHistory.this.elementsToExpand);
                            } else {
                                ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.expandAll();
                                Object[] el = ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.getExpandedElements();
                                if (el != null && el.length > 0) {
                                    ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.setSelection((ISelection)new StructuredSelection(el[0]));
                                    ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.getTree().deselectAll();
                                }
                            }
                            ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.getTree().setRedraw(true);
                        } else if (RefreshCVSFileHistory.this.fileHistory.getFileRevisions().length > 0) {
                            ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.getTree().setLinesVisible(true);
                            ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.setInput((Object)RefreshCVSFileHistory.this.fileHistory);
                        } else {
                            RefreshCVSFileHistory.this.categories = new AbstractHistoryCategory[]{RefreshCVSFileHistory.this.getErrorMessage()};
                            ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.getTree().setLinesVisible(false);
                            ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.treeViewer.setInput((Object)RefreshCVSFileHistory.this.categories);
                        }
                    }
                    if (CVSHistoryPage.this.historyFilter != null) {
                        CVSHistoryFilter tempFilter = new CVSHistoryFilter(((CVSHistoryPage)((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this).historyFilter.author, ((CVSHistoryPage)((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this).historyFilter.comment, ((CVSHistoryPage)((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this).historyFilter.fromDate, ((CVSHistoryPage)((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this).historyFilter.toDate, ((CVSHistoryPage)((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this).historyFilter.isOr);
                        CVSHistoryPage.this.showFilter(tempFilter);
                    }
                    if (((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.file != null) {
                        try {
                            if (RefreshCVSFileHistory.this.useLocalSelect) {
                                RefreshCVSFileHistory.this.page.selectLocalRevision(RefreshCVSFileHistory.this.localFileRevision.getTimestamp());
                            } else {
                                byte[] syncBytes = ((RefreshCVSFileHistory)RefreshCVSFileHistory.this).CVSHistoryPage.this.file.getSyncBytes();
                                if (syncBytes != null) {
                                    String workspaceRevision = ResourceSyncInfo.getRevision((byte[])syncBytes);
                                    RefreshCVSFileHistory.this.page.selectRevision(workspaceRevision);
                                }
                            }
                        }
                        catch (CVSException cVSException) {}
                    }
                }
            }, (StructuredViewer)CVSHistoryPage.this.treeViewer);
        }

        private void mapExpandedElements(Object[] expandedElements) {
            HashMap elementMap = new HashMap();
            int i = 0;
            while (i < expandedElements.length) {
                elementMap.put(((DateHistoryCategory)expandedElements[i]).getName(), null);
                ++i;
            }
            ArrayList<AbstractHistoryCategory> expandable = new ArrayList<AbstractHistoryCategory>();
            int i2 = 0;
            while (i2 < this.categories.length) {
                if (elementMap.containsKey(this.categories[i2].getName())) {
                    expandable.add(this.categories[i2]);
                }
                ++i2;
            }
            this.elementsToExpand = new Object[expandable.size()];
            this.elementsToExpand = expandable.toArray(new Object[expandable.size()]);
        }

        private boolean sortRevisions() {
            IFileRevision[] fileRevision = this.fileHistory.getFileRevisions();
            DateHistoryCategory[] tempCategories = new DateHistoryCategory[4];
            Calendar currentCal = Calendar.getInstance();
            tempCategories[0] = new DateHistoryCategory(CVSUIMessages.CVSHistoryPage_Today, currentCal, null);
            Calendar yesterdayCal = Calendar.getInstance();
            yesterdayCal.roll(6, -1);
            tempCategories[1] = new DateHistoryCategory(CVSUIMessages.CVSHistoryPage_Yesterday, yesterdayCal, null);
            Calendar monthCal = Calendar.getInstance();
            monthCal.set(5, 1);
            tempCategories[2] = new DateHistoryCategory(CVSUIMessages.CVSHistoryPage_ThisMonth, monthCal, yesterdayCal);
            tempCategories[3] = new DateHistoryCategory(CVSUIMessages.CVSHistoryPage_Previous, null, monthCal);
            ArrayList<Object> finalCategories = new ArrayList<Object>();
            int i = 0;
            while (i < 4) {
                tempCategories[i].collectFileRevisions(fileRevision, false);
                if (tempCategories[i].hasRevisions()) {
                    finalCategories.add(tempCategories[i]);
                }
                ++i;
            }
            boolean revisionsFound = true;
            if (finalCategories.size() == 0) {
                finalCategories.add(this.getErrorMessage());
                revisionsFound = false;
            }
            this.categories = finalCategories.toArray(new AbstractHistoryCategory[finalCategories.size()]);
            return revisionsFound;
        }

        private MessageHistoryCategory getErrorMessage() {
            String message = "";
            switch (CVSHistoryPage.this.currentFilerMode) {
                case 2: {
                    message = CVSUIMessages.CVSHistoryPage_LocalModeTooltip;
                    break;
                }
                case 1: {
                    message = CVSUIMessages.CVSHistoryPage_RemoteModeTooltip;
                    break;
                }
                case 0: {
                    message = CVSUIMessages.CVSHistoryPage_NoRevisions;
                }
            }
            MessageHistoryCategory messageCategory = new MessageHistoryCategory(NLS.bind((String)CVSUIMessages.CVSHistoryPage_NoRevisionsForMode, (Object[])new String[]{message}));
            return messageCategory;
        }
    }

    private class SimpleContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public Object[] getElements(Object element) {
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class HistoryResourceListener
    implements IResourceChangeListener {
        private HistoryResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            if (CVSHistoryPage.this.file == null || CVSHistoryPage.this.file.getIResource() == null) {
                return;
            }
            IResourceDelta resourceDelta = root.findMember(((IFile)CVSHistoryPage.this.file.getIResource()).getFullPath());
            if (resourceDelta != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        CVSHistoryPage.this.refresh();
                    }
                });
            }
        }
    }
}

