/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class TypedBufferedContent
extends ResourceNode {
    public TypedBufferedContent(IFile resource) {
        super((IResource)resource);
    }

    protected InputStream createStream() throws CoreException {
        return ((IFile)this.getResource()).getContents();
    }

    public void setContent(byte[] contents) {
        if (contents == null) {
            contents = new byte[]{};
        }
        final ByteArrayInputStream is = new ByteArrayInputStream(contents);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IFile file = (IFile)TypedBufferedContent.this.getResource();
                    if (is != null) {
                        if (!file.exists()) {
                            file.create(is, false, monitor);
                        } else {
                            file.setContents(is, false, true, monitor);
                        }
                    } else {
                        file.delete(false, true, monitor);
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            progressService.run(false, false, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        this.fireContentChanged();
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        return null;
    }

    public void fireChange() {
        this.fireContentChanged();
    }
}

