/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermInfosReader;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorsReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.util.BitVector;

final class SegmentReader
extends IndexReader {
    private String segment;
    FieldInfos fieldInfos;
    private FieldsReader fieldsReader;
    TermInfosReader tis;
    TermVectorsReader termVectorsReader;
    BitVector deletedDocs = null;
    private boolean deletedDocsDirty = false;
    private boolean normsDirty = false;
    private boolean undeleteAll = false;
    InputStream freqStream;
    InputStream proxStream;
    CompoundFileReader cfsReader;
    private Hashtable norms = new Hashtable();

    SegmentReader(SegmentInfos sis, SegmentInfo si, boolean closeDir) throws IOException {
        super(si.dir, sis, closeDir);
        this.initialize(si);
    }

    SegmentReader(SegmentInfo si) throws IOException {
        super(si.dir);
        this.initialize(si);
    }

    private void initialize(SegmentInfo si) throws IOException {
        this.segment = si.name;
        Directory cfsDir = this.directory();
        if (this.directory().fileExists(this.segment + ".cfs")) {
            this.cfsReader = new CompoundFileReader(this.directory(), this.segment + ".cfs");
            cfsDir = this.cfsReader;
        }
        this.fieldInfos = new FieldInfos(cfsDir, this.segment + ".fnm");
        this.fieldsReader = new FieldsReader(cfsDir, this.segment, this.fieldInfos);
        this.tis = new TermInfosReader(cfsDir, this.segment, this.fieldInfos);
        if (SegmentReader.hasDeletions(si)) {
            this.deletedDocs = new BitVector(this.directory(), this.segment + ".del");
        }
        this.freqStream = cfsDir.openFile(this.segment + ".frq");
        this.proxStream = cfsDir.openFile(this.segment + ".prx");
        this.openNorms(cfsDir);
        if (this.fieldInfos.hasVectors()) {
            this.termVectorsReader = new TermVectorsReader(cfsDir, this.segment, this.fieldInfos);
        }
    }

    protected final void doCommit() throws IOException {
        if (this.deletedDocsDirty) {
            this.deletedDocs.write(this.directory(), this.segment + ".tmp");
            this.directory().renameFile(this.segment + ".tmp", this.segment + ".del");
        }
        if (this.undeleteAll && this.directory().fileExists(this.segment + ".del")) {
            this.directory().deleteFile(this.segment + ".del");
        }
        if (this.normsDirty) {
            Enumeration values = this.norms.elements();
            while (values.hasMoreElements()) {
                Norm norm = (Norm)values.nextElement();
                if (!norm.dirty) continue;
                norm.reWrite();
            }
        }
        this.deletedDocsDirty = false;
        this.normsDirty = false;
        this.undeleteAll = false;
    }

    protected final void doClose() throws IOException {
        this.fieldsReader.close();
        this.tis.close();
        if (this.freqStream != null) {
            this.freqStream.close();
        }
        if (this.proxStream != null) {
            this.proxStream.close();
        }
        this.closeNorms();
        if (this.termVectorsReader != null) {
            this.termVectorsReader.close();
        }
        if (this.cfsReader != null) {
            this.cfsReader.close();
        }
    }

    static final boolean hasDeletions(SegmentInfo si) throws IOException {
        return si.dir.fileExists(si.name + ".del");
    }

    public boolean hasDeletions() {
        return this.deletedDocs != null;
    }

    static final boolean usesCompoundFile(SegmentInfo si) throws IOException {
        return si.dir.fileExists(si.name + ".cfs");
    }

    static final boolean hasSeparateNorms(SegmentInfo si) throws IOException {
        String[] result = si.dir.list();
        String pattern = si.name + ".f";
        int patternLength = pattern.length();
        for (int i = 0; i < 0; ++i) {
            if (!result[i].startsWith(pattern) || !Character.isDigit(result[i].charAt(patternLength))) continue;
            return true;
        }
        return false;
    }

    protected final void doDelete(int docNum) throws IOException {
        if (this.deletedDocs == null) {
            this.deletedDocs = new BitVector(this.maxDoc());
        }
        this.deletedDocsDirty = true;
        this.undeleteAll = false;
        this.deletedDocs.set(docNum);
    }

    protected final void doUndeleteAll() throws IOException {
        this.deletedDocs = null;
        this.deletedDocsDirty = false;
        this.undeleteAll = true;
    }

    final Vector files() throws IOException {
        int i;
        Vector<String> files = new Vector<String>(16);
        String[] ext = new String[]{"cfs", "fnm", "fdx", "fdt", "tii", "tis", "frq", "prx", "del", "tvx", "tvd", "tvf", "tvp"};
        for (i = 0; i < ext.length; ++i) {
            String name = this.segment + "." + ext[i];
            if (!this.directory().fileExists(name)) continue;
            files.addElement(name);
        }
        for (i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (!fi.isIndexed) continue;
            files.addElement(this.segment + ".f" + i);
        }
        return files;
    }

    public final TermEnum terms() throws IOException {
        return this.tis.terms();
    }

    public final TermEnum terms(Term t) throws IOException {
        return this.tis.terms(t);
    }

    public final synchronized Document document(int n) throws IOException {
        if (this.isDeleted(n)) {
            throw new IllegalArgumentException("attempt to access a deleted document");
        }
        return this.fieldsReader.doc(n);
    }

    public final synchronized boolean isDeleted(int n) {
        return this.deletedDocs != null && this.deletedDocs.get(n);
    }

    public final TermDocs termDocs() throws IOException {
        return new SegmentTermDocs(this);
    }

    public final TermPositions termPositions() throws IOException {
        return new SegmentTermPositions(this);
    }

    public final int docFreq(Term t) throws IOException {
        TermInfo ti = this.tis.get(t);
        if (ti != null) {
            return ti.docFreq;
        }
        return 0;
    }

    public final int numDocs() {
        int n = this.maxDoc();
        if (this.deletedDocs != null) {
            n -= this.deletedDocs.count();
        }
        return n;
    }

    public final int maxDoc() {
        return this.fieldsReader.size();
    }

    public Collection getFieldNames() throws IOException {
        HashSet<String> fieldSet = new HashSet<String>();
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            fieldSet.add(fi.name);
        }
        return fieldSet;
    }

    public Collection getFieldNames(boolean indexed) throws IOException {
        HashSet<String> fieldSet = new HashSet<String>();
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (fi.isIndexed != indexed) continue;
            fieldSet.add(fi.name);
        }
        return fieldSet;
    }

    public Collection getIndexedFieldNames(boolean storedTermVector) {
        HashSet<String> fieldSet = new HashSet<String>();
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (!fi.isIndexed || fi.storeTermVector != storedTermVector) continue;
            fieldSet.add(fi.name);
        }
        return fieldSet;
    }

    public synchronized byte[] norms(String field) throws IOException {
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            return null;
        }
        if (norm.bytes == null) {
            byte[] bytes = new byte[this.maxDoc()];
            this.norms(field, bytes, 0);
            Norm.access$302(norm, bytes);
        }
        return norm.bytes;
    }

    protected final void doSetNorm(int doc, String field, byte value) throws IOException {
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            return;
        }
        norm.dirty = true;
        this.normsDirty = true;
        this.norms((String)field)[doc] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void norms(String field, byte[] bytes, int offset) throws IOException {
        Norm norm = (Norm)this.norms.get(field);
        if (norm == null) {
            return;
        }
        if (norm.bytes != null) {
            System.arraycopy(norm.bytes, 0, bytes, offset, this.maxDoc());
            return;
        }
        InputStream normStream = (InputStream)norm.in.clone();
        try {
            normStream.seek(0L);
            normStream.readBytes(bytes, offset, this.maxDoc());
        }
        finally {
            normStream.close();
        }
    }

    private final void openNorms(Directory cfsDir) throws IOException {
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fi = this.fieldInfos.fieldInfo(i);
            if (!fi.isIndexed) continue;
            String fileName = this.segment + ".f" + fi.number;
            Directory d = this.directory().fileExists(fileName) ? this.directory() : cfsDir;
            this.norms.put(fi.name, new Norm(d.openFile(fileName), fi.number));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeNorms() throws IOException {
        Hashtable hashtable = this.norms;
        synchronized (hashtable) {
            Enumeration enumerator = this.norms.elements();
            while (enumerator.hasMoreElements()) {
                Norm norm = (Norm)enumerator.nextElement();
                norm.in.close();
            }
        }
    }

    public TermFreqVector getTermFreqVector(int docNumber, String field) throws IOException {
        FieldInfo fi = this.fieldInfos.fieldInfo(field);
        if (fi == null || !fi.storeTermVector) {
            return null;
        }
        return this.termVectorsReader.get(docNumber, field);
    }

    public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
        if (this.termVectorsReader == null) {
            return null;
        }
        return this.termVectorsReader.get(docNumber);
    }

    private class Norm {
        private InputStream in;
        private byte[] bytes;
        private boolean dirty;
        private int number;

        public Norm(InputStream in, int number) {
            this.in = in;
            this.number = number;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reWrite() throws IOException {
            OutputStream out = SegmentReader.this.directory().createFile(SegmentReader.this.segment + ".tmp");
            try {
                out.writeBytes(this.bytes, SegmentReader.this.maxDoc());
            }
            finally {
                out.close();
            }
            String fileName = SegmentReader.this.segment + ".f" + this.number;
            SegmentReader.this.directory().renameFile(SegmentReader.this.segment + ".tmp", fileName);
            this.dirty = false;
        }

        static /* synthetic */ byte[] access$302(Norm x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }
    }
}

