/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.parser;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.parser.IStatusContainer;
import org.eclipse.ui.internal.cheatsheets.composite.parser.ITaskParseStrategy;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.w3c.dom.Node;

public class TaskGroupParseStrategy
implements ITaskParseStrategy {
    public void init() {
    }

    public boolean parseElementNode(Node childNode, Node parentNode, AbstractTask parentTask, IStatusContainer status) {
        return false;
    }

    public void parsingComplete(AbstractTask parentTask, IStatusContainer status) {
        String kind = parentTask.getKind();
        if ("sequence".equals(kind)) {
            ICompositeCheatSheetTask[] children = parentTask.getSubtasks();
            AbstractTask previous = null;
            AbstractTask next = null;
            int i = 0;
            while (i < children.length) {
                previous = next;
                next = (AbstractTask)children[i];
                if (previous != null) {
                    next.addRequiredTask(previous);
                }
                ++i;
            }
            this.checkForChildren(parentTask, status);
        } else if ("set".equals(kind)) {
            this.checkForChildren(parentTask, status);
        } else if ("choice".equals(kind)) {
            if (parentTask.getSubtasks().length < 2) {
                String message = NLS.bind((String)Messages.ERROR_PARSING_NO_CHOICE, (Object[])new Object[]{parentTask.getName()});
                status.addStatus(4, message, null);
            }
        } else {
            String message = NLS.bind((String)Messages.ERROR_PARSING_TASK_INVALID_KIND, (Object[])new Object[]{parentTask.getKind(), "taskGroup", parentTask.getName()});
            status.addStatus(4, message, null);
        }
    }

    private void checkForChildren(AbstractTask parentTask, IStatusContainer status) {
        if (parentTask.getSubtasks().length < 1) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_CHILDLESS_TASK_GROUP, (Object[])new Object[]{parentTask.getName()});
            status.addStatus(4, message, null);
        }
    }
}

