/*******************************************************************************
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.javascript.core.internal.langlexer;



/* This file was generated by SableCC (http://www.sablecc.org/). */

import java.io.IOException;
import java.io.PushbackReader;

import org.eclipse.wst.javascript.core.internal.jsparser.lexer.LexerException;
import org.eclipse.wst.javascript.core.internal.jsparser.node.EOF;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TBlank;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TCommenttok;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TDecimalLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TErrorChar;
import org.eclipse.wst.javascript.core.internal.jsparser.node.THexIntegerLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TIdentifier;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TPunctuator1;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TRegularExpressionLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TStringLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TUnterminatedComment;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TUnterminatedStringLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.Token;


public class Lexer implements IRawLexer {


	// todo: add support of 4_232_323 and 0b101010101 perl constants
	// todo: add support for floatingpoint numbers (perl, java, etc)  123.3, 123.2E3, 123.23E-2
	// design: already basically have support for 01242 perl octal values but we don't constrain them to digits 0..7 
	// todo: support perl's   <<"END"      END   also <<'END' and <<END  and   <<FIRST,<<SECOND
	// design: print v102.111.111;  is the same thing as print "foo";  in perl.  We don't support this now.  It's not a big deal though  because it is uncommon.

	public final static int SUPPORT_POUND_COMMENT = 0x1;
	public final static int SUPPORT_SLASHSLASH_COMMENT = 0x2;
	public final static int SUPPORT_0XHEX_LITERALS = 0x4;
	public final static int APOSTROPHE_CAN_START_STRINGS = 0x100;
	public final static int CR_IS_LEGAL_IN_STRING = 0x200;

	//	protected Token token;

	private PushbackReader in;
	private int lpoffset;
	private int line;
	private boolean cr;
	private boolean eof;
	private final StringBuffer text = new StringBuffer();

	protected boolean langSupportSlashSlashComment = true;
	protected boolean langSupportPoundComment = false;
	protected boolean langSupport0xHexLiterals = true;
	protected boolean langCRLFIllegalInString = true;
	protected boolean langAposIsString = true;

	public Lexer(PushbackReader in, int flags) {
		this.in = in;
		// ==> // DataInputStream s = null;
		langSupportSlashSlashComment = (flags & SUPPORT_SLASHSLASH_COMMENT) != 0;
		langSupportPoundComment = (flags & SUPPORT_POUND_COMMENT) != 0;
		langSupport0xHexLiterals = (flags & SUPPORT_0XHEX_LITERALS) != 0;
		langCRLFIllegalInString = (flags & CR_IS_LEGAL_IN_STRING) == 0;
		langAposIsString = (flags & APOSTROPHE_CAN_START_STRINGS) != 0;
	}


	/*
	 protected void filter() throws LexerException, IOException
	 {
	 }
	 private String getText(int acceptLength)
	 {
	 StringBuffer s = new StringBuffer(acceptLength);
	 for(int i = 0; i < acceptLength; i++) {
	 s.append(text.charAt(i));
	 }

	 return s.toString();
	 }
	 */


	private int getChar2() throws IOException {
		if (eof)
			return -1;

		int result = in.read();

		if (result == -1)
			eof = true;

		return result;
	}

	private int getChar() throws IOException {
		int c = getChar2();

		if (c != -1) {
			switch (c) {
				case 10 :
					if (cr) {
						cr = false;
					}
					else {
						line++;
						//						pos = 0;
					}
					break;
				case 13 :
					line++;
					//					pos = 0;
					cr = true;
					break;
				default :
					//					pos++;
					cr = false;
					break;
			}

			lpoffset++;
		}
		return c;
	}

	private Token defaultGetTokenAction(final int start_lpoffset, final int c) throws IOException {
		if (Character.isDigit((char) c)) {
			int c3 = getChar();
			if ((c == '0') || (c3 == 'x') && langSupport0xHexLiterals) {
				while (Character.isDigit((char) c3) || ((c3 >= 'a') && (c3 <= 'f')) || ((c3 >= 'A') && (c3 <= 'F'))) {
					text.append((char) c3);
					c3 = getChar();
					if (c3 == -1) {
						Token tkHexLiteral = new4(text.toString(), start_lpoffset, false);
						return tkHexLiteral;
					}
				}
				Token tkHexLiteral = new4(text.toString(), start_lpoffset, false);
				in.unread(c3);
				lpoffset--;
				return tkHexLiteral;
			}
			else {
				while (Character.isDigit((char) c3)) {
					text.append((char) c3);
					c3 = getChar();
					if (c3 == -1) {
						Token tkDecimalLiteral = new3(text.toString(), start_lpoffset, false);
						return tkDecimalLiteral;
					}
				}
				Token tkDecimalLiteral = new3(text.toString(), start_lpoffset, false);
				in.unread(c3);
				lpoffset--;
				return tkDecimalLiteral;
			}
		}
		else if (Character.isJavaIdentifierStart((char) c)) {
			//if (((c>='a') && (c<='z')) || ((c>='A') && (c<='Z'))) {
			int c3 = getChar();
			//while (() || ((c>='a') && (c<='z')) || ((c>='A') && (c<='Z'))) {
			while (Character.isJavaIdentifierPart((char) c3)) {
				text.append((char) c3);
				c3 = getChar();
				if (c3 == -1) {
					Token tkIdentifier = new9(text.toString(), start_lpoffset, false);
					return tkIdentifier;
				}
			}
			Token tkIdentifier = new9(text.toString(), start_lpoffset, false);
			in.unread(c3);
			lpoffset--;
			return tkIdentifier;
		}
		else {
			if (true) {
				// just recognize a single character.
				// todo: technically if we have characters like > we should look for >=
				//         similarly += for some languages.  But for now it's not terrible to
				//         treat as seperate characters.  
				Token tkPunctuator = new5(text.toString(), start_lpoffset, false);
				return tkPunctuator;

			}
			else {
				// todo: the code below is broken because it will accept }and  as a single token.

				int c3 = getChar();
				while (true) {
					if ((c3 == '\'') || (c3 == '"') || (c3 == '\t') || (c3 == ' ') || (c3 == -1) || (c3 == '\r') || (c3 == '\n')) {
						Token tkIdentifier = new9(text.toString(), start_lpoffset, false);
						if (c3 != -1) {
							in.unread(c3);
							lpoffset--;
						}
						return tkIdentifier;
					}
					text.append((char) c3);
					c3 = getChar();
				}
			}

		}
	}

	public Token getToken() throws IOException, LexerException {

		int start_pos = 0; // todo: remove variable
		int start_line = line;
		int start_lpoffset = lpoffset;


		text.setLength(0);

		{
			int c = getChar();

			if (c == -1) {
				EOF token = new EOF(start_line + 1, start_pos + 1, start_lpoffset);
				return token;
			}
			else {
				text.append((char) c);

				switch (c) {
					case '/' :
						{
							int c2 = getChar();
							if (c2 == '*') {
								text.append((char) c2);
								// state: /*
								int c3 = getChar();
								while (c3 != -1) {
									text.append((char) c3);
									if (c3 == '*') {
										c3 = getChar();
										while (c3 == '*') {
											text.append((char) c3);
											// state: /*...*
											c3 = getChar();
										}
										if (c3 == '/') {
											text.append((char) c3);
											Token tkComment = new1(text.toString(), start_lpoffset, line > start_line);
											// pushBack( accept_length );
											return tkComment;
										}
										else {
											// drop down 
										}
									}
									else {
										c3 = getChar();
									}
								}
								Token tkUntermComment = new7(text.toString(), start_lpoffset, line > start_line);
								// pushBack( accept_length );
								return tkUntermComment;
							}
							else if ((c2 == '/') && langSupportSlashSlashComment) {
								text.append((char) c2);
								int c3 = getChar();
								while ((c3 != -1) && (c3 != 13) && (c3 != 10)) {
									text.append((char) c3);
									c3 = getChar();
								}
								Token tkComment = new1(text.toString(), start_lpoffset, false);
								if (c3 != -1) {
									// eof = false;
									in.unread(c3);
									lpoffset--;
								}
								return tkComment;
							}
							else if (c2 == -1) {
								Token tkSlash = new5("/", //$NON-NLS-1$
											start_lpoffset, false);
								return tkSlash;
							}
							else {
								// return the /
								Token tkSlash = new5("/", //$NON-NLS-1$
											start_lpoffset, false);
								// eof = false;
								in.unread(c2);
								lpoffset--;
								return tkSlash;
							}
						}
					//break;
					case '#' :
						{
							if (langSupportPoundComment) {
								int c3 = getChar();
								while ((c3 != -1) && (c3 != 13) && (c3 != 10)) {
									text.append((char) c3);
									c3 = getChar();
								}
								Token tkComment = new1(text.toString(), start_lpoffset, false);
								if (c3 != -1) {
									// eof = false;
									in.unread(c3);
									lpoffset--;
								}
								return tkComment;
							}
							else {
								Token tkPound = new5("#", //$NON-NLS-1$
											start_lpoffset, false);
								return tkPound;
							}
						}
					//break;
					case ' ' :
					case '\t' :
					case 10 :
					case 13 :
						{
							int c3 = getChar();
							while ((c3 == ' ') || (c3 == 13) || (c3 == 10) || (c3 == '\t')) {
								text.append((char) c3);
								c3 = getChar();
							}
							Token tkBlank = new0(text.toString(), start_lpoffset, false);
							if (c3 != -1) {
								// eof = false;
								in.unread(c3);
								lpoffset--;
							}
							return tkBlank;
						}
					//break;
					case '\'' :
					case '"' :
						{
							int c3 = getChar();
							if ((langAposIsString && (c == '\'')) || (c == '"')) {
								while ((c3 != -1) && (c3 != c)) {
									if (c3 == '\\') {
										text.append((char) c3);
										c3 = getChar();
										if (c3 == -1)
											break;
									}
									if (langCRLFIllegalInString && ((c3 == 10) || (c3 == 13))) {
										Token tkBadString = new7(text.toString(), start_lpoffset, false);
										in.unread(c3);
										lpoffset--;
										return tkBadString;
									}
									text.append((char) c3);
									c3 = getChar();
								}
								if (c3 == -1) {
									Token tkBadString = new7(text.toString(), start_lpoffset, line > start_line);
									return tkBadString;
								}
								else {
									text.append((char) c3);
									Token tkString = new6(text.toString(), start_lpoffset, line > start_line);
									return tkString;
								}
							}
							else {
								// single char
								if (c3 == -1) {
									Token tkBadString = new7(text.toString(), start_lpoffset, false);
									return tkBadString;
								}
								else if (c3 == '\\') {
									text.append((char) c3);
									c3 = getChar();
									if (c3 == -1) {
										Token tkBadString = new7(text.toString(), start_lpoffset, false);
										return tkBadString;
									}
									else if ((c3 == '\t') || (c3 == ' ') || (c3 == 10) || (c3 == 13)) {
										Token tkBadString = new7(text.toString(), start_lpoffset, false);
										in.unread(c3);
										lpoffset--;
										return tkBadString;
									}
								}
								else if ((c3 == 10) || (c3 == 13)) {
									Token tkBadString = new7(text.toString(), start_lpoffset, false);
									in.unread(c3);
									lpoffset--;
									return tkBadString;
								}
								text.append((char) c3);
								c3 = getChar();
								if (c3 == c) {
									Token tkString = new6(text.toString(), start_lpoffset, false);
									return tkString;
								}
								else {
									Token tkBadString = new7(text.toString(), start_lpoffset, false);
									if (c3 != -1) {
										in.unread(c3);
										lpoffset--;
									}
									return tkBadString;
								}
							}
						}
					//break;
					case '<' :
						if (lpoffset > 5) {
							// we only treat <!-- as a comment if it's at the beginning of the region
							return defaultGetTokenAction(start_lpoffset, c);
						}
						{
							int c2 = getChar();
							if (c2 == '=') {
								// <= token
								Token tkPunctuator = new5("<=", //$NON-NLS-1$
											start_lpoffset, false);
								// pushBack( accept_length );
								return tkPunctuator;
							}
							else if (c2 == '!') {
								if (start_lpoffset > 5) {
									in.unread('!');
									lpoffset--;
									Token tkPunctuator = new1("<", //$NON-NLS-1$
												start_lpoffset, false);
									return tkPunctuator;
								}
								text.append((char) c2);
								// state: /*
								int c3 = getChar();
								if (c3 == '-') {
									int c4 = getChar();
									if (c4 == '-') {
										text.append('-');
										text.append('-');
										int c5 = getChar();
										while ((c5 != -1) && (c5 != 13) && (c5 != 10)) {
											text.append((char) c5);
											c5 = getChar();
										}
										Token tkComment = new1(text.toString(), start_lpoffset, false);
										if (c5 != -1) {
											// eof = false;
											in.unread(c5);
											lpoffset--;
										}
										return tkComment;
									}
									else {
										in.unread(c4);
										lpoffset--;
										in.unread('-');
										lpoffset--;
										in.unread('!');
										lpoffset--;
									}
								}
								else {
									in.unread(c3);
									lpoffset--;
									in.unread('!');
									lpoffset--;
								}
							}
							else {
								in.unread(c2);
								lpoffset--;
							}
							// assert: we're only recognizing the initial character and all of the above code has pushed back anything of it's look ahead characters
							{

								Token tkPunctuator = new5("<", //$NON-NLS-1$
											start_lpoffset, false);
								return tkPunctuator;
							}
						}
					//break;
					default :
						return defaultGetTokenAction(start_lpoffset, c);
				}

			}
		}
	}

	// todo: we can eventually remove the line/offset part of the constructors used below
	Token new0(String text, int lpoffset, boolean blContainsLineTerminator) {
		return new TBlank(text, 0, 0, lpoffset, blContainsLineTerminator);
	}

	Token new1(String text, int lpoffset, boolean blContainsLineTerminator) {
		return new TCommenttok(text, 0, 0, lpoffset, blContainsLineTerminator);
	}

	Token new10(String text, int lpoffset, boolean blContainsLineTerminator) {
		return new TErrorChar(text, 0, 0, lpoffset, blContainsLineTerminator);
	}

	Token new2(String text, int lpoffset, boolean blContainsLineTerminator) {
		return new TUnterminatedComment(text, 0, 0, lpoffset, blContainsLineTerminator);
	}

	Token new3(String text, int lpoffset, boolean blContainsLineTerminator) {
		return new TDecimalLiteral(text, 0, 0, lpoffset, blContainsLineTerminator);
	}

	Token new4(String text, int lpoffset, boolean blContainsLineTerminator) {
		return new THexIntegerLiteral(text, 0, 0, lpoffset, blContainsLineTerminator);
	}

	Token new5(String text, int lpoffset, boolean blContainsLineTerminator) {
		return new TPunctuator1(text, 0, 0, lpoffset, blContainsLineTerminator);
	}

	Token new6(String text, int lpoffset, boolean blContainsLineTerminator) {
		return new TStringLiteral(text, 0, 0, lpoffset, blContainsLineTerminator);
	}

	Token new7(String text, int lpoffset, boolean blContainsLineTerminator) {
		return new TUnterminatedStringLiteral(text, 0, 0, lpoffset, blContainsLineTerminator);
	}

	Token new8(String text, int lpoffset, boolean blContainsLineTerminator) {
		return new TRegularExpressionLiteral(text, 0, 0, lpoffset, blContainsLineTerminator);
	}

	Token new9(String text, int lpoffset, boolean blContainsLineTerminator) {
		return new TIdentifier(text, 0, 0, lpoffset, blContainsLineTerminator);
	}

	/*		
	 public Token next() throws LexerException, IOException
	 {
	 while(token == null)
	 {
	 token = getToken();
	 filter();
	 }

	 Token result = token;
	 token = null;
	 return result;
	 }
	 public Token peek() throws LexerException, IOException
	 {
	 while(token == null)
	 {
	 token = getToken();
	 filter();
	 }

	 return token;
	 }
	 private void pushBack(int acceptLength) throws IOException
	 {
	 int length = text.length();
	 for(int i = length - 1; i >= acceptLength; i--)
	 {
	 eof = false;

	 in.unread(text.charAt(i));
	 }
	 }
	 protected void unread(Token token) throws IOException
	 {
	 String text = token.getText();
	 int length = text.length();

	 for(int i = length - 1; i >= 0; i--)
	 {
	 eof = false;

	 in.unread(text.charAt(i));
	 }

	 //pos = token.getPos() - 1;
	 lpoffset = token.getLPOffset();
	 line = token.getLine() - 1;
	 }
	 */
}

